/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.service;

import info.novatec.inspectit.cmr.dao.InvocationDataDao;
import info.novatec.inspectit.cmr.service.ICachedDataService;
import info.novatec.inspectit.cmr.service.IInvocationDataAccessService;
import info.novatec.inspectit.cmr.spring.aop.MethodLog;
import info.novatec.inspectit.communication.comparator.ResultComparator;
import info.novatec.inspectit.communication.data.InvocationSequenceData;
import info.novatec.inspectit.spring.logger.Log;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InvocationDataAccessService
implements IInvocationDataAccessService {
    @Log
    Logger log;
    @Autowired
    private InvocationDataDao invocationDataDao;
    @Autowired
    private ICachedDataService cachedDataService;

    @MethodLog
    public List<InvocationSequenceData> getInvocationSequenceOverview(long platformId, int limit, ResultComparator<InvocationSequenceData> resultComparator) {
        if (null != resultComparator) {
            resultComparator.setCachedDataService(this.cachedDataService);
        }
        List<InvocationSequenceData> result = this.invocationDataDao.getInvocationSequenceOverview(platformId, limit, (Comparator<? super InvocationSequenceData>)resultComparator);
        return result;
    }

    @MethodLog
    public List<InvocationSequenceData> getInvocationSequenceOverview(long platformId, long methodId, int limit, ResultComparator<InvocationSequenceData> resultComparator) {
        if (null != resultComparator) {
            resultComparator.setCachedDataService(this.cachedDataService);
        }
        List<InvocationSequenceData> result = this.invocationDataDao.getInvocationSequenceOverview(platformId, methodId, limit, (Comparator<? super InvocationSequenceData>)resultComparator);
        return result;
    }

    @MethodLog
    public List<InvocationSequenceData> getInvocationSequenceOverview(long platformId, int limit, Date fromDate, Date toDate, ResultComparator<InvocationSequenceData> resultComparator) {
        if (null != resultComparator) {
            resultComparator.setCachedDataService(this.cachedDataService);
        }
        List<InvocationSequenceData> result = this.invocationDataDao.getInvocationSequenceOverview(platformId, limit, fromDate, toDate, (Comparator<? super InvocationSequenceData>)resultComparator);
        return result;
    }

    @MethodLog
    public List<InvocationSequenceData> getInvocationSequenceOverview(long platformId, long methodId, int limit, Date fromDate, Date toDate, ResultComparator<InvocationSequenceData> resultComparator) {
        if (null != resultComparator) {
            resultComparator.setCachedDataService(this.cachedDataService);
        }
        List<InvocationSequenceData> result = this.invocationDataDao.getInvocationSequenceOverview(platformId, methodId, limit, fromDate, toDate, (Comparator<? super InvocationSequenceData>)resultComparator);
        return result;
    }

    @MethodLog
    public List<InvocationSequenceData> getInvocationSequenceOverview(long platformId, Collection<Long> invocationIdCollection, int limit, ResultComparator<InvocationSequenceData> resultComparator) {
        if (null != resultComparator) {
            resultComparator.setCachedDataService(this.cachedDataService);
        }
        List<InvocationSequenceData> result = this.invocationDataDao.getInvocationSequenceOverview(platformId, invocationIdCollection, limit, (Comparator<? super InvocationSequenceData>)resultComparator);
        return result;
    }

    @MethodLog
    public InvocationSequenceData getInvocationSequenceDetail(InvocationSequenceData template) {
        InvocationSequenceData result = this.invocationDataDao.getInvocationSequenceDetail(template);
        return result;
    }

    @PostConstruct
    public void postConstruct() throws Exception {
        if (this.log.isInfoEnabled()) {
            this.log.info("|-Invocation Data Access Service active...");
        }
    }
}

