/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.service;

import info.novatec.inspectit.cmr.dao.DefaultDataDao;
import info.novatec.inspectit.cmr.dao.HttpTimerDataDao;
import info.novatec.inspectit.cmr.service.IHttpTimerDataAccessService;
import info.novatec.inspectit.cmr.spring.aop.MethodLog;
import info.novatec.inspectit.communication.data.HttpTimerData;
import info.novatec.inspectit.spring.logger.Log;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HttpTimerDataAccessService
implements IHttpTimerDataAccessService,
InitializingBean {
    @Log
    Logger log;
    @Autowired
    private HttpTimerDataDao dao;
    @Autowired
    private DefaultDataDao defaultDataDao;

    @MethodLog
    public List<HttpTimerData> getAggregatedTimerData(HttpTimerData httpData, boolean includeRequestMethod) {
        return this.dao.getAggregatedHttpTimerData(httpData, includeRequestMethod);
    }

    @MethodLog
    public List<HttpTimerData> getAggregatedTimerData(HttpTimerData httpData, boolean includeRequestMethod, Date fromDate, Date toDate) {
        return this.dao.getAggregatedHttpTimerData(httpData, includeRequestMethod, fromDate, toDate);
    }

    @MethodLog
    public List<HttpTimerData> getTaggedAggregatedTimerData(HttpTimerData httpData, boolean includeRequestMethod) {
        return this.dao.getTaggedAggregatedHttpTimerData(httpData, includeRequestMethod);
    }

    @MethodLog
    public List<HttpTimerData> getTaggedAggregatedTimerData(HttpTimerData httpData, boolean includeRequestMethod, Date fromDate, Date toDate) {
        return this.dao.getTaggedAggregatedHttpTimerData(httpData, includeRequestMethod, fromDate, toDate);
    }

    public List<HttpTimerData> getChartingHttpTimerDataFromDateToDate(Collection<HttpTimerData> templates, Date fromDate, Date toDate, boolean retrieveByTag) {
        return this.defaultDataDao.getChartingHttpTimerDataFromDateToDate(templates, fromDate, toDate, retrieveByTag);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.log.isInfoEnabled()) {
            this.log.info("|-Http Timer Data Access Service active...");
        }
    }
}

