/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.service;

import info.novatec.inspectit.ci.AgentMappings;
import info.novatec.inspectit.ci.Environment;
import info.novatec.inspectit.ci.Profile;
import info.novatec.inspectit.cmr.ci.ConfigurationInterfaceManager;
import info.novatec.inspectit.cmr.service.IConfigurationInterfaceService;
import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.exception.IErrorCode;
import info.novatec.inspectit.exception.TechnicalException;
import info.novatec.inspectit.exception.enumeration.ConfigurationInterfaceErrorCodeEnum;
import info.novatec.inspectit.spring.logger.Log;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConfigurationInterfaceService
implements IConfigurationInterfaceService {
    @Log
    Logger log;
    @Autowired
    private ConfigurationInterfaceManager ciManager;

    public List<Profile> getAllProfiles() {
        return this.ciManager.getAllProfiles();
    }

    public Profile getProfile(String id) throws BusinessException {
        return this.ciManager.getProfile(id);
    }

    public Profile createProfile(Profile profile) throws BusinessException {
        try {
            return this.ciManager.createProfile(profile);
        }
        catch (JAXBException e) {
            throw new TechnicalException("Create the profile '" + profile.getName() + "'.", (IErrorCode)ConfigurationInterfaceErrorCodeEnum.JAXB_MARSHALLING_OR_DEMARSHALLING_FAILED, (Throwable)e);
        }
        catch (IOException e) {
            throw new TechnicalException("Create the profile '" + profile.getName() + "'.", (IErrorCode)ConfigurationInterfaceErrorCodeEnum.INPUT_OUTPUT_OPERATION_FAILED, (Throwable)e);
        }
    }

    public Profile updateProfile(Profile profile) throws BusinessException {
        try {
            return this.ciManager.updateProfile(profile);
        }
        catch (JAXBException e) {
            throw new TechnicalException("Update the profile '" + profile.getName() + "'.", (IErrorCode)ConfigurationInterfaceErrorCodeEnum.JAXB_MARSHALLING_OR_DEMARSHALLING_FAILED, (Throwable)e);
        }
        catch (IOException e) {
            throw new TechnicalException("Update the profile '" + profile.getName() + "'.", (IErrorCode)ConfigurationInterfaceErrorCodeEnum.INPUT_OUTPUT_OPERATION_FAILED, (Throwable)e);
        }
    }

    public void deleteProfile(Profile profile) throws BusinessException {
        try {
            this.ciManager.deleteProfile(profile);
        }
        catch (IOException e) {
            throw new TechnicalException("Delete the profile '" + profile.getName() + "'.", (IErrorCode)ConfigurationInterfaceErrorCodeEnum.INPUT_OUTPUT_OPERATION_FAILED, (Throwable)e);
        }
    }

    public Collection<Environment> getAllEnvironments() {
        return this.ciManager.getAllEnvironments();
    }

    public Environment getEnvironment(String id) throws BusinessException {
        return this.ciManager.getEnvironment(id);
    }

    public Environment createEnvironment(Environment environment) throws BusinessException {
        try {
            return this.ciManager.createEnvironment(environment);
        }
        catch (JAXBException e) {
            throw new TechnicalException("Create the environment '" + environment.getName() + "'.", (IErrorCode)ConfigurationInterfaceErrorCodeEnum.JAXB_MARSHALLING_OR_DEMARSHALLING_FAILED, (Throwable)e);
        }
        catch (IOException e) {
            throw new TechnicalException("Create the environment '" + environment.getName() + "'.", (IErrorCode)ConfigurationInterfaceErrorCodeEnum.INPUT_OUTPUT_OPERATION_FAILED, (Throwable)e);
        }
    }

    public Environment updateEnvironment(Environment environment) throws BusinessException {
        try {
            return this.ciManager.updateEnvironment(environment, true);
        }
        catch (JAXBException e) {
            throw new TechnicalException("Update the environment '" + environment.getName() + "'.", (IErrorCode)ConfigurationInterfaceErrorCodeEnum.JAXB_MARSHALLING_OR_DEMARSHALLING_FAILED, (Throwable)e);
        }
        catch (IOException e) {
            throw new TechnicalException("Update the environment '" + environment.getName() + "'.", (IErrorCode)ConfigurationInterfaceErrorCodeEnum.INPUT_OUTPUT_OPERATION_FAILED, (Throwable)e);
        }
    }

    public void deleteEnvironment(Environment environment) throws BusinessException {
        try {
            this.ciManager.deleteEnvironment(environment);
        }
        catch (IOException e) {
            throw new TechnicalException("Create the environment '" + environment.getName() + "'.", (IErrorCode)ConfigurationInterfaceErrorCodeEnum.INPUT_OUTPUT_OPERATION_FAILED, (Throwable)e);
        }
    }

    public AgentMappings getAgentMappings() {
        return this.ciManager.getAgentMappings();
    }

    public AgentMappings saveAgentMappings(AgentMappings agentMappings) throws BusinessException {
        try {
            return this.ciManager.saveAgentMappings(agentMappings, true);
        }
        catch (JAXBException e) {
            throw new TechnicalException("Update the agent mappings.", (IErrorCode)ConfigurationInterfaceErrorCodeEnum.JAXB_MARSHALLING_OR_DEMARSHALLING_FAILED, (Throwable)e);
        }
        catch (IOException e) {
            throw new TechnicalException("Update the agent mappings..", (IErrorCode)ConfigurationInterfaceErrorCodeEnum.INPUT_OUTPUT_OPERATION_FAILED, (Throwable)e);
        }
    }

    @PostConstruct
    public void postConstruct() throws Exception {
        if (this.log.isInfoEnabled()) {
            this.log.info("|-Configuration Interface Service active...");
        }
    }
}

