/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.property;

import info.novatec.inspectit.cmr.jaxb.JAXBTransformator;
import info.novatec.inspectit.cmr.property.PropertyUpdateExecutor;
import info.novatec.inspectit.cmr.property.configuration.Configuration;
import info.novatec.inspectit.cmr.property.configuration.PropertySection;
import info.novatec.inspectit.cmr.property.configuration.SingleProperty;
import info.novatec.inspectit.cmr.property.configuration.validation.PropertyValidation;
import info.novatec.inspectit.cmr.property.update.IPropertyUpdate;
import info.novatec.inspectit.cmr.property.update.configuration.ConfigurationUpdate;
import info.novatec.inspectit.cmr.util.ShutdownService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.JAXBException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.xml.sax.SAXException;

@org.springframework.context.annotation.Configuration
public class PropertyManager {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyManager.class);
    public static final String LOCAL_PROPERTIES_BEAN_NAME = "localPropertiesBean";
    private static final String CONFIG_DIR = "config";
    private static final String SCHEMA_DIR = "config" + File.separatorChar + "schema";
    private static final String CONFIGURATION_SCHEMA_FILE = "configurationSchema.xsd";
    private static final String CONFIGURATION_UPDATE_SCHEMA_FILE = "configurationUpdateSchema.xsd";
    private static final String DEFAULT_CONFIG_FILE = "default.xml";
    private static final String CONFIG_UPDATE_FILE = "configurationUpdates.xml";
    private Configuration configuration;
    private ConfigurationUpdate configurationUpdate;
    @Autowired
    private PropertyUpdateExecutor propertyUpdateExecutor;
    @Autowired
    private ShutdownService shutdownService;
    private JAXBTransformator transformator = new JAXBTransformator();

    public Collection<PropertySection> getConfigurationPropertySections() {
        return this.configuration.getSections();
    }

    Configuration getConfiguration() {
        return this.configuration;
    }

    public synchronized void updateConfiguration(ConfigurationUpdate update, boolean executeRestart) throws Exception {
        for (IPropertyUpdate propertyUpdate : update.getPropertyUpdates()) {
            SingleProperty property = this.configuration.forLogicalName(propertyUpdate.getPropertyLogicalName());
            if (null == property) {
                throw new Exception("Property " + propertyUpdate.getPropertyLogicalName() + " can not be updated because the property does not exist in the current configuration.");
            }
            if (property.canUpdate(propertyUpdate)) continue;
            throw new Exception("Property " + propertyUpdate.getPropertyLogicalName() + " can not be updated because the property update value is not valid.");
        }
        ArrayList updatedProperties = new ArrayList();
        for (IPropertyUpdate propertyUpdate : update.getPropertyUpdates()) {
            SingleProperty property = this.configuration.forLogicalName(propertyUpdate.getPropertyLogicalName());
            if (propertyUpdate.isRestoreDefault()) {
                property.setToDefaultValue();
            } else {
                property.setValue(propertyUpdate.getUpdateValue());
            }
            updatedProperties.add(property);
            if (!LOG.isInfoEnabled()) continue;
            LOG.info("Property '" + property.getName() + "' successfully updated, new value is " + property.getFormattedValue());
        }
        if (null == this.configurationUpdate) {
            this.configurationUpdate = update;
        } else {
            this.configurationUpdate.merge(update, true);
        }
        if (Files.exists(this.getConfigurationUpdatePath(), new LinkOption[0])) {
            String backupPathString = this.getConfigurationUpdatePath().toString() + "~" + System.currentTimeMillis() + ".backup";
            Path backupPath = Paths.get(backupPathString, new String[0]);
            try {
                Files.copy(this.getConfigurationUpdatePath(), backupPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                LOG.warn("Could not back up the current configuration update", (Throwable)e);
            }
        }
        try {
            this.transformator.marshall(this.getConfigurationUpdatePath(), this.configurationUpdate, Paths.get(CONFIG_DIR, new String[0]).relativize(this.getConfigurationUpdateSchemaPath()).toString());
        }
        catch (IOException | JAXBException e) {
            LOG.warn("Could not flush the new configuration update", e);
        }
        if (executeRestart) {
            this.shutdownService.restart();
        } else {
            this.propertyUpdateExecutor.executePropertyUpdates(updatedProperties);
        }
    }

    @Bean(name={"localPropertiesBean"})
    protected synchronized Properties getProperties() {
        try {
            this.loadConfigurationAndUpdates();
        }
        catch (IOException | JAXBException | SAXException e) {
            LOG.warn("|-Default CMR configuration can not be loaded.", e);
            return new Properties();
        }
        if (null != this.configurationUpdate) {
            LOG.info("|-Updates to the CMR Configuration found, applying the updates");
            ArrayList<IPropertyUpdate> notValidList = new ArrayList<IPropertyUpdate>();
            for (IPropertyUpdate iPropertyUpdate : this.configurationUpdate.getPropertyUpdates()) {
                SingleProperty property = this.configuration.forLogicalName(iPropertyUpdate.getPropertyLogicalName());
                if (null == property || !property.canUpdate(iPropertyUpdate)) {
                    notValidList.add(iPropertyUpdate);
                    continue;
                }
                if (iPropertyUpdate.isRestoreDefault()) {
                    property.setToDefaultValue();
                    continue;
                }
                property.setValue(iPropertyUpdate.getUpdateValue());
            }
            if (CollectionUtils.isNotEmpty(notValidList)) {
                for (IPropertyUpdate iPropertyUpdate : notValidList) {
                    this.configurationUpdate.removePropertyUpdate(iPropertyUpdate);
                    LOG.info("|-Update of the property " + iPropertyUpdate.getPropertyLogicalName() + " can not be performed either because property does not exist in the default configuration or the update value is not valid");
                }
                try {
                    this.transformator.marshall(this.getConfigurationUpdatePath(), this.configurationUpdate, Paths.get(CONFIG_DIR, new String[0]).relativize(this.getConfigurationUpdateSchemaPath()).toString());
                }
                catch (IOException | JAXBException e) {
                    LOG.warn("|-CMR Configuration update can not be re-written", e);
                }
            }
        } else {
            LOG.info("|-No CMR Configuration updates found, continuing to use default configuration");
        }
        Map validationMap = this.configuration.validate();
        if (MapUtils.isNotEmpty((Map)validationMap)) {
            for (Map.Entry entry : validationMap.entrySet()) {
                LOG.warn(((PropertyValidation)entry.getValue()).getMessage());
            }
        } else {
            LOG.info("|-CMR Configuration verified with no errors");
        }
        Properties properties = new Properties();
        for (SingleProperty property : this.configuration.getAllProperties()) {
            if (validationMap.containsKey(property)) continue;
            property.register(properties);
        }
        return properties;
    }

    @Bean
    protected PropertyManager getPropertyManager() {
        return this;
    }

    Path getDefaultConfigurationPath() {
        return Paths.get(CONFIG_DIR, DEFAULT_CONFIG_FILE);
    }

    Path getConfigurationUpdatePath() {
        return Paths.get(CONFIG_DIR, CONFIG_UPDATE_FILE);
    }

    Path getConfigurationSchemaPath() {
        return Paths.get(SCHEMA_DIR, CONFIGURATION_SCHEMA_FILE);
    }

    Path getConfigurationUpdateSchemaPath() {
        return Paths.get(SCHEMA_DIR, CONFIGURATION_UPDATE_SCHEMA_FILE);
    }

    void loadConfigurationAndUpdates() throws JAXBException, IOException, SAXException {
        LOG.info("|-Loading the default CMR configuration");
        this.configuration = this.transformator.unmarshall(this.getDefaultConfigurationPath(), this.getConfigurationSchemaPath(), Configuration.class);
        this.configurationUpdate = this.transformator.unmarshall(this.getConfigurationUpdatePath(), this.getConfigurationUpdateSchemaPath(), ConfigurationUpdate.class);
    }
}

