/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.dao.impl;

import info.novatec.inspectit.cmr.dao.impl.AbstractJpaDao;
import info.novatec.inspectit.cmr.dao.impl.TimerDataAggregatorCacheCleaner;
import info.novatec.inspectit.communication.data.DatabaseAggregatedTimerData;
import info.novatec.inspectit.communication.data.TimerData;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

@Repository
public class TimerDataAggregator
extends AbstractJpaDao<TimerData> {
    @Value(value="${cmr.aggregationPeriod}")
    long aggregationPeriod;
    @Value(value="${cmr.maxElements}")
    int maxElements;
    @Value(value="${cmr.cacheCleanSleepingPeriod}")
    long cacheCleanSleepingPeriod;
    private AtomicInteger elementCount = new AtomicInteger(0);
    private Map<Integer, TimerData> map = new HashMap<Integer, TimerData>();
    private ConcurrentLinkedQueue<TimerData> queue = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<TimerData> persistList = new ConcurrentLinkedQueue();
    private ReentrantLock persistAllLock = new ReentrantLock();
    private TimerDataAggregatorCacheCleaner timerDataAggregatorCacheCleaner;
    private TransactionTemplate tt;

    @Autowired
    public TimerDataAggregator(PlatformTransactionManager transactionManager) {
        super(TimerData.class);
        this.tt = new TransactionTemplate(transactionManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processTimerData(TimerData timerData) {
        long aggregationTimestamp = this.getAlteredTimestamp(timerData);
        int cacheHash = this.getCacheHash(timerData.getPlatformIdent(), timerData.getMethodIdent(), aggregationTimestamp);
        this.persistAllLock.lock();
        try {
            TimerData aggTimerData = this.map.get(cacheHash);
            if (aggTimerData == null) {
                aggTimerData = new DatabaseAggregatedTimerData(new Timestamp(aggregationTimestamp), timerData.getPlatformIdent(), timerData.getSensorTypeIdent(), timerData.getMethodIdent());
                this.map.put(cacheHash, aggTimerData);
                this.queue.add(aggTimerData);
                if (null != this.timerDataAggregatorCacheCleaner) {
                    this.timerDataAggregatorCacheCleaner.setMostRecentlyAdded(aggTimerData);
                }
                int count = this.elementCount.incrementAndGet();
                while (this.maxElements < count) {
                    TimerData oldest = this.queue.poll();
                    if (null == oldest) continue;
                    this.map.remove(this.getCacheHash(oldest.getPlatformIdent(), oldest.getMethodIdent(), oldest.getTimeStamp().getTime()));
                    this.persistList.add(oldest);
                    count = this.elementCount.decrementAndGet();
                }
            }
            aggTimerData.aggregateTimerData(timerData);
        }
        finally {
            this.persistAllLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAndPersistAll() {
        if (!this.queue.isEmpty()) {
            this.persistAllLock.lock();
            try {
                this.tt.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                    protected void doInTransactionWithoutResult(TransactionStatus status) {
                        TimerData oldest = (TimerData)TimerDataAggregator.this.queue.poll();
                        while (oldest != null) {
                            TimerDataAggregator.this.map.remove(TimerDataAggregator.this.getCacheHash(oldest.getPlatformIdent(), oldest.getMethodIdent(), oldest.getTimeStamp().getTime()));
                            TimerDataAggregator.super.create(oldest);
                            TimerDataAggregator.this.elementCount.decrementAndGet();
                            oldest = (TimerData)TimerDataAggregator.this.queue.poll();
                        }
                    }
                });
            }
            finally {
                this.persistAllLock.unlock();
            }
        }
    }

    void saveAllInPersistList() {
        if (!this.persistList.isEmpty()) {
            this.tt.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    TimerData last = (TimerData)TimerDataAggregator.this.persistList.poll();
                    while (last != null) {
                        last.finalizeData();
                        TimerDataAggregator.super.create(last);
                        last = (TimerData)TimerDataAggregator.this.persistList.poll();
                    }
                }
            });
        }
    }

    private int getCacheHash(long platformIdent, long methodIdent, long timestampValue) {
        int prime = 31;
        int result = 0;
        result = 31 * result + (int)(platformIdent ^ platformIdent >>> 32);
        result = 31 * result + (int)(methodIdent ^ methodIdent >>> 32);
        result = 31 * result + (int)(timestampValue ^ timestampValue >>> 32);
        return result;
    }

    private long getAlteredTimestamp(TimerData timerData) {
        long timestampValue = timerData.getTimeStamp().getTime();
        long newTimestampValue = timestampValue - timestampValue % this.aggregationPeriod;
        return newTimestampValue;
    }

    @PostConstruct
    public void postConstruct() {
        this.timerDataAggregatorCacheCleaner = new TimerDataAggregatorCacheCleaner(this);
        this.timerDataAggregatorCacheCleaner.start();
    }

    public long getAggregationPeriod() {
        return this.aggregationPeriod;
    }

    public int getMaxElements() {
        return this.maxElements;
    }

    public long getCacheCleanSleepingPeriod() {
        return this.cacheCleanSleepingPeriod;
    }

    public int getElementCount() {
        return this.elementCount.get();
    }
}

