/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.dao.impl;

import info.novatec.inspectit.cmr.dao.DefaultDataDao;
import info.novatec.inspectit.cmr.processor.AbstractCmrDataProcessor;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.MethodSensorData;
import info.novatec.inspectit.communication.data.HttpTimerData;
import info.novatec.inspectit.communication.data.JmxSensorValueData;
import info.novatec.inspectit.spring.logger.Log;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class DefaultDataDaoImpl
implements DefaultDataDao {
    @Log
    Logger log;
    @Autowired
    @Resource(name="cmrDataProcessorList")
    private List<AbstractCmrDataProcessor> cmrDataProcessors;
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    @Transactional
    public void saveAll(List<? extends DefaultData> defaultDataCollection) {
        try {
            for (AbstractCmrDataProcessor processor : this.cmrDataProcessors) {
                processor.process(defaultDataCollection, this.entityManager);
            }
        }
        catch (Exception e) {
            this.log.error("Error occurred trying to process the CMR data processors on the incoming data.", (Throwable)e);
        }
    }

    @Override
    public List<DefaultData> findByExampleWithLastInterval(DefaultData template, long timeInterval) {
        CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(DefaultData.class);
        Root root = criteria.from(template.getClass());
        criteria.select((Selection)root);
        Predicate platformId = builder.equal((Expression)root.get("platformIdent"), (Object)template.getPlatformIdent());
        Predicate sensorTypeId = builder.equal((Expression)root.get("sensorTypeIdent"), (Object)template.getSensorTypeIdent());
        Predicate timestamp = builder.greaterThan((Expression)root.get("timeStamp"), (Comparable)new Timestamp(System.currentTimeMillis() - timeInterval));
        if (template instanceof MethodSensorData) {
            MethodSensorData methodSensorData = (MethodSensorData)template;
            Predicate methodId = builder.equal((Expression)root.get("methodIdent"), (Object)methodSensorData.getMethodIdent());
            criteria.where(new Predicate[]{platformId, sensorTypeId, timestamp, methodId});
        } else if (template instanceof JmxSensorValueData) {
            JmxSensorValueData jmxSensorValueData = (JmxSensorValueData)template;
            Predicate jmxSensorDefinitionDataId = builder.equal((Expression)root.get("jmxSensorDefinitionDataIdentId"), (Object)jmxSensorValueData.getJmxSensorDefinitionDataIdentId());
            criteria.where(new Predicate[]{platformId, sensorTypeId, timestamp, jmxSensorDefinitionDataId});
        } else {
            criteria.where(new Predicate[]{platformId, sensorTypeId, timestamp});
        }
        return this.entityManager.createQuery(criteria).getResultList();
    }

    @Override
    public List<DefaultData> findByExampleSinceId(DefaultData template) {
        CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(DefaultData.class);
        Root root = criteria.from(template.getClass());
        criteria.select((Selection)root);
        Predicate id = builder.greaterThan((Expression)root.get("id"), (Comparable)Long.valueOf(template.getId()));
        Predicate platformId = builder.equal((Expression)root.get("platformIdent"), (Object)template.getPlatformIdent());
        Predicate sensorTypeId = builder.equal((Expression)root.get("sensorTypeIdent"), (Object)template.getSensorTypeIdent());
        if (template instanceof MethodSensorData) {
            MethodSensorData methodSensorData = (MethodSensorData)template;
            Predicate methodId = builder.equal((Expression)root.get("methodIdent"), (Object)methodSensorData.getMethodIdent());
            criteria.where(new Predicate[]{id, platformId, sensorTypeId, methodId});
        } else if (template instanceof JmxSensorValueData) {
            JmxSensorValueData jmxSensorValueData = (JmxSensorValueData)template;
            Predicate jmxSensorDefinitionDataId = builder.equal((Expression)root.get("jmxSensorDefinitionDataIdentId"), (Object)jmxSensorValueData.getJmxSensorDefinitionDataIdentId());
            criteria.where(new Predicate[]{id, platformId, sensorTypeId, jmxSensorDefinitionDataId});
        } else {
            criteria.where(new Predicate[]{id, platformId, sensorTypeId});
        }
        return this.entityManager.createQuery(criteria).getResultList();
    }

    @Override
    public List<DefaultData> findByExampleSinceIdIgnoreMethodId(DefaultData template) {
        CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(DefaultData.class);
        Root root = criteria.from(template.getClass());
        criteria.select((Selection)root);
        Predicate id = builder.greaterThan((Expression)root.get("id"), (Comparable)Long.valueOf(template.getId()));
        Predicate platformId = builder.equal((Expression)root.get("platformIdent"), (Object)template.getPlatformIdent());
        criteria.where(new Predicate[]{id, platformId});
        return this.entityManager.createQuery(criteria).getResultList();
    }

    @Override
    public List<DefaultData> findByExampleFromToDate(DefaultData template, Date fromDate, Date toDate) {
        CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(DefaultData.class);
        Root root = criteria.from(template.getClass());
        criteria.select((Selection)root);
        Predicate platformId = builder.equal((Expression)root.get("platformIdent"), (Object)template.getPlatformIdent());
        Predicate sensorTypeId = builder.equal((Expression)root.get("sensorTypeIdent"), (Object)template.getSensorTypeIdent());
        Predicate timestamp = builder.between((Expression)root.get("timeStamp"), (Comparable)new Timestamp(fromDate.getTime()), (Comparable)new Timestamp(toDate.getTime()));
        if (template instanceof MethodSensorData) {
            MethodSensorData methodSensorData = (MethodSensorData)template;
            Predicate methodId = builder.equal((Expression)root.get("methodIdent"), (Object)methodSensorData.getMethodIdent());
            criteria.where(new Predicate[]{platformId, sensorTypeId, timestamp, methodId});
        } else if (template instanceof JmxSensorValueData) {
            JmxSensorValueData jmxSensorValueData = (JmxSensorValueData)template;
            Predicate jmxSensorDefinitionDataId = builder.equal((Expression)root.get("jmxSensorDefinitionDataIdentId"), (Object)jmxSensorValueData.getJmxSensorDefinitionDataIdentId());
            criteria.where(new Predicate[]{platformId, sensorTypeId, timestamp, jmxSensorDefinitionDataId});
        } else {
            criteria.where(new Predicate[]{platformId, sensorTypeId, timestamp});
        }
        return this.entityManager.createQuery(criteria).getResultList();
    }

    @Override
    public DefaultData findByExampleLastData(DefaultData template) {
        CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(DefaultData.class);
        Root root = criteria.from(template.getClass());
        criteria.select((Selection)root);
        Predicate platformId = builder.equal((Expression)root.get("platformIdent"), (Object)template.getPlatformIdent());
        if (template instanceof MethodSensorData) {
            MethodSensorData methodSensorData = (MethodSensorData)template;
            Predicate methodId = builder.equal((Expression)root.get("methodIdent"), (Object)methodSensorData.getMethodIdent());
            criteria.where(new Predicate[]{platformId, methodId});
        } else if (template instanceof JmxSensorValueData) {
            JmxSensorValueData jmxSensorValueData = (JmxSensorValueData)template;
            Predicate jmxSensorDefinitionDataId = builder.equal((Expression)root.get("jmxSensorDefinitionDataIdentId"), (Object)jmxSensorValueData.getJmxSensorDefinitionDataIdentId());
            criteria.where(new Predicate[]{platformId, jmxSensorDefinitionDataId});
        } else {
            criteria.where((Expression)platformId);
        }
        criteria.orderBy(new Order[]{builder.desc((Expression)root.get("id"))});
        List results = this.entityManager.createQuery(criteria).setMaxResults(1).getResultList();
        if (CollectionUtils.isNotEmpty((Collection)results)) {
            return (DefaultData)results.get(0);
        }
        return null;
    }

    @Override
    public List<HttpTimerData> getChartingHttpTimerDataFromDateToDate(Collection<HttpTimerData> templates, Date fromDate, Date toDate, boolean retrieveByTag) {
        if (CollectionUtils.isNotEmpty(templates)) {
            CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
            CriteriaQuery criteria = builder.createQuery(HttpTimerData.class);
            Root root = criteria.from(HttpTimerData.class);
            Predicate platformId = builder.equal((Expression)root.get("platformIdent"), (Object)templates.iterator().next().getPlatformIdent());
            Predicate timestamp = builder.between((Expression)root.get("timeStamp"), (Comparable)new Timestamp(fromDate.getTime()), (Comparable)new Timestamp(toDate.getTime()));
            Predicate condition = null;
            if (!retrieveByTag) {
                HashSet<String> uris = new HashSet<String>();
                for (HttpTimerData httpTimerData : templates) {
                    if ("n.a.".equals(httpTimerData.getHttpInfo().getUri())) continue;
                    uris.add(httpTimerData.getHttpInfo().getUri());
                }
                condition = root.join("httpInfo").get("uri").in(uris);
            } else {
                HashSet<String> tags = new HashSet<String>();
                for (HttpTimerData httpTimerData : templates) {
                    if (!httpTimerData.getHttpInfo().hasInspectItTaggingHeader()) continue;
                    tags.add(httpTimerData.getHttpInfo().getInspectItTaggingHeaderValue());
                }
                condition = root.join("httpInfo").get("inspectItTaggingHeaderValue").in(tags);
            }
            criteria.where(new Predicate[]{platformId, timestamp, condition});
            return this.entityManager.createQuery(criteria).getResultList();
        }
        return Collections.emptyList();
    }

    @Override
    public void deleteAll(Long platformId) {
        Query query = this.entityManager.createNamedQuery("SystemInformationData.findAllForPlatformId");
        query.setParameter("platformIdent", (Object)platformId);
        for (Object s : query.getResultList()) {
            this.entityManager.remove(s);
        }
        query = this.entityManager.createNamedQuery("DefaultData.deleteForPlatformId");
        query.setParameter("platformIdent", (Object)platformId);
        query.executeUpdate();
    }

    @Override
    public List<JmxSensorValueData> getJmxDataOverview(JmxSensorValueData template, Date fromDate, Date toDate) {
        if (template == null) {
            return null;
        }
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery c = cb.createQuery(JmxSensorValueData.class);
        Root root = c.from(JmxSensorValueData.class);
        Subquery sq = c.subquery(Long.class);
        Root sqRoot = sq.from(JmxSensorValueData.class);
        Predicate platformIdentPredicate = cb.equal((Expression)sqRoot.get("platformIdent"), (Object)template.getPlatformIdent());
        Predicate sensorTypeIdentPredicate = cb.equal((Expression)sqRoot.get("sensorTypeIdent"), (Object)template.getSensorTypeIdent());
        Predicate predicate = cb.and((Expression)platformIdentPredicate, (Expression)sensorTypeIdentPredicate);
        if (template.getJmxSensorDefinitionDataIdentId() > 0L) {
            predicate = cb.and((Expression)predicate, (Expression)cb.equal((Expression)sqRoot.get("jmxSensorDefinitionDataIdentId"), (Object)template.getJmxSensorDefinitionDataIdentId()));
        }
        if (fromDate != null && toDate != null) {
            predicate = cb.and((Expression)predicate, (Expression)cb.between(sqRoot.get("timeStamp").as(Date.class), (Comparable)fromDate, (Comparable)toDate));
        }
        sq.select(cb.max(sqRoot.get("id").as(Long.class))).where((Expression)predicate).groupBy(new Expression[]{sqRoot.get("jmxSensorDefinitionDataIdentId")});
        c.select((Selection)root).where((Expression)cb.in((Expression)root.get("id")).value((Expression)sq));
        return this.entityManager.createQuery(c).getResultList();
    }
}

