/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.dao.impl;

import info.novatec.inspectit.cmr.dao.HttpTimerDataDao;
import info.novatec.inspectit.cmr.dao.impl.AbstractBufferDataDao;
import info.novatec.inspectit.communication.data.HttpTimerData;
import info.novatec.inspectit.indexing.IIndexQuery;
import info.novatec.inspectit.indexing.aggregation.impl.HttpTimerDataAggregator;
import info.novatec.inspectit.indexing.query.factory.impl.HttpTimerDataQueryFactory;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class BufferHttpTimerDataDaoImpl
extends AbstractBufferDataDao<HttpTimerData>
implements HttpTimerDataDao {
    @Autowired
    private HttpTimerDataQueryFactory<IIndexQuery> httpDataQueryFactory;

    @Override
    public List<HttpTimerData> getAggregatedHttpTimerData(HttpTimerData httpData, boolean includeRequestMethod) {
        IIndexQuery query = this.httpDataQueryFactory.getFindAllHttpTimersQuery(httpData, null, null);
        return super.executeQuery(query, new HttpTimerDataAggregator(true, includeRequestMethod), false);
    }

    @Override
    public List<HttpTimerData> getAggregatedHttpTimerData(HttpTimerData httpData, boolean includeRequestMethod, Date fromDate, Date toDate) {
        IIndexQuery query = this.httpDataQueryFactory.getFindAllHttpTimersQuery(httpData, fromDate, toDate);
        return super.executeQuery(query, new HttpTimerDataAggregator(true, includeRequestMethod), false);
    }

    @Override
    public List<HttpTimerData> getTaggedAggregatedHttpTimerData(HttpTimerData httpData, boolean includeRequestMethod) {
        IIndexQuery query = this.httpDataQueryFactory.getFindAllTaggedHttpTimersQuery(httpData, null, null);
        return super.executeQuery(query, new HttpTimerDataAggregator(false, includeRequestMethod), false);
    }

    @Override
    public List<HttpTimerData> getTaggedAggregatedHttpTimerData(HttpTimerData httpData, boolean includeRequestMethod, Date fromDate, Date toDate) {
        IIndexQuery query = this.httpDataQueryFactory.getFindAllTaggedHttpTimersQuery(httpData, fromDate, toDate);
        return super.executeQuery(query, new HttpTimerDataAggregator(false, includeRequestMethod), false);
    }
}

