/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.dao.impl;

import info.novatec.inspectit.cmr.dao.ExceptionSensorDataDao;
import info.novatec.inspectit.cmr.dao.impl.AbstractBufferDataDao;
import info.novatec.inspectit.communication.comparator.DefaultDataComparatorEnum;
import info.novatec.inspectit.communication.data.AggregatedExceptionSensorData;
import info.novatec.inspectit.communication.data.ExceptionSensorData;
import info.novatec.inspectit.indexing.IIndexQuery;
import info.novatec.inspectit.indexing.aggregation.Aggregators;
import info.novatec.inspectit.indexing.query.factory.impl.ExceptionSensorDataQueryFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class BufferExceptionSensorDataDaoImpl
extends AbstractBufferDataDao<ExceptionSensorData>
implements ExceptionSensorDataDao {
    @Autowired
    private ExceptionSensorDataQueryFactory<IIndexQuery> exceptionSensorDataQueryFactory;

    @Override
    public List<ExceptionSensorData> getUngroupedExceptionOverview(ExceptionSensorData template, int limit, Comparator<? super ExceptionSensorData> comparator) {
        return this.getUngroupedExceptionOverview(template, limit, null, null, comparator);
    }

    @Override
    public List<ExceptionSensorData> getUngroupedExceptionOverview(ExceptionSensorData template, int limit, Date fromDate, Date toDate, Comparator<? super ExceptionSensorData> comparator) {
        IIndexQuery query = this.exceptionSensorDataQueryFactory.getUngroupedExceptionOverviewQuery(template, limit, fromDate, toDate);
        if (null != comparator) {
            return super.executeQuery(query, comparator, limit, true);
        }
        return super.executeQuery(query, DefaultDataComparatorEnum.TIMESTAMP, limit, true);
    }

    @Override
    public List<ExceptionSensorData> getUngroupedExceptionOverview(ExceptionSensorData template, Comparator<? super ExceptionSensorData> comparator) {
        return this.getUngroupedExceptionOverview(template, -1, null, null, comparator);
    }

    @Override
    public List<ExceptionSensorData> getUngroupedExceptionOverview(ExceptionSensorData template, Date fromDate, Date toDate, Comparator<? super ExceptionSensorData> comparator) {
        return this.getUngroupedExceptionOverview(template, -1, fromDate, toDate, comparator);
    }

    @Override
    public List<ExceptionSensorData> getExceptionTree(ExceptionSensorData template) {
        IIndexQuery query = this.exceptionSensorDataQueryFactory.getExceptionTreeQuery(template);
        List<ExceptionSensorData> results = super.executeQuery(query, false);
        Collections.reverse(results);
        return results;
    }

    @Override
    public List<AggregatedExceptionSensorData> getDataForGroupedExceptionOverview(ExceptionSensorData template) {
        return this.getDataForGroupedExceptionOverview(template, null, null);
    }

    @Override
    public List<AggregatedExceptionSensorData> getDataForGroupedExceptionOverview(ExceptionSensorData template, Date fromDate, Date toDate) {
        IIndexQuery query = this.exceptionSensorDataQueryFactory.getDataForGroupedExceptionOverviewQuery(template, fromDate, toDate);
        List results = super.executeQuery(query, Aggregators.GROUP_EXCEPTION_OVERVIEW_AGGREGATOR, true);
        ArrayList<AggregatedExceptionSensorData> aggResults = new ArrayList<AggregatedExceptionSensorData>();
        for (ExceptionSensorData exData : results) {
            if (!(exData instanceof AggregatedExceptionSensorData)) continue;
            aggResults.add((AggregatedExceptionSensorData)exData);
        }
        return aggResults;
    }

    @Override
    public List<ExceptionSensorData> getStackTraceMessagesForThrowableType(ExceptionSensorData template) {
        IIndexQuery query = this.exceptionSensorDataQueryFactory.getStackTraceMessagesForThrowableTypeQuery(template);
        return super.executeQuery(query, Aggregators.DISTINCT_STACK_TRACES_AGGREGATOR, true);
    }
}

