/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.dao.impl;

import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.indexing.IIndexQuery;
import info.novatec.inspectit.indexing.aggregation.IAggregator;
import info.novatec.inspectit.indexing.aggregation.impl.AggregationPerformer;
import info.novatec.inspectit.indexing.buffer.IBufferTreeComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class AbstractBufferDataDao<E extends DefaultData> {
    @Autowired
    private IBufferTreeComponent<E> indexingTree;
    @Autowired
    @Qualifier(value="indexingTreeForkJoinPool")
    private ForkJoinPool forkJoinPool;

    protected List<E> executeQuery(IIndexQuery indexQuery, boolean useForkJoin) {
        return this.executeQuery(indexQuery, null, null, -1, useForkJoin);
    }

    protected List<E> executeQuery(IIndexQuery indexQuery, IAggregator<E> aggregator, boolean useForkJoin) {
        return this.executeQuery(indexQuery, aggregator, null, -1, useForkJoin);
    }

    protected List<E> executeQuery(IIndexQuery indexQuery, Comparator<E> comparator, boolean useForkJoin) {
        return this.executeQuery(indexQuery, null, comparator, -1, useForkJoin);
    }

    protected List<E> executeQuery(IIndexQuery indexQuery, int limit, boolean useForkJoin) {
        return this.executeQuery(indexQuery, null, null, limit, useForkJoin);
    }

    protected List<E> executeQuery(IIndexQuery indexQuery, IAggregator<E> aggregator, Comparator<? super E> comparator, boolean useForkJoin) {
        return this.executeQuery(indexQuery, aggregator, comparator, -1, useForkJoin);
    }

    protected List<E> executeQuery(IIndexQuery indexQuery, IAggregator<E> aggregator, int limit, boolean useForkJoin) {
        return this.executeQuery(indexQuery, aggregator, null, limit, useForkJoin);
    }

    protected List<E> executeQuery(IIndexQuery indexQuery, Comparator<? super E> comparator, int limit, boolean useForkJoin) {
        return this.executeQuery(indexQuery, null, comparator, limit, useForkJoin);
    }

    protected List<E> executeQuery(IIndexQuery indexQuery, IAggregator<E> aggregator, Comparator<? super E> comparator, int limit, boolean useForkJoin) {
        List data = useForkJoin ? this.indexingTree.query(indexQuery, this.forkJoinPool) : this.indexingTree.query(indexQuery);
        if (null != aggregator) {
            AggregationPerformer aggregationPerformer = new AggregationPerformer(aggregator);
            aggregationPerformer.processCollection((Collection)data);
            data = aggregationPerformer.getResultList();
        }
        if (null != comparator) {
            Collections.sort(data, comparator);
        }
        if (limit > -1 && data.size() > limit) {
            data = new ArrayList(data.subList(0, limit));
        }
        return data;
    }

    protected IBufferTreeComponent<E> getIndexingTree() {
        return this.indexingTree;
    }
}

