/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.ci;

import info.novatec.inspectit.ci.Environment;
import info.novatec.inspectit.ci.Profile;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.springframework.stereotype.Component;

@Component
public class ConfigurationInterfacePathResolver {
    private static final String DEFAULT_CI_FOLDER = "ci";
    private static final String SCHEMA_FOLDER = "schema";
    private static final String SCHEMA_FILE = "ciSchema.xsd";
    private static final String PROFILES_FOLDER = "profiles";
    private static final String ENVIRONMENTS_FOLDER = "environments";
    private static final String AGENT_MAPPING_FILE = "agent-mappings.xml";

    public Path getDefaultCiPath() {
        return Paths.get(DEFAULT_CI_FOLDER, new String[0]);
    }

    public Path getSchemaPath() {
        return Paths.get(DEFAULT_CI_FOLDER, SCHEMA_FOLDER, SCHEMA_FILE);
    }

    public Path getProfilesPath() {
        return Paths.get(DEFAULT_CI_FOLDER, PROFILES_FOLDER);
    }

    public Path getProfileFilePath(Profile profile) {
        String fileName = profile.getId() + "-" + profile.getName().replace(' ', '-') + ".xml";
        return this.getProfilesPath().resolve(fileName);
    }

    public Path getEnvironmentPath() {
        return Paths.get(DEFAULT_CI_FOLDER, ENVIRONMENTS_FOLDER);
    }

    public Path getEnvironmentFilePath(Environment environment) {
        String fileName = environment.getId() + "-" + environment.getName().replace(' ', '-') + ".xml";
        return this.getEnvironmentPath().resolve(fileName);
    }

    public Path getAgentMappingFilePath() {
        return Paths.get(DEFAULT_CI_FOLDER, AGENT_MAPPING_FILE);
    }
}

