/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.cache.impl;

import info.novatec.inspectit.spring.logger.Log;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.text.NumberFormat;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class BufferProperties {
    @Log
    Logger log;
    private static final String OLD_GEN_POOL_NAME = "Old Gen";
    private static final String TENURED_GEN_POOL_NAME = "Tenured";
    @Value(value="${buffer.evictionOccupancyPercentage}")
    float evictionOccupancyPercentage;
    @Value(value="${buffer.maxObjectExpansionRate}")
    float maxObjectExpansionRate;
    @Value(value="${buffer.minObjectExpansionRate}")
    float minObjectExpansionRate;
    @Value(value="${buffer.maxObjectExpansionRateActiveTillBufferSize}")
    long maxObjectExpansionRateActiveTillBufferSize;
    @Value(value="${buffer.minObjectExpansionRateActiveFromBufferSize}")
    long minObjectExpansionRateActiveFromBufferSize;
    @Value(value="${buffer.minObjectExpansionRateActiveTillOccupancy}")
    float minObjectExpansionRateActiveTillOccupancy;
    @Value(value="${buffer.maxObjectExpansionRateActiveFromOccupancy}")
    float maxObjectExpansionRateActiveFromOccupancy;
    @Value(value="${buffer.evictionFragmentSizePercentage}")
    float evictionFragmentSizePercentage;
    @Value(value="${buffer.bytesMaintenancePercentage}")
    float bytesMaintenancePercentage;
    @Value(value="${buffer.indexingTreeCleaningThreads}")
    int indexingTreeCleaningThreads;
    @Value(value="${buffer.indexingWaitTime}")
    long indexingWaitTime;
    @Value(value="${buffer.minOldSpaceOccupancyActiveTillOldGenSize}")
    long minOldSpaceOccupancyActiveTillOldGenSize;
    @Value(value="${buffer.maxOldSpaceOccupancyActiveFromOldGenSize}")
    long maxOldSpaceOccupancyActiveFromOldGenSize;
    @Value(value="${buffer.minOldSpaceOccupancy}")
    float minOldSpaceOccupancy;
    @Value(value="${buffer.maxOldSpaceOccupancy}")
    float maxOldSpaceOccupancy;

    public float getEvictionOccupancyPercentage() {
        return this.evictionOccupancyPercentage;
    }

    public float getMaxObjectExpansionRate() {
        return this.maxObjectExpansionRate;
    }

    public float getMinObjectExpansionRate() {
        return this.minObjectExpansionRate;
    }

    public long getMaxObjectExpansionRateActiveTillBufferSize() {
        return this.maxObjectExpansionRateActiveTillBufferSize;
    }

    public long getMinObjectExpansionRateActiveFromBufferSize() {
        return this.minObjectExpansionRateActiveFromBufferSize;
    }

    public float getMinObjectExpansionRateActiveTillOccupancy() {
        return this.minObjectExpansionRateActiveTillOccupancy;
    }

    public float getMaxObjectExpansionRateActiveFromOccupancy() {
        return this.maxObjectExpansionRateActiveFromOccupancy;
    }

    public float getEvictionFragmentSizePercentage() {
        return this.evictionFragmentSizePercentage;
    }

    public long getFlagsSetOnBytes(long bufferSize) {
        return (long)(this.bytesMaintenancePercentage * (float)bufferSize);
    }

    public float getBytesMaintenancePercentage() {
        return this.bytesMaintenancePercentage;
    }

    public int getIndexingTreeCleaningThreads() {
        return this.indexingTreeCleaningThreads;
    }

    public long getIndexingWaitTime() {
        return this.indexingWaitTime;
    }

    public long getMinOldSpaceOccupancyActiveTillOldGenSize() {
        return this.minOldSpaceOccupancyActiveTillOldGenSize;
    }

    public long getMaxOldSpaceOccupancyActiveFromOldGenSize() {
        return this.maxOldSpaceOccupancyActiveFromOldGenSize;
    }

    public float getMinOldSpaceOccupancy() {
        return this.minOldSpaceOccupancy;
    }

    public float getMaxOldSpaceOccupancy() {
        return this.maxOldSpaceOccupancy;
    }

    public long getInitialBufferSize() {
        long bufferSize = 0L;
        long oldGenMax = this.getOldGenMax();
        if (oldGenMax == 0L) {
            throw new RuntimeException("Could not calculate the old generation heap space. Please make sure CMR is running on the provided JVM.");
        }
        if (oldGenMax > this.maxOldSpaceOccupancyActiveFromOldGenSize) {
            bufferSize = (long)((float)oldGenMax * this.maxOldSpaceOccupancy);
        } else if (oldGenMax < this.minOldSpaceOccupancyActiveTillOldGenSize) {
            bufferSize = (long)((float)oldGenMax * this.minOldSpaceOccupancy);
        } else {
            float delta = (this.maxOldSpaceOccupancy - this.minOldSpaceOccupancy) * ((float)(oldGenMax - this.minOldSpaceOccupancyActiveTillOldGenSize) / (float)(this.maxOldSpaceOccupancyActiveFromOldGenSize - this.minOldSpaceOccupancyActiveTillOldGenSize));
            bufferSize = (long)((float)oldGenMax * (this.minOldSpaceOccupancy + delta));
        }
        return bufferSize;
    }

    private long getMemorySizeFromArgument(String argument, String memoryToken) {
        try {
            int index = argument.indexOf(memoryToken) + memoryToken.length();
            String number = argument.substring(index, argument.length() - 1);
            String typeOfMemory = argument.substring(index + number.length());
            double value = Double.parseDouble(number);
            value = "K".equalsIgnoreCase(typeOfMemory) ? (value *= 1024.0) : ("M".equalsIgnoreCase(typeOfMemory) ? (value *= 1048576.0) : ("G".equalsIgnoreCase(typeOfMemory) ? (value *= 1.073741824E9) : (value *= 1.0)));
            return (long)value;
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public float getObjectSecurityExpansionRate(long bufferSize) {
        return (this.getObjectSecurityExpansionRateBufferSize(bufferSize) + this.getObjectSecurityExpansionRateBufferOccupancy(bufferSize, this.getOldGenMax())) / 2.0f;
    }

    public float getObjectSecurityExpansionRateBufferSize(long bufferSize) {
        if (bufferSize > this.minObjectExpansionRateActiveFromBufferSize) {
            return this.minObjectExpansionRate;
        }
        if (bufferSize < this.maxObjectExpansionRateActiveTillBufferSize) {
            return this.maxObjectExpansionRate;
        }
        float delta = (this.maxObjectExpansionRate - this.minObjectExpansionRate) * ((float)(bufferSize - this.maxObjectExpansionRateActiveTillBufferSize) / (float)(this.minObjectExpansionRateActiveFromBufferSize - this.maxObjectExpansionRateActiveTillBufferSize));
        return this.maxObjectExpansionRate - delta;
    }

    float getObjectSecurityExpansionRateBufferOccupancy(long bufferSize, long oldGenMax) {
        double occupancy = (double)bufferSize / (double)oldGenMax;
        if (occupancy < (double)this.minObjectExpansionRateActiveTillOccupancy) {
            return this.minObjectExpansionRate;
        }
        if (occupancy > (double)this.maxObjectExpansionRateActiveFromOccupancy) {
            return this.maxObjectExpansionRate;
        }
        float delta = (this.maxObjectExpansionRate - this.minObjectExpansionRate) * ((float)(occupancy - (double)this.maxObjectExpansionRateActiveFromOccupancy) / (this.minObjectExpansionRateActiveTillOccupancy - this.maxObjectExpansionRateActiveFromOccupancy));
        return this.maxObjectExpansionRate - delta;
    }

    long getOldGenMax() {
        long oldGenMax = 0L;
        try {
            List<MemoryPoolMXBean> memBeans = ManagementFactory.getMemoryPoolMXBeans();
            for (MemoryPoolMXBean memBean : memBeans) {
                if (memBean.getName().indexOf(OLD_GEN_POOL_NAME) == -1 && memBean.getName().indexOf(TENURED_GEN_POOL_NAME) == -1) continue;
                MemoryUsage memUsage = memBean.getUsage();
                oldGenMax = memUsage.getMax();
                break;
            }
        }
        catch (Exception e) {
            oldGenMax = 0L;
        }
        try {
            if (oldGenMax == 0L) {
                long maxHeap = 0L;
                long newGen = 0L;
                RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
                List<String> arguments = runtimeMXBean.getInputArguments();
                for (String arg : arguments) {
                    if (arg.length() <= 4) continue;
                    String subedArg = arg.substring(0, 4);
                    if ("-Xmx".equalsIgnoreCase(subedArg)) {
                        maxHeap = this.getMemorySizeFromArgument(arg, subedArg);
                    }
                    if (!"-Xmn".equalsIgnoreCase(subedArg)) continue;
                    newGen = this.getMemorySizeFromArgument(arg, subedArg);
                }
                if (maxHeap != 0L && newGen != 0L && maxHeap > newGen) {
                    oldGenMax = maxHeap - newGen;
                }
            }
        }
        catch (Exception e) {
            oldGenMax = 0L;
        }
        return oldGenMax;
    }

    @PostConstruct
    public void postConstruct() throws Exception {
        if (this.log.isInfoEnabled()) {
            this.log.info("|-Buffer properties initialized with following values:");
            this.log.info("||-Eviction occupancy percentage: " + NumberFormat.getInstance().format(this.evictionOccupancyPercentage * 100.0f) + "%");
            this.log.info("||-Eviction fragment size percentage: " + NumberFormat.getInstance().format(this.evictionFragmentSizePercentage * 100.0f) + "%");
            this.log.info("||-Indexing tree cleaning threads: " + NumberFormat.getInstance().format(this.indexingTreeCleaningThreads));
            this.log.info("||-Indexing waiting time: " + NumberFormat.getInstance().format(this.indexingWaitTime) + " ms");
            this.log.info("||-Min old generation occupancy percentage active till: " + NumberFormat.getInstance().format(this.minOldSpaceOccupancyActiveTillOldGenSize) + " bytes");
            this.log.info("||-Max old generation occupancy percentage active from: " + NumberFormat.getInstance().format(this.maxOldSpaceOccupancyActiveFromOldGenSize) + " bytes");
            this.log.info("||-Min old generation occupancy percentage: " + NumberFormat.getInstance().format(this.minOldSpaceOccupancy * 100.0f) + "%");
            this.log.info("||-Max old generation occupancy percentage: " + NumberFormat.getInstance().format(this.maxOldSpaceOccupancy * 100.0f) + "%");
            this.log.info("||-Max object size expansion: " + NumberFormat.getInstance().format(this.maxObjectExpansionRate * 100.0f) + "%");
            this.log.info("||-Min object size expansion: " + NumberFormat.getInstance().format(this.minObjectExpansionRate * 100.0f) + "%");
            this.log.info("||-Max object size expansion active from buffer occupancy: " + NumberFormat.getInstance().format(this.maxObjectExpansionRateActiveFromOccupancy * 100.0f) + "%");
            this.log.info("||-Min object size expansion active till buffer occupancy: " + NumberFormat.getInstance().format(this.minObjectExpansionRateActiveTillOccupancy * 100.0f) + " %");
            this.log.info("||-Max object size expansion active till buffer size: " + NumberFormat.getInstance().format(this.maxObjectExpansionRateActiveTillBufferSize) + " bytes");
            this.log.info("||-Min object size expansion active from buffer size: " + NumberFormat.getInstance().format(this.minObjectExpansionRateActiveFromBufferSize) + " bytes");
        }
        if (this.evictionOccupancyPercentage < 0.0f || this.evictionOccupancyPercentage > 1.0f) {
            throw new BeanInitializationException("Buffer properties initialization error: Eviction occupancy must be a percentage value between 0 and 1. Initialization value is: " + this.evictionOccupancyPercentage);
        }
        if ((double)this.evictionFragmentSizePercentage < 0.01 || (double)this.evictionFragmentSizePercentage > 0.5) {
            throw new BeanInitializationException("Buffer properties initialization error: Eviction fragment size must be a percentage value between 0.01 and 0.5. Initialization value is: " + this.evictionFragmentSizePercentage);
        }
        if (this.minObjectExpansionRateActiveFromBufferSize < this.maxObjectExpansionRateActiveTillBufferSize) {
            throw new BeanInitializationException("Buffer properties initialization error: Buffer size from which minimum object expansion rate is active can not be lower than buffer size till which maximum object expansion rate is active. Initialization values are: " + this.minObjectExpansionRateActiveFromBufferSize + " (buffer size for min object expansion rate) and " + this.maxObjectExpansionRateActiveTillBufferSize + " (buffer size for max object expansion rate)");
        }
        if (this.minObjectExpansionRateActiveTillOccupancy > this.maxObjectExpansionRateActiveFromOccupancy) {
            throw new BeanInitializationException("Buffer properties initialization error: Buffer occupancy till which minimum object expansion rate is active can not be higher than buffer occupancy from which maximum object expansion rate is active. Initialization values are: " + this.minObjectExpansionRateActiveTillOccupancy + " (buffer occupancy for min object expansion rate) and " + this.maxObjectExpansionRateActiveFromOccupancy + " (buffer occupnacy for max object expansion rate)");
        }
        if (this.minObjectExpansionRateActiveTillOccupancy <= 0.0f || this.minObjectExpansionRateActiveTillOccupancy > 1.0f) {
            throw new BeanInitializationException("Buffer properties initialization error: The min object expansion rate till buffer old space gen occupancy can not be less or equal than zero, nor greater that one. Initialization value is: " + this.minObjectExpansionRateActiveTillOccupancy);
        }
        if (this.maxObjectExpansionRateActiveFromOccupancy <= 0.0f || this.maxObjectExpansionRateActiveFromOccupancy > 1.0f) {
            throw new BeanInitializationException("Buffer properties initialization error: The max object expansion rate from buffer old space gen occupancy can not be less or equal than zero, nor greater that one. Initialization value is: " + this.maxObjectExpansionRateActiveFromOccupancy);
        }
        if (this.getBytesMaintenancePercentage() <= 0.0f && this.getBytesMaintenancePercentage() > this.getEvictionOccupancyPercentage()) {
            throw new BeanInitializationException("Buffer properties initialization error: The buffer bytes maintenance percentage that activate the clean and update of the indexing tree can not be less or equal than zero nor bigger that eviction occupancy percentage. Initialization value is: " + this.getBytesMaintenancePercentage());
        }
        if (this.getIndexingTreeCleaningThreads() <= 0) {
            throw new BeanInitializationException("Buffer properties initialization error: The number of indexing tree cleaning threads can not be less or equal than zero. Initialization value is: " + this.getIndexingTreeCleaningThreads());
        }
        if (this.indexingWaitTime <= 0L) {
            throw new BeanInitializationException("Buffer properties initialization error: The indexing wait time can not be less or equal than zero. Initialization value is: " + this.indexingWaitTime);
        }
        if (this.minOldSpaceOccupancyActiveTillOldGenSize <= 0L) {
            throw new BeanInitializationException("Buffer properties initialization error: The min buffer occupancy percentage of the old generation heap space active till old generation size value can not be less or equal than zero. Initialization value is: " + this.minOldSpaceOccupancyActiveTillOldGenSize);
        }
        if (this.maxOldSpaceOccupancyActiveFromOldGenSize <= 0L) {
            throw new BeanInitializationException("Buffer properties initialization error: The max buffer occupancy percentage of the old generation heap space active till old generation size value can not be less or equal than zero. Initialization value is: " + this.maxOldSpaceOccupancyActiveFromOldGenSize);
        }
        if (this.minOldSpaceOccupancy > this.maxOldSpaceOccupancy) {
            throw new BeanInitializationException("Buffer properties initialization error: The min buffer occupancy percentage of the old generation heap space can not be higer than max buffer occupancy percentage of the old generation. Initialization values are: " + this.minOldSpaceOccupancy + "(min), " + this.maxOldSpaceOccupancy + "(max)");
        }
        if (this.minOldSpaceOccupancy <= 0.0f || this.minOldSpaceOccupancy > 1.0f) {
            throw new BeanInitializationException("Buffer properties initialization error: The min buffer occupancy percentage of the old generation heap space can not be less or equal than zero, nor greater that one. Initialization value is: " + this.minOldSpaceOccupancy);
        }
        if (this.maxOldSpaceOccupancy <= 0.0f || this.maxOldSpaceOccupancy > 1.0f) {
            throw new BeanInitializationException("Buffer properties initialization error: The max buffer occupancy percentage of the old generation heap space can not be less or equal than zero, nor greater that one. Initialization value is: " + this.maxOldSpaceOccupancy);
        }
    }
}

