/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.storage.nio.read;

import info.novatec.inspectit.storage.nio.WriteReadAttachment;
import info.novatec.inspectit.storage.nio.WriteReadCompletionRunnable;
import java.nio.ByteBuffer;
import java.nio.channels.CompletionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadingCompletionHandler
implements CompletionHandler<Integer, WriteReadAttachment> {
    private static final Logger LOG = LoggerFactory.getLogger(ReadingCompletionHandler.class);

    @Override
    public void completed(Integer result, WriteReadAttachment attachment) {
        long bytesToReadMore = attachment.getSize() - result.longValue();
        if (bytesToReadMore > 0L) {
            long readSize = bytesToReadMore;
            long position = attachment.getPosition() + result.longValue();
            attachment.setSize(readSize);
            attachment.setPosition(position);
            attachment.getFileChannel().read(attachment.getByteBuffer(), position, attachment, this);
        } else {
            ByteBuffer byteBuffer = attachment.getByteBuffer();
            if (bytesToReadMore < 0L) {
                byteBuffer.position(byteBuffer.position() + (int)bytesToReadMore);
            }
            byteBuffer.flip();
            WriteReadCompletionRunnable completionRunnable = attachment.getCompletionRunnable();
            if (null != completionRunnable) {
                completionRunnable.markSuccess();
                if (completionRunnable.isFinished()) {
                    completionRunnable.run();
                }
            }
        }
    }

    @Override
    public void failed(Throwable exc, WriteReadAttachment attachment) {
        LOG.error("Write to the disk failed.", exc);
        WriteReadCompletionRunnable completionRunnable = attachment.getCompletionRunnable();
        if (null != completionRunnable) {
            completionRunnable.markFailed();
            if (completionRunnable.isFinished()) {
                completionRunnable.run();
            }
        }
    }
}

