/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.storage.nio;

import java.util.concurrent.atomic.AtomicInteger;

public abstract class WriteReadCompletionRunnable
implements Runnable {
    private long attemptedWriteReadSize;
    private long attemptedWriteReadPosition;
    private int completeMarks;
    private AtomicInteger successMarks = new AtomicInteger(0);
    private AtomicInteger failedMarks = new AtomicInteger(0);

    public WriteReadCompletionRunnable() {
        this(1);
    }

    public WriteReadCompletionRunnable(int completeMarks) {
        this.completeMarks = completeMarks;
    }

    public void markSuccess() {
        this.successMarks.incrementAndGet();
    }

    public void markFailed() {
        this.failedMarks.incrementAndGet();
    }

    public boolean isFinished() {
        return this.successMarks.get() + this.failedMarks.get() == this.completeMarks;
    }

    public boolean isCompleted() {
        return this.successMarks.get() == this.completeMarks;
    }

    public boolean isFailed() {
        return this.failedMarks.get() > 0;
    }

    public long getAttemptedWriteReadSize() {
        return this.attemptedWriteReadSize;
    }

    public void setAttemptedWriteReadSize(long attemptedWriteReadSize) {
        this.attemptedWriteReadSize = attemptedWriteReadSize;
    }

    public long getAttemptedWriteReadPosition() {
        return this.attemptedWriteReadPosition;
    }

    public void setAttemptedWriteReadPosition(long attemptedWriteReadPosition) {
        this.attemptedWriteReadPosition = attemptedWriteReadPosition;
    }
}

