/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.indexing.buffer.impl;

import info.novatec.inspectit.cmr.cache.IObjectSizes;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.indexing.IIndexQuery;
import info.novatec.inspectit.indexing.LeafTask;
import info.novatec.inspectit.indexing.buffer.IBufferTreeComponent;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.RecursiveTask;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.cliffc.high_scale_lib.NonBlockingHashMapLong;

public class Leaf<E extends DefaultData>
implements IBufferTreeComponent<E> {
    private NonBlockingHashMapLong<CustomWeakReference<E>> map;
    private ReferenceQueue<E> referenceQueue;
    private Runnable clearRunnable = new Runnable(){

        @Override
        public void run() {
            Leaf.this.clean();
        }
    };
    private Future<?> clearFuture;

    public Leaf() {
        this.map = new NonBlockingHashMapLong();
        this.referenceQueue = new ReferenceQueue();
    }

    @Override
    public E put(E element) {
        CustomWeakReference<E> weakReference = new CustomWeakReference<E>(element, this.referenceQueue);
        this.map.put(element.getId(), weakReference);
        return element;
    }

    @Override
    public E get(E template) {
        long id = template.getId();
        WeakReference weakReference = (WeakReference)this.map.get(id);
        if (null != weakReference) {
            if (null == weakReference.get()) {
                this.map.remove(id);
                return null;
            }
            return (E)((DefaultData)weakReference.get());
        }
        return null;
    }

    @Override
    public E getAndRemove(E template) {
        long id = template.getId();
        WeakReference weakReference = (WeakReference)this.map.get(id);
        if (null != weakReference) {
            if (null == weakReference.get()) {
                this.map.remove(id);
                return null;
            }
            DefaultData result = (DefaultData)weakReference.get();
            this.map.remove(id);
            return (E)result;
        }
        return null;
    }

    @Override
    public List<E> query(IIndexQuery query) {
        ArrayList results = new ArrayList();
        for (WeakReference weakReference : this.map.values()) {
            DefaultData element;
            if (null == weakReference || null == (element = (DefaultData)weakReference.get()) || !element.isQueryComplied(query)) continue;
            results.add(weakReference.get());
        }
        return results;
    }

    @Override
    public List<E> query(IIndexQuery query, ForkJoinPool forkJoinPool) {
        return forkJoinPool.invoke(this.getTaskForForkJoinQuery(query));
    }

    @Override
    public long getComponentSize(IObjectSizes objectSizes) {
        int mapSize = this.map.size();
        long size = objectSizes.getSizeOfObjectHeader();
        size += objectSizes.getPrimitiveTypesSize(1, 0, 0, 0, 0, 0);
        size = objectSizes.alignTo8Bytes(size);
        size += objectSizes.getSizeOfNonBlockingHashMapLong(mapSize);
        return size += (long)this.map.size() * objectSizes.getSizeOfCustomWeakReference();
    }

    @Override
    public boolean clean() {
        ArrayList<Long> toClean = new ArrayList<Long>();
        CustomWeakReference customWeakReference = (CustomWeakReference)this.referenceQueue.poll();
        while (customWeakReference != null) {
            toClean.add(customWeakReference.getReferentId());
            customWeakReference = (CustomWeakReference)this.referenceQueue.poll();
        }
        for (Object e : toClean) {
            this.map.remove(e);
        }
        return this.map.isEmpty();
    }

    @Override
    public long getNumberOfElements() {
        return this.map.size();
    }

    @Override
    public void clearAll() {
        this.map.clear();
    }

    @Override
    public void cleanWithRunnable(ExecutorService executorService) {
        if (this.clearFuture == null || this.clearFuture.isDone()) {
            this.clearFuture = executorService.submit(this.clearRunnable);
        }
    }

    @Override
    public boolean clearEmptyComponents() {
        return this.map.isEmpty();
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this);
        toStringBuilder.append("elementsMap", this.map);
        return toStringBuilder.toString();
    }

    @Override
    public RecursiveTask<List<E>> getTaskForForkJoinQuery(IIndexQuery query) {
        return new LeafTask(this, query);
    }

    private static class CustomWeakReference<T extends DefaultData>
    extends WeakReference<T> {
        private long referentId;

        public CustomWeakReference(T referent, ReferenceQueue<? super T> q) {
            super(referent, q);
            this.referentId = referent.getId();
        }

        public long getReferentId() {
            return this.referentId;
        }
    }
}

