/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.extract.internal;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.hibernate.JDBCException;
import org.hibernate.boot.model.TruthValue;
import org.hibernate.boot.model.naming.DatabaseIdentifier;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.QualifiedTableName;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.compare.EqualsHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.tool.schema.extract.internal.ColumnInformationImpl;
import org.hibernate.tool.schema.extract.internal.ForeignKeyInformationImpl;
import org.hibernate.tool.schema.extract.internal.IndexInformationImpl;
import org.hibernate.tool.schema.extract.internal.PrimaryKeyInformationImpl;
import org.hibernate.tool.schema.extract.internal.TableInformationImpl;
import org.hibernate.tool.schema.extract.spi.ColumnInformation;
import org.hibernate.tool.schema.extract.spi.ExtractionContext;
import org.hibernate.tool.schema.extract.spi.ForeignKeyInformation;
import org.hibernate.tool.schema.extract.spi.IndexInformation;
import org.hibernate.tool.schema.extract.spi.InformationExtractor;
import org.hibernate.tool.schema.extract.spi.PrimaryKeyInformation;
import org.hibernate.tool.schema.extract.spi.SchemaExtractionException;
import org.hibernate.tool.schema.extract.spi.TableInformation;
import org.hibernate.tool.schema.spi.SchemaManagementException;

public class InformationExtractorJdbcDatabaseMetaDataImpl
implements InformationExtractor {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(InformationExtractorJdbcDatabaseMetaDataImpl.class);
    private final String[] tableTypes;
    private final ExtractionContext extractionContext;

    public InformationExtractorJdbcDatabaseMetaDataImpl(ExtractionContext extractionContext) {
        this.extractionContext = extractionContext;
        ConfigurationService configService = extractionContext.getServiceRegistry().getService(ConfigurationService.class);
        this.tableTypes = ConfigurationHelper.getBoolean("hibernate.synonyms", configService.getSettings(), false) ? new String[]{"TABLE", "VIEW", "SYNONYM"} : new String[]{"TABLE", "VIEW"};
    }

    protected IdentifierHelper identifierHelper() {
        return this.extractionContext.getJdbcEnvironment().getIdentifierHelper();
    }

    protected JDBCException convertSQLException(SQLException sqlException, String message) {
        return this.extractionContext.getJdbcEnvironment().getSqlExceptionHelper().convert(sqlException, message);
    }

    protected String toMetaDataObjectName(Identifier identifier) {
        return this.extractionContext.getJdbcEnvironment().getIdentifierHelper().toMetaDataObjectName(identifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean catalogExists(Identifier catalog) {
        try {
            ResultSet resultSet = this.extractionContext.getJdbcDatabaseMetaData().getCatalogs();
            try {
                while (resultSet.next()) {
                    String existingCatalogName = resultSet.getString("TABLE_CAT");
                    if (!catalog.getText().equalsIgnoreCase(existingCatalogName)) continue;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        catch (SQLException sqlException) {
            throw this.convertSQLException(sqlException, "Unable to query DatabaseMetaData for existing catalogs");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean schemaExists(Identifier catalog, Identifier schema) {
        try {
            String catalogFilter = this.determineCatalogFilter(catalog);
            String schemaFilter = this.determineSchemaFilter(schema);
            ResultSet resultSet = this.extractionContext.getJdbcDatabaseMetaData().getSchemas(catalogFilter, schemaFilter);
            try {
                if (!resultSet.next()) {
                    boolean bl = false;
                    return bl;
                }
                if (resultSet.next()) {
                    String catalogName = catalog == null ? "" : catalog.getCanonicalName();
                    String schemaName = schema == null ? "" : schema.getCanonicalName();
                    log.debugf("Multiple schemas found with that name [%s.%s]", catalogName, schemaName);
                }
                boolean bl = true;
                return bl;
            }
            finally {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        catch (SQLException sqlException) {
            throw this.convertSQLException(sqlException, "Unable to query DatabaseMetaData for existing schemas");
        }
    }

    private String determineCatalogFilter(Identifier catalog) throws SQLException {
        Identifier identifierToUse = catalog;
        if (identifierToUse == null) {
            identifierToUse = this.extractionContext.getDefaultCatalog();
        }
        return this.extractionContext.getJdbcEnvironment().getIdentifierHelper().toMetaDataCatalogName(identifierToUse);
    }

    private String determineSchemaFilter(Identifier schema) throws SQLException {
        Identifier identifierToUse = schema;
        if (identifierToUse == null) {
            identifierToUse = this.extractionContext.getDefaultSchema();
        }
        return this.extractionContext.getJdbcEnvironment().getIdentifierHelper().toMetaDataSchemaName(identifierToUse);
    }

    public TableInformation extractTableInformation(Identifier catalog, Identifier schema, Identifier name, ResultSet resultSet) throws SQLException {
        if (catalog == null) {
            catalog = this.identifierHelper().toIdentifier(resultSet.getString("TABLE_CAT"));
        }
        if (schema == null) {
            schema = this.identifierHelper().toIdentifier(resultSet.getString("TABLE_SCHEM"));
        }
        if (name == null) {
            name = this.identifierHelper().toIdentifier(resultSet.getString("TABLE_NAME"));
        }
        QualifiedTableName tableName = new QualifiedTableName(catalog, schema, name);
        return new TableInformationImpl(this, tableName, this.isPhysicalTableType(resultSet.getString("TABLE_TYPE")), resultSet.getString("REMARKS"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableInformation getTable(Identifier catalog, Identifier schema, Identifier tableName) {
        TableInformation tableInformation;
        if (catalog != null || schema != null) {
            return this.locateTableInNamespace(catalog, schema, tableName);
        }
        TableInformation tableInfo = null;
        if ((this.extractionContext.getJdbcEnvironment().getCurrentCatalog() != null || this.extractionContext.getJdbcEnvironment().getCurrentSchema() != null) && (tableInfo = this.locateTableInNamespace(this.extractionContext.getJdbcEnvironment().getCurrentCatalog(), this.extractionContext.getJdbcEnvironment().getCurrentSchema(), tableName)) != null) {
            return tableInfo;
        }
        if ((this.extractionContext.getDefaultCatalog() != null || this.extractionContext.getDefaultSchema() != null) && (tableInfo = this.locateTableInNamespace(this.extractionContext.getJdbcEnvironment().getCurrentCatalog(), this.extractionContext.getJdbcEnvironment().getCurrentSchema(), tableName)) != null) {
            return tableInfo;
        }
        String tableNameFilter = this.toMetaDataObjectName(tableName);
        ResultSet resultSet = this.extractionContext.getJdbcDatabaseMetaData().getTables(null, null, tableNameFilter, this.tableTypes);
        try {
            tableInformation = this.processGetTableResults(null, null, tableName, resultSet);
        }
        catch (Throwable throwable) {
            try {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw throwable;
            }
            catch (SQLException sqlException) {
                throw this.convertSQLException(sqlException, "Error accessing table metadata");
            }
        }
        try {
            resultSet.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return tableInformation;
    }

    private TableInformation locateTableInNamespace(Identifier catalog, Identifier schema, Identifier tableName) {
        String schemaFilter;
        String catalogFilter;
        Identifier catalogToUse = null;
        Identifier schemaToUse = null;
        if (this.extractionContext.getJdbcEnvironment().getNameQualifierSupport().supportsCatalogs()) {
            if (catalog == null) {
                catalogFilter = "";
            } else {
                catalogToUse = catalog;
                catalogFilter = this.toMetaDataObjectName(catalog);
            }
        } else {
            catalogFilter = null;
        }
        if (this.extractionContext.getJdbcEnvironment().getNameQualifierSupport().supportsSchemas()) {
            if (schema == null) {
                schemaFilter = "";
            } else {
                schemaToUse = schema;
                schemaFilter = this.toMetaDataObjectName(schema);
            }
        } else {
            schemaFilter = null;
        }
        String tableNameFilter = this.toMetaDataObjectName(tableName);
        try {
            ResultSet resultSet = this.extractionContext.getJdbcDatabaseMetaData().getTables(catalogFilter, schemaFilter, tableNameFilter, this.tableTypes);
            return this.processGetTableResults(catalogToUse, schemaToUse, tableName, resultSet);
        }
        catch (SQLException sqlException) {
            throw this.convertSQLException(sqlException, "Error accessing table metadata");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableInformation processGetTableResults(Identifier catalog, Identifier schema, Identifier tableName, ResultSet resultSet) throws SQLException {
        if (!resultSet.next()) {
            log.tableNotFound(tableName.render());
            TableInformation tableInformation = null;
            return tableInformation;
        }
        TableInformation tableInformation = this.extractTableInformation(catalog, schema, tableName, resultSet);
        if (resultSet.next()) {
            log.multipleTablesFound(tableName.render());
            String catalogName = catalog == null ? "" : catalog.render();
            String schemaName = schema == null ? "" : schema.render();
            throw new SchemaExtractionException(String.format(Locale.ENGLISH, "More than one table found in namespace (%s, %s) : %s", catalogName, schemaName, tableName.render()));
        }
        TableInformation tableInformation2 = tableInformation;
        return tableInformation2;
        finally {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    protected boolean isPhysicalTableType(String tableType) {
        return "TABLE".equalsIgnoreCase(tableType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ColumnInformation getColumn(TableInformation tableInformation, Identifier columnIdentifier) {
        Identifier catalog = tableInformation.getName().getCatalogName();
        Identifier schema = tableInformation.getName().getSchemaName();
        String catalogFilter = this.extractionContext.getJdbcEnvironment().getNameQualifierSupport().supportsCatalogs() ? (catalog == null ? "" : this.toMetaDataObjectName(catalog)) : null;
        String schemaFilter = this.extractionContext.getJdbcEnvironment().getNameQualifierSupport().supportsSchemas() ? (schema == null ? "" : this.toMetaDataObjectName(schema)) : null;
        String tableFilter = this.toMetaDataObjectName(tableInformation.getName().getTableName());
        String columnFilter = this.toMetaDataObjectName(columnIdentifier);
        try {
            ResultSet resultSet = this.extractionContext.getJdbcDatabaseMetaData().getColumns(catalogFilter, schemaFilter, tableFilter, columnFilter);
            try {
                if (!resultSet.next()) {
                    ColumnInformation columnInformation = null;
                    return columnInformation;
                }
                ColumnInformationImpl columnInformationImpl = new ColumnInformationImpl(tableInformation, this.identifierHelper().toIdentifier(resultSet.getString("COLUMN_NAME")), resultSet.getInt("DATA_TYPE"), new StringTokenizer(resultSet.getString("TYPE_NAME"), "() ").nextToken(), resultSet.getInt("COLUMN_SIZE"), resultSet.getInt("DECIMAL_DIGITS"), this.interpretTruthValue(resultSet.getString("IS_NULLABLE")));
                return columnInformationImpl;
            }
            finally {
                resultSet.close();
            }
        }
        catch (SQLException e) {
            throw this.convertSQLException(e, "Error accessing column metadata: " + tableInformation.getName().toString());
        }
    }

    private TruthValue interpretTruthValue(String nullable) {
        if ("yes".equalsIgnoreCase(nullable)) {
            return TruthValue.TRUE;
        }
        if ("no".equalsIgnoreCase(nullable)) {
            return TruthValue.FALSE;
        }
        return TruthValue.UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrimaryKeyInformation getPrimaryKey(TableInformationImpl tableInformation) {
        try {
            ResultSet resultSet = this.extractionContext.getJdbcDatabaseMetaData().getPrimaryKeys(this.identifierHelper().toMetaDataCatalogName(tableInformation.getName().getCatalogName()), this.identifierHelper().toMetaDataSchemaName(tableInformation.getName().getSchemaName()), this.identifierHelper().toMetaDataObjectName(tableInformation.getName().getTableName()));
            ArrayList<ColumnInformation> pkColumns = new ArrayList<ColumnInformation>();
            boolean firstPass = true;
            Identifier pkIdentifier = null;
            try {
                while (resultSet.next()) {
                    Identifier currentPkIdentifier;
                    String currentPkName = resultSet.getString("PK_NAME");
                    Identifier identifier = currentPkIdentifier = currentPkName == null ? null : this.identifierHelper().toIdentifier(currentPkName);
                    if (firstPass) {
                        pkIdentifier = currentPkIdentifier;
                        firstPass = false;
                    } else if (!EqualsHelper.equals(pkIdentifier, currentPkIdentifier)) {
                        throw new SchemaExtractionException(String.format("Encountered primary keys differing name on table %s", tableInformation.getName().toString()));
                    }
                    int columnPosition = resultSet.getInt("KEY_SEQ");
                    String columnName = resultSet.getString("COLUMN_NAME");
                    Identifier columnIdentifier = this.identifierHelper().toIdentifier(columnName);
                    ColumnInformation column = tableInformation.getColumn(columnIdentifier);
                    pkColumns.add(columnPosition - 1, column);
                }
            }
            finally {
                resultSet.close();
            }
            if (firstPass) {
                return null;
            }
            for (int i = 0; i < pkColumns.size(); ++i) {
                if (pkColumns.get(i) != null) continue;
                throw new SchemaExtractionException("Primary Key information was missing for KEY_SEQ = " + (i + 1));
            }
            return new PrimaryKeyInformationImpl(pkIdentifier, pkColumns);
        }
        catch (SQLException e) {
            throw this.convertSQLException(e, "Error while reading primary key meta data for " + tableInformation.getName().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<IndexInformation> getIndexes(TableInformation tableInformation) {
        HashMap<Identifier, IndexInformationImpl.Builder> builders = new HashMap<Identifier, IndexInformationImpl.Builder>();
        try {
            ResultSet resultSet = this.extractionContext.getJdbcDatabaseMetaData().getIndexInfo(this.identifierHelper().toMetaDataCatalogName(tableInformation.getName().getCatalogName()), this.identifierHelper().toMetaDataSchemaName(tableInformation.getName().getSchemaName()), this.identifierHelper().toMetaDataObjectName(tableInformation.getName().getTableName()), false, true);
            try {
                while (resultSet.next()) {
                    Identifier columnIdentifier;
                    ColumnInformation columnInformation;
                    if (resultSet.getShort("TYPE") == 0) continue;
                    Identifier indexIdentifier = this.identifierHelper().toIdentifier(resultSet.getString("INDEX_NAME"));
                    IndexInformationImpl.Builder builder = (IndexInformationImpl.Builder)builders.get(indexIdentifier);
                    if (builder == null) {
                        builder = IndexInformationImpl.builder(indexIdentifier);
                        builders.put(indexIdentifier, builder);
                    }
                    if ((columnInformation = tableInformation.getColumn(columnIdentifier = this.identifierHelper().toIdentifier(resultSet.getString("COLUMN_NAME")))) == null) {
                        throw new SchemaManagementException("Could not locate column information using identifier [" + columnIdentifier.getText() + "]");
                    }
                    builder.addColumn(columnInformation);
                }
            }
            finally {
                resultSet.close();
            }
        }
        catch (SQLException e) {
            throw this.convertSQLException(e, "Error accessing index information: " + tableInformation.getName().toString());
        }
        ArrayList<IndexInformation> indexes = new ArrayList<IndexInformation>();
        for (IndexInformationImpl.Builder builder : builders.values()) {
            IndexInformationImpl index = builder.build();
            indexes.add(index);
        }
        return indexes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<ForeignKeyInformation> getForeignKeys(TableInformation tableInformation) {
        HashMap<Identifier, ForeignKeyBuilder> fkBuilders = new HashMap<Identifier, ForeignKeyBuilder>();
        try {
            ResultSet resultSet = this.extractionContext.getJdbcDatabaseMetaData().getImportedKeys(this.identifierHelper().toMetaDataCatalogName(tableInformation.getName().getCatalogName()), this.identifierHelper().toMetaDataSchemaName(tableInformation.getName().getSchemaName()), this.identifierHelper().toMetaDataObjectName(tableInformation.getName().getTableName()));
            try {
                while (resultSet.next()) {
                    Identifier fkIdentifier = this.identifierHelper().toIdentifier(resultSet.getString("FK_NAME"));
                    ForeignKeyBuilder fkBuilder = (ForeignKeyBuilder)fkBuilders.get(fkIdentifier);
                    if (fkBuilder == null) {
                        fkBuilder = this.generateForeignKeyBuilder(fkIdentifier);
                        fkBuilders.put(fkIdentifier, fkBuilder);
                    }
                    QualifiedTableName incomingPkTableName = this.extractKeyTableName(resultSet, "PK");
                    TableInformation pkTableInformation = this.extractionContext.getDatabaseObjectAccess().locateTableInformation(incomingPkTableName);
                    if (pkTableInformation == null) continue;
                    Identifier fkColumnIdentifier = this.identifierHelper().toIdentifier(resultSet.getString("FKCOLUMN_NAME"));
                    Identifier pkColumnIdentifier = this.identifierHelper().toIdentifier(resultSet.getString("PKCOLUMN_NAME"));
                    fkBuilder.addColumnMapping(tableInformation.getColumn(fkColumnIdentifier), pkTableInformation.getColumn(pkColumnIdentifier));
                }
            }
            finally {
                resultSet.close();
            }
        }
        catch (SQLException e) {
            throw this.convertSQLException(e, "Error accessing column metadata: " + tableInformation.getName().toString());
        }
        ArrayList<ForeignKeyInformation> fks = new ArrayList<ForeignKeyInformation>();
        for (ForeignKeyBuilder fkBuilder : fkBuilders.values()) {
            ForeignKeyInformation fk = fkBuilder.build();
            fks.add(fk);
        }
        return fks;
    }

    private ForeignKeyBuilder generateForeignKeyBuilder(Identifier fkIdentifier) {
        return new ForeignKeyBuilderImpl(fkIdentifier);
    }

    private QualifiedTableName extractKeyTableName(ResultSet resultSet, String prefix) throws SQLException {
        String incomingCatalogName = resultSet.getString(prefix + "TABLE_CAT");
        String incomingSchemaName = resultSet.getString(prefix + "TABLE_SCHEM");
        String incomingTableName = resultSet.getString(prefix + "TABLE_NAME");
        DatabaseIdentifier catalog = DatabaseIdentifier.toIdentifier(incomingCatalogName);
        DatabaseIdentifier schema = DatabaseIdentifier.toIdentifier(incomingSchemaName);
        DatabaseIdentifier table = DatabaseIdentifier.toIdentifier(incomingTableName);
        return new QualifiedTableName(catalog, schema, table);
    }

    protected static class ForeignKeyBuilderImpl
    implements ForeignKeyBuilder {
        private final Identifier fkIdentifier;
        private final List<ForeignKeyInformation.ColumnReferenceMapping> columnMappingList = new ArrayList<ForeignKeyInformation.ColumnReferenceMapping>();

        public ForeignKeyBuilderImpl(Identifier fkIdentifier) {
            this.fkIdentifier = fkIdentifier;
        }

        @Override
        public ForeignKeyBuilder addColumnMapping(ColumnInformation referencing, ColumnInformation referenced) {
            this.columnMappingList.add(new ForeignKeyInformationImpl.ColumnReferenceMappingImpl(referencing, referenced));
            return this;
        }

        @Override
        public ForeignKeyInformationImpl build() {
            if (this.columnMappingList.isEmpty()) {
                throw new SchemaManagementException("Attempt to resolve foreign key metadata from JDBC metadata failed to find column mappings for foreign key named [" + this.fkIdentifier.getText() + "]");
            }
            return new ForeignKeyInformationImpl(this.fkIdentifier, this.columnMappingList);
        }
    }

    protected static interface ForeignKeyBuilder {
        public ForeignKeyBuilder addColumnMapping(ColumnInformation var1, ColumnInformation var2);

        public ForeignKeyInformation build();
    }
}

