/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.storage.nio.read;

import info.novatec.inspectit.spring.logger.Log;
import info.novatec.inspectit.storage.nio.AbstractChannelManager;
import info.novatec.inspectit.storage.nio.CustomAsyncChannel;
import info.novatec.inspectit.storage.nio.WriteReadAttachment;
import info.novatec.inspectit.storage.nio.WriteReadCompletionRunnable;
import info.novatec.inspectit.storage.nio.read.ReadingCompletionHandler;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import org.slf4j.Logger;

public class ReadingChannelManager
extends AbstractChannelManager {
    @Log
    Logger log;
    private int maxOpenedChannels = 128;

    public void read(ByteBuffer byteBuffer, long position, long size, Path channelPath, WriteReadCompletionRunnable completionRunnable) throws IOException {
        long readSize = size <= 0L ? (long)(byteBuffer.capacity() - byteBuffer.position()) : size;
        if ((long)(byteBuffer.capacity() - byteBuffer.position()) < readSize) {
            throw new IllegalArgumentException("Buffer capacity not big enough for wanted read size");
        }
        CustomAsyncChannel channel = super.getChannel(channelPath);
        WriteReadAttachment attachment = new WriteReadAttachment();
        attachment.setByteBuffer(byteBuffer);
        attachment.setSize(readSize);
        attachment.setFileChannel(channel.getFileChannel());
        attachment.setCompletionRunnable(completionRunnable);
        boolean read = false;
        while (!read) {
            read = channel.read(byteBuffer, position, attachment, new ReadingCompletionHandler());
            if (read) continue;
            if (this.log.isDebugEnabled()) {
                this.log.info("Failed to submit reading IO task, channel is closed. Trying to reopen the channel..");
            }
            this.openAsyncChannel(channel);
        }
    }

    @Override
    protected int getMaxOpenedChannels() {
        return this.maxOpenedChannels;
    }
}

