/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.storage.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomAsyncChannel {
    private Logger log = LoggerFactory.getLogger(CustomAsyncChannel.class);
    private Path path;
    private AsynchronousFileChannel fileChannel;
    private AtomicLong nextWritingPosition = new AtomicLong();
    private ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private Lock openCloseLock = this.readWriteLock.writeLock();
    private Lock writeReadChannelLock = this.readWriteLock.readLock();

    public CustomAsyncChannel(Path path) {
        this.path = path;
    }

    public Path getPath() {
        return this.path;
    }

    public AsynchronousFileChannel getFileChannel() {
        return this.fileChannel;
    }

    public void openChannel() throws IOException {
        this.openChannel(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean openChannel(ExecutorService executorService) throws IOException {
        this.openCloseLock.lock();
        try {
            if (!this.isOpened()) {
                HashSet<StandardOpenOption> optionsSet = new HashSet<StandardOpenOption>();
                optionsSet.add(StandardOpenOption.CREATE);
                optionsSet.add(StandardOpenOption.WRITE);
                optionsSet.add(StandardOpenOption.READ);
                this.fileChannel = AsynchronousFileChannel.open(this.path, optionsSet, executorService, new FileAttribute[0]);
                if (this.log.isDebugEnabled()) {
                    this.log.info("Channel opened for path " + this.path + ". Next write position is " + this.nextWritingPosition.get() + ".");
                }
                boolean bl = true;
                return bl;
            }
            if (this.log.isDebugEnabled()) {
                this.log.info("Tried to open already opened channel for path " + this.path + ".");
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.openCloseLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean closeChannel() throws IOException {
        this.openCloseLock.lock();
        try {
            if (this.isOpened()) {
                this.fileChannel.force(true);
                this.fileChannel.close();
                if (this.log.isDebugEnabled()) {
                    this.log.info("Channel closed for path " + this.path + ". Next write position is " + this.nextWritingPosition.get() + ".");
                }
                boolean bl = true;
                return bl;
            }
            if (this.log.isDebugEnabled()) {
                this.log.info("Tried to close already closed channel for path " + this.path + ".");
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.openCloseLock.unlock();
        }
    }

    public boolean isOpened() {
        return this.fileChannel != null && this.fileChannel.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <A> boolean write(ByteBuffer src, long position, A attachment, CompletionHandler<Integer, ? super A> handler) {
        this.writeReadChannelLock.lock();
        try {
            if (this.isOpened()) {
                this.fileChannel.write(src, position, attachment, handler);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeReadChannelLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <A> boolean read(ByteBuffer dst, long position, A attachment, CompletionHandler<Integer, ? super A> handler) {
        this.writeReadChannelLock.lock();
        try {
            if (this.isOpened()) {
                this.fileChannel.read(dst, position, attachment, handler);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeReadChannelLock.unlock();
        }
    }

    public long reserveWritingPosition(long writeSize) {
        long writingPosition;
        while (!this.nextWritingPosition.compareAndSet(writingPosition = this.nextWritingPosition.get(), writingPosition + writeSize)) {
        }
        return writingPosition;
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this);
        toStringBuilder.append("path", (Object)this.path);
        toStringBuilder.append("opened", this.isOpened());
        toStringBuilder.append("nextWritingPosition", this.nextWritingPosition.get());
        return toStringBuilder.toString();
    }
}

