/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.indexing.storage.impl;

import info.novatec.inspectit.cmr.cache.IObjectSizes;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.indexing.IIndexQuery;
import info.novatec.inspectit.indexing.QueryTask;
import info.novatec.inspectit.indexing.impl.IndexingException;
import info.novatec.inspectit.indexing.storage.IStorageDescriptor;
import info.novatec.inspectit.indexing.storage.IStorageTreeComponent;
import info.novatec.inspectit.indexing.storage.impl.StorageIndexQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveTask;
import org.apache.commons.lang.builder.ToStringBuilder;

public class CombinedStorageBranch<E extends DefaultData>
implements IStorageTreeComponent<E> {
    private List<IStorageTreeComponent<E>> branches;

    public CombinedStorageBranch() {
        this.branches = new ArrayList<IStorageTreeComponent<E>>();
    }

    public CombinedStorageBranch(List<IStorageTreeComponent<E>> branches) {
        this.branches = branches;
    }

    public List<IStorageTreeComponent<E>> getBranches() {
        return this.branches;
    }

    public void setBranches(List<IStorageTreeComponent<E>> branches) {
        this.branches = branches;
    }

    public void addBranch(IStorageTreeComponent<E> branch) {
        this.branches.add(branch);
    }

    @Override
    public IStorageDescriptor put(E element) throws IndexingException {
        throw new UnsupportedOperationException("Combined storage branch provides only read-only operations.");
    }

    @Override
    public IStorageDescriptor get(E element) {
        for (IStorageTreeComponent<E> branch : this.branches) {
            IStorageDescriptor descriptor = (IStorageDescriptor)branch.get(element);
            if (descriptor == null) continue;
            return descriptor;
        }
        return null;
    }

    public List<IStorageDescriptor> query(StorageIndexQuery query) {
        ArrayList<IStorageDescriptor> combinedResult = new ArrayList<IStorageDescriptor>();
        for (IStorageTreeComponent<E> branch : this.branches) {
            List branchResult = branch.query(query);
            if (branchResult == null || branchResult.isEmpty()) continue;
            combinedResult.addAll(branchResult);
        }
        return combinedResult;
    }

    @Override
    public void preWriteFinalization() {
        for (IStorageTreeComponent<E> branch : this.branches) {
            branch.preWriteFinalization();
        }
    }

    @Override
    public List<IStorageDescriptor> query(IIndexQuery query) {
        ArrayList<IStorageDescriptor> combinedResult = new ArrayList<IStorageDescriptor>();
        for (IStorageTreeComponent<E> branch : this.branches) {
            List branchResult = branch.query(query);
            if (branchResult == null || branchResult.isEmpty()) continue;
            combinedResult.addAll(branchResult);
        }
        return combinedResult;
    }

    @Override
    public List<IStorageDescriptor> query(IIndexQuery query, ForkJoinPool forkJoinPool) {
        return forkJoinPool.invoke(this.getTaskForForkJoinQuery(query));
    }

    @Override
    public IStorageDescriptor getAndRemove(E element) {
        throw new UnsupportedOperationException("Combined storage branch provides only read-only operations.");
    }

    @Override
    public long getComponentSize(IObjectSizes objectSizes) {
        long size = objectSizes.getSizeOfObjectHeader() + objectSizes.getPrimitiveTypesSize(1, 0, 0, 0, 0, 0);
        size += objectSizes.getSizeOf(this.branches);
        for (IStorageTreeComponent<E> branch : this.branches) {
            size += branch.getComponentSize(objectSizes);
        }
        return objectSizes.alignTo8Bytes(size);
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this);
        toStringBuilder.append("branches", this.branches);
        return toStringBuilder.toString();
    }

    public List<IStorageTreeComponent<E>> getBranchesToQuery(IIndexQuery query) {
        return this.getBranches();
    }

    @Override
    public RecursiveTask<List<IStorageDescriptor>> getTaskForForkJoinQuery(IIndexQuery query) {
        return new QueryTask(this.branches, query);
    }
}

