/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.indexing.storage.impl;

import info.novatec.inspectit.cmr.cache.IObjectSizes;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.indexing.IIndexQuery;
import info.novatec.inspectit.indexing.LeafTask;
import info.novatec.inspectit.indexing.impl.IndexingException;
import info.novatec.inspectit.indexing.storage.IStorageDescriptor;
import info.novatec.inspectit.indexing.storage.IStorageTreeComponent;
import info.novatec.inspectit.indexing.storage.impl.SimpleStorageDescriptor;
import info.novatec.inspectit.indexing.storage.impl.StorageDescriptor;
import info.novatec.inspectit.indexing.storage.impl.StorageIndexQuery;
import info.novatec.inspectit.storage.util.StorageUtil;
import info.novatec.inspectit.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.RecursiveTask;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang.builder.ToStringBuilder;

public class ArrayBasedStorageLeaf<E extends DefaultData>
implements IStorageTreeComponent<E> {
    private static final int DEFAULT_CAPACITY = 16;
    private int id;
    private int capacity;
    private int size;
    private long[] idArray;
    private SimpleStorageDescriptor[] descriptorArray;
    private transient Lock readLock;
    private transient Lock writeLock;

    public ArrayBasedStorageLeaf() {
        this(StorageUtil.getRandomInt());
    }

    public ArrayBasedStorageLeaf(int id) {
        this.id = id;
        this.capacity = 16;
        this.size = 0;
        this.idArray = new long[this.capacity];
        this.descriptorArray = new SimpleStorageDescriptor[this.capacity];
        ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
        this.readLock = rwl.readLock();
        this.writeLock = rwl.writeLock();
    }

    @Override
    public IStorageDescriptor put(E element) throws IndexingException {
        if (null == element) {
            throw new IndexingException("Element to index can not be null.");
        }
        if (0L == element.getId()) {
            throw new IndexingException("Element to index can not have ID that is equal to zero.");
        }
        StorageDescriptor descriptor = new StorageDescriptor(this.id);
        if (this.insertIntoArrays(element.getId(), descriptor.getSimpleStorageDescriptor())) {
            return descriptor;
        }
        throw new IndexingException("Element already indexed.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean insertIntoArrays(long id, SimpleStorageDescriptor simpleDescriptor) {
        this.writeLock.lock();
        try {
            int index = ArrayUtil.binarySearch((long[])this.idArray, (int)0, (int)this.size, (long)id);
            if (index >= 0) {
                boolean bl = false;
                return bl;
            }
            if ((index = -index - 1) > this.size) {
                index = this.size;
            }
            int oldCapacity = this.capacity;
            int oldSize = this.size++;
            long[] oldIds = this.idArray;
            SimpleStorageDescriptor[] oldDescriptors = this.descriptorArray;
            if (this.size == this.capacity) {
                this.capacity *= 2;
                this.idArray = new long[this.capacity];
                this.descriptorArray = new SimpleStorageDescriptor[this.capacity];
            }
            if (oldCapacity != this.capacity) {
                System.arraycopy(oldIds, 0, this.idArray, 0, index);
                System.arraycopy(oldDescriptors, 0, this.descriptorArray, 0, index);
            }
            if (index < oldSize) {
                System.arraycopy(oldIds, index, this.idArray, index + 1, oldSize - index);
                System.arraycopy(oldDescriptors, index, this.descriptorArray, index + 1, oldSize - index);
            }
            this.idArray[index] = id;
            this.descriptorArray[index] = simpleDescriptor;
            boolean bl = true;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IStorageDescriptor get(E element) {
        this.readLock.lock();
        try {
            int index = ArrayUtil.binarySearch((long[])this.idArray, (int)0, (int)this.size, (long)element.getId());
            if (index >= 0) {
                SimpleStorageDescriptor simpleDescriptor = this.descriptorArray[index];
                if (null != simpleDescriptor) {
                    StorageDescriptor storageDescriptor = new StorageDescriptor(this.id, simpleDescriptor);
                    return storageDescriptor;
                }
                IStorageDescriptor iStorageDescriptor = null;
                return iStorageDescriptor;
            }
            IStorageDescriptor iStorageDescriptor = null;
            return iStorageDescriptor;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IStorageDescriptor> query(IIndexQuery query) {
        if (query instanceof StorageIndexQuery) {
            return this.queryWithStorageQuery((StorageIndexQuery)query);
        }
        this.readLock.lock();
        try {
            ArrayList<IStorageDescriptor> returnList = new ArrayList<IStorageDescriptor>();
            int index = 0;
            if (query.getMinId() != 0L && (index = ArrayUtil.binarySearch((long[])this.idArray, (int)0, (int)this.size, (long)query.getMinId())) < 0) {
                index = -index - 1;
            }
            while (index < this.size) {
                SimpleStorageDescriptor simpleDescriptor;
                if (0L != this.idArray[index] && null != (simpleDescriptor = this.descriptorArray[index])) {
                    returnList.add(new StorageDescriptor(this.id, simpleDescriptor));
                }
                ++index;
            }
            ArrayList<IStorageDescriptor> arrayList = returnList;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public List<IStorageDescriptor> query(IIndexQuery query, ForkJoinPool forkJoinPool) {
        return forkJoinPool.invoke(this.getTaskForForkJoinQuery(query));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IStorageDescriptor> queryWithStorageQuery(StorageIndexQuery query) {
        this.readLock.lock();
        try {
            ArrayList<IStorageDescriptor> returnList = new ArrayList<IStorageDescriptor>();
            int index = 0;
            if (query.getMinId() != 0L && (index = ArrayUtil.binarySearch((long[])this.idArray, (int)0, (int)this.size, (long)query.getMinId())) < 0) {
                index = -index - 1;
            }
            while (index < this.size) {
                SimpleStorageDescriptor simpleDescriptor;
                if (!(query.getExcludeIds() != null && query.getExcludeIds().contains(this.idArray[index]) || 0L == this.idArray[index] || query.getIncludeIds() != null && !query.getIncludeIds().contains(this.idArray[index]) || null == (simpleDescriptor = this.descriptorArray[index]))) {
                    returnList.add(new StorageDescriptor(this.id, simpleDescriptor));
                }
                ++index;
            }
            ArrayList<IStorageDescriptor> arrayList = returnList;
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IStorageDescriptor getAndRemove(E element) {
        SimpleStorageDescriptor simpleDescriptor;
        int index;
        this.readLock.lock();
        try {
            index = ArrayUtil.binarySearch((long[])this.idArray, (int)0, (int)this.size, (long)element.getId());
            if (index < 0) {
                IStorageDescriptor iStorageDescriptor = null;
                return iStorageDescriptor;
            }
            simpleDescriptor = this.descriptorArray[index];
        }
        finally {
            this.readLock.unlock();
        }
        this.writeLock.lock();
        try {
            System.arraycopy(this.idArray, index + 1, this.idArray, index, this.size - index - 1);
            System.arraycopy(this.descriptorArray, index + 1, this.descriptorArray, index, this.size - index - 1);
            --this.size;
            this.idArray[this.size] = 0L;
            this.descriptorArray[this.size] = null;
            StorageDescriptor storageDescriptor = new StorageDescriptor(this.id, simpleDescriptor);
            return storageDescriptor;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void preWriteFinalization() {
    }

    @Override
    public long getComponentSize(IObjectSizes objectSizes) {
        long sizeInBytes = objectSizes.getSizeOfObjectHeader();
        sizeInBytes += objectSizes.getPrimitiveTypesSize(2, 0, 4, 0, 0, 0);
        sizeInBytes += objectSizes.getSizeOfArray(this.idArray.length);
        sizeInBytes += (long)this.size * objectSizes.getPrimitiveTypesSize(0, 0, 1, 0, 0, 0);
        sizeInBytes += objectSizes.getSizeOfArray(this.descriptorArray.length);
        return objectSizes.alignTo8Bytes(sizeInBytes += (long)this.size * objectSizes.alignTo8Bytes(objectSizes.getSizeOfObjectHeader() + objectSizes.getPrimitiveTypesSize(0, 0, 1, 0, 1, 0)));
    }

    int getId() {
        return this.id;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.capacity;
        result = 31 * result + Arrays.hashCode(this.descriptorArray);
        result = 31 * result + this.id;
        result = 31 * result + Arrays.hashCode(this.idArray);
        result = 31 * result + this.size;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArrayBasedStorageLeaf other = (ArrayBasedStorageLeaf)obj;
        if (this.capacity != other.capacity) {
            return false;
        }
        if (!Arrays.equals(this.descriptorArray, other.descriptorArray)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (!Arrays.equals(this.idArray, other.idArray)) {
            return false;
        }
        return this.size == other.size;
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this);
        toStringBuilder.append("elements", this.size);
        toStringBuilder.append("capacity", this.capacity);
        return toStringBuilder.toString();
    }

    @Override
    public RecursiveTask<List<IStorageDescriptor>> getTaskForForkJoinQuery(IIndexQuery query) {
        return new LeafTask(this, query);
    }
}

