/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.property.configuration.impl;

import info.novatec.inspectit.cmr.property.configuration.SingleProperty;
import info.novatec.inspectit.cmr.property.update.AbstractPropertyUpdate;
import info.novatec.inspectit.cmr.property.update.impl.BytePropertyUpdate;
import java.util.Locale;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="byte-property")
public class ByteProperty
extends SingleProperty<Long> {
    @XmlAttribute(name="used-value")
    private String usedValue;
    @XmlAttribute(name="default-value", required=true)
    private String defaultValue;

    public ByteProperty() {
    }

    public ByteProperty(String name, String description, String logicalName, Long defaultValue, boolean advanced, boolean serverRestartRequired) throws IllegalArgumentException {
        super(name, description, logicalName, defaultValue, advanced, serverRestartRequired);
    }

    @Override
    public Long getDefaultValue() {
        return ByteProperty.fromString(this.defaultValue);
    }

    @Override
    protected void setDefaultValue(Long defaultValue) {
        this.defaultValue = ByteProperty.toString(defaultValue);
    }

    @Override
    protected Long getUsedValue() {
        if (null != this.usedValue) {
            return ByteProperty.fromString(this.usedValue);
        }
        return null;
    }

    @Override
    protected void setUsedValue(Long usedValue) {
        this.usedValue = null != usedValue ? ByteProperty.toString(usedValue) : null;
    }

    @Override
    protected AbstractPropertyUpdate<Long> createPropertyUpdate(Long updateValue) {
        return new BytePropertyUpdate(this, updateValue);
    }

    @Override
    public Long parseLiteral(String literal) {
        return ByteProperty.fromString(literal);
    }

    @Override
    public String getFormattedValue() {
        if (null != this.usedValue) {
            return this.usedValue;
        }
        return this.defaultValue;
    }

    public static Long fromString(String str) {
        if (null == str) {
            return null;
        }
        int exp = 0;
        int length = str.length();
        Character c = Character.valueOf(str.charAt(length - 2));
        switch (c.charValue()) {
            case 'E': {
                ++exp;
            }
            case 'P': {
                ++exp;
            }
            case 'T': {
                ++exp;
            }
            case 'G': {
                ++exp;
            }
            case 'M': {
                ++exp;
            }
            case 'K': {
                ++exp;
            }
        }
        String number = exp == 0 ? str.substring(0, length - 1) : str.substring(0, length - 2);
        try {
            return (long)(Double.parseDouble(number) * Math.pow(1024.0, exp));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static String toString(long bytes) {
        int end;
        int unit = 1024;
        if (bytes < (long)unit) {
            return bytes + "B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = String.valueOf("KMGTPE".charAt(exp - 1));
        String result = String.format(Locale.ENGLISH, "%f", (double)bytes / Math.pow(unit, exp));
        for (end = result.length(); end > 0; --end) {
            char c = result.charAt(end - 1);
            if (c == '.') {
                --end;
                break;
            }
            if (c != '0') break;
        }
        if (end == result.length()) {
            return result + pre + "B";
        }
        return result.substring(0, end) + pre + "B";
    }
}

