/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.storage;

import com.esotericsoftware.kryo.io.Input;
import info.novatec.inspectit.cmr.cache.IBuffer;
import info.novatec.inspectit.cmr.dao.StorageDataDao;
import info.novatec.inspectit.cmr.service.IServerStatusService;
import info.novatec.inspectit.cmr.storage.CmrStorageRecorder;
import info.novatec.inspectit.cmr.storage.CmrStorageWriter;
import info.novatec.inspectit.cmr.storage.CmrStorageWriterProvider;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.data.cmr.WritingStatus;
import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.exception.IErrorCode;
import info.novatec.inspectit.exception.enumeration.StorageErrorCodeEnum;
import info.novatec.inspectit.spring.logger.Log;
import info.novatec.inspectit.storage.IStorageData;
import info.novatec.inspectit.storage.StorageData;
import info.novatec.inspectit.storage.StorageFileType;
import info.novatec.inspectit.storage.StorageManager;
import info.novatec.inspectit.storage.StorageWriter;
import info.novatec.inspectit.storage.label.AbstractStorageLabel;
import info.novatec.inspectit.storage.processor.AbstractDataProcessor;
import info.novatec.inspectit.storage.processor.impl.TimeFrameDataProcessor;
import info.novatec.inspectit.storage.recording.RecordingProperties;
import info.novatec.inspectit.storage.recording.RecordingState;
import info.novatec.inspectit.storage.serializer.ISerializer;
import info.novatec.inspectit.storage.serializer.SerializationException;
import info.novatec.inspectit.storage.serializer.impl.SerializationManager;
import info.novatec.inspectit.storage.util.CopyMoveFileVisitor;
import info.novatec.inspectit.storage.util.DeleteFileVisitor;
import info.novatec.inspectit.version.VersionService;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.mutable.MutableLong;
import org.apache.commons.lang.mutable.MutableObject;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class CmrStorageManager
extends StorageManager
implements ApplicationListener<ContextClosedEvent> {
    @Log
    Logger log;
    private static final int UPDATE_RATE = 30000;
    @Autowired
    StorageDataDao storageDataDao;
    @Autowired
    IBuffer<DefaultData> buffer;
    private volatile StorageData recorderStorageData = null;
    @Autowired
    CmrStorageWriterProvider storageWriterProvider;
    private Map<StorageData, StorageWriter> openedStoragesMap = new ConcurrentHashMap<StorageData, StorageWriter>(8, 0.75f, 1);
    private Set<StorageData> existingStoragesSet;
    @Autowired
    CmrStorageRecorder storageRecorder;
    @Autowired
    IServerStatusService serverStatusService;
    @Autowired
    VersionService versionService;
    private String cmrVersion;

    public void createStorage(StorageData storageData) throws IOException, SerializationException, BusinessException {
        if (null == storageData.getName()) {
            throw new BusinessException("Create new storage.", (IErrorCode)StorageErrorCodeEnum.STORAGE_NAME_IS_NOT_PROVIDED);
        }
        storageData.setId(this.getRandomUUIDString());
        storageData.setCmrVersion(this.cmrVersion);
        this.writeStorageDataToDisk(storageData);
        this.existingStoragesSet.add(storageData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StorageWriter openStorage(StorageData storageData) throws IOException, SerializationException, BusinessException {
        StorageData local;
        StorageData storageData2 = local = this.getLocalStorageDataObject(storageData);
        synchronized (storageData2) {
            if (this.isStorageClosed(local)) {
                throw new BusinessException("Open the storage " + local + ".", (IErrorCode)StorageErrorCodeEnum.STORAGE_ALREADY_CLOSED);
            }
            if (!this.isStorageOpen(local)) {
                local.markOpened();
                CmrStorageWriter writer = this.storageWriterProvider.getCmrStorageWriter();
                this.openedStoragesMap.put(local, writer);
                writer.prepareForWrite(local);
                this.writeStorageDataToDisk(local);
                return writer;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeStorage(StorageData storageData) throws BusinessException, IOException, SerializationException {
        StorageData local;
        StorageData storageData2 = local = this.getLocalStorageDataObject(storageData);
        synchronized (storageData2) {
            if ((this.storageRecorder.isRecordingOn() || this.storageRecorder.isRecordingScheduled()) && Objects.equals(local, this.recorderStorageData)) {
                throw new BusinessException("Close the storage " + local + ".", (IErrorCode)StorageErrorCodeEnum.STORAGE_CAN_NOT_BE_CLOSED);
            }
            if (this.isStorageClosed(local)) {
                throw new BusinessException("Close the storage " + local + ".", (IErrorCode)StorageErrorCodeEnum.STORAGE_ALREADY_CLOSED);
            }
            StorageWriter writer = this.openedStoragesMap.get(local);
            if (writer != null) {
                writer.closeStorageWriter();
            }
            this.openedStoragesMap.remove(local);
            local.setDiskSize(this.getDiskSizeForStorage(local));
            local.markClosed();
            this.writeStorageDataToDisk(local);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteStorage(StorageData storageData) throws BusinessException, IOException {
        StorageData local;
        StorageData storageData2 = local = this.getLocalStorageDataObject(storageData);
        synchronized (storageData2) {
            if ((this.storageRecorder.isRecordingOn() || this.storageRecorder.isRecordingScheduled()) && Objects.equals(local, this.recorderStorageData)) {
                throw new BusinessException("Delete the storage " + local + ".", (IErrorCode)StorageErrorCodeEnum.STORAGE_ALREADY_CLOSED);
            }
            if (local.isStorageOpened()) {
                StorageWriter writer = this.openedStoragesMap.get(local);
                if (writer != null) {
                    writer.cancel();
                }
                this.openedStoragesMap.remove(local);
            }
            this.deleteCompleteStorageDataFromDisk((IStorageData)local);
            this.existingStoragesSet.remove(local);
        }
    }

    public StorageData getRecordingStorage() {
        return this.recorderStorageData;
    }

    public RecordingProperties getRecordingProperties() {
        return this.storageRecorder.getRecordingProperties();
    }

    public RecordingState getRecordingState() {
        return this.storageRecorder.getRecordingState();
    }

    public WritingStatus getRecordingStatus() {
        StorageWriter recordingStorageWriter = this.storageRecorder.getStorageWriter();
        if (null != recordingStorageWriter) {
            return recordingStorageWriter.getWritingStatus();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startOrScheduleRecording(StorageData storageData, RecordingProperties recordingProperties) throws IOException, SerializationException, BusinessException {
        StorageData local;
        if (!this.isStorageExisting(storageData)) {
            this.createStorage(storageData);
        }
        if (!this.isStorageOpen(local = this.getLocalStorageDataObject(storageData))) {
            this.openStorage(local);
        }
        CmrStorageManager cmrStorageManager = this;
        synchronized (cmrStorageManager) {
            if (!this.storageRecorder.isRecordingOn() && !this.storageRecorder.isRecordingScheduled()) {
                StorageWriter storageWriter = this.openedStoragesMap.remove(local);
                this.storageRecorder.startOrScheduleRecording(storageWriter, recordingProperties);
                this.recorderStorageData = local;
                this.recorderStorageData.markRecording();
                this.writeStorageDataToDisk(this.recorderStorageData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRecording() throws IOException, SerializationException, BusinessException {
        CmrStorageManager cmrStorageManager = this;
        synchronized (cmrStorageManager) {
            if (this.storageRecorder.isRecordingOn() || this.storageRecorder.isRecordingScheduled()) {
                boolean autoFinalize = this.storageRecorder.getRecordingProperties().isAutoFinalize();
                StorageWriter storageWriter = this.storageRecorder.getStorageWriter();
                this.storageRecorder.stopRecording();
                this.recorderStorageData.markOpened();
                this.openedStoragesMap.put(this.recorderStorageData, storageWriter);
                if (autoFinalize) {
                    this.closeStorage(this.recorderStorageData);
                }
                this.writeStorageDataToDisk(this.recorderStorageData);
                this.recorderStorageData = null;
            }
        }
    }

    public void record(DefaultData dataToRecord) {
        if (this.storageRecorder.isRecordingOn() && this.canWriteMore()) {
            this.storageRecorder.record(dataToRecord);
        } else if (this.storageRecorder.isRecordingOn() && !this.canWriteMore()) {
            try {
                this.stopRecording();
            }
            catch (Exception e) {
                this.log.warn("Exception occurred trying to automatically stop the recording due to the hard disk space limitation warning.", (Throwable)e);
            }
        }
    }

    public void writeToStorage(StorageData storageData, Collection<? extends DefaultData> dataToWrite, Collection<AbstractDataProcessor> dataProcessors, boolean synchronously) throws BusinessException, IOException, SerializationException {
        StorageData local = this.getLocalStorageDataObject(storageData);
        StorageWriter writer = this.openedStoragesMap.get(local);
        if (writer != null) {
            if (synchronously) {
                writer.processSynchronously(dataToWrite, dataProcessors);
            } else {
                writer.process(dataToWrite, dataProcessors);
            }
        } else {
            if (Objects.equals(local, this.recorderStorageData)) {
                throw new BusinessException("Write data to storage " + local + ".", (IErrorCode)StorageErrorCodeEnum.WRITE_FAILED);
            }
            if (local.getState() == StorageData.StorageState.CLOSED) {
                throw new BusinessException("Write data to storage " + local + ".", (IErrorCode)StorageErrorCodeEnum.STORAGE_ALREADY_CLOSED);
            }
            this.log.error("Writer for the not closed storage " + local + " is not available.");
            throw new RuntimeException("Writer for the not closed storage " + local + " is not available.");
        }
    }

    public void copyBufferToStorage(StorageData storageData, List<Long> platformIdents, Collection<AbstractDataProcessor> dataProcessors, boolean autoFinalize) throws BusinessException, IOException, SerializationException {
        DefaultData oldestBufferElement;
        StorageData local;
        if (!this.isStorageExisting(storageData)) {
            this.createStorage(storageData);
        }
        if (!this.isStorageOpen(local = this.getLocalStorageDataObject(storageData))) {
            this.openStorage(local);
        }
        if (null != (oldestBufferElement = this.buffer.getOldestElement())) {
            Date fromDate = new Date(oldestBufferElement.getTimeStamp().getTime());
            Date toDate = null;
            for (AbstractDataProcessor dataProcessor : dataProcessors) {
                if (!(dataProcessor instanceof TimeFrameDataProcessor)) continue;
                TimeFrameDataProcessor timeFrameDataProcessor = (TimeFrameDataProcessor)dataProcessor;
                if (timeFrameDataProcessor.getFromDate().after(fromDate)) {
                    fromDate = timeFrameDataProcessor.getFromDate();
                }
                toDate = timeFrameDataProcessor.getToDate();
                break;
            }
            for (Long platformId : platformIdents) {
                List<DefaultData> toWriteList = this.storageDataDao.getAllDefaultDataForAgent(platformId, fromDate, toDate);
                this.writeToStorage(local, toWriteList, dataProcessors, true);
            }
        }
        if (autoFinalize) {
            this.closeStorage(local);
        }
        this.updateExistingStorageSize(local);
    }

    public void copyDataToStorage(StorageData storageData, Collection<Long> elementIds, long platformIdent, Collection<AbstractDataProcessor> dataProcessors, boolean autoFinalize) throws IOException, SerializationException, BusinessException {
        StorageData local;
        if (!this.isStorageExisting(storageData)) {
            this.createStorage(storageData);
        }
        if (!this.isStorageOpen(local = this.getLocalStorageDataObject(storageData))) {
            this.openStorage(local);
        }
        List<DefaultData> toWriteList = this.storageDataDao.getDataFromIdList(elementIds, platformIdent);
        this.writeToStorage(local, toWriteList, dataProcessors, true);
        if (autoFinalize) {
            this.closeStorage(local);
        }
        this.updateExistingStorageSize(local);
    }

    protected void closeAllStorages() {
        if (this.storageRecorder.isRecordingOn() || this.storageRecorder.isRecordingScheduled()) {
            try {
                this.stopRecording();
            }
            catch (Exception e) {
                this.log.warn("Recording storage could not be finalized during the CMR shut-down.", (Throwable)e);
            }
        }
        for (StorageData openedStorage : this.openedStoragesMap.keySet()) {
            try {
                this.closeStorage(openedStorage);
            }
            catch (Exception e) {
                this.log.warn("Storage " + openedStorage + " could not be finalized during the CMR shut-down.", (Throwable)e);
            }
        }
    }

    public StorageData getStorageData(String id) {
        for (StorageData storageData : this.existingStoragesSet) {
            if (!storageData.getId().equals(id)) continue;
            return storageData;
        }
        return null;
    }

    public List<StorageData> getExistingStorages() {
        ArrayList<StorageData> list = new ArrayList<StorageData>();
        list.addAll(this.existingStoragesSet);
        return list;
    }

    public List<StorageData> getOpenedStorages() {
        ArrayList<StorageData> list = new ArrayList<StorageData>();
        list.addAll(this.openedStoragesMap.keySet());
        return list;
    }

    public List<StorageData> getReadableStorages() {
        ArrayList<StorageData> list = new ArrayList<StorageData>();
        for (StorageData storageData : this.existingStoragesSet) {
            if (!storageData.isStorageClosed()) continue;
            list.add(storageData);
        }
        return list;
    }

    public boolean isStorageOpen(StorageData storageData) {
        for (StorageData existing : this.openedStoragesMap.keySet()) {
            if (!existing.getId().equals(storageData.getId())) continue;
            return true;
        }
        return false;
    }

    public boolean isStorageExisting(StorageData storageData) {
        for (StorageData existing : this.existingStoragesSet) {
            if (!existing.getId().equals(storageData.getId())) continue;
            return true;
        }
        return false;
    }

    public boolean isStorageClosed(StorageData storageData) {
        for (StorageData existing : this.existingStoragesSet) {
            if (!existing.getId().equals(storageData.getId())) continue;
            return existing.isStorageClosed();
        }
        return false;
    }

    public long getStorageQueuedWriteTaskCount(StorageData storageData) {
        try {
            StorageData local = this.getLocalStorageDataObject(storageData);
            if (!this.isStorageOpen(local)) {
                return 0L;
            }
            StorageWriter storageWriter = this.openedStoragesMap.get(local);
            if (null == storageWriter) {
                return 0L;
            }
            return storageWriter.getQueuedTaskCount();
        }
        catch (BusinessException e) {
            return 0L;
        }
    }

    public Path getStoragePath(IStorageData storageData) {
        return this.getDefaultStorageDirPath().resolve(storageData.getStorageFolder());
    }

    protected Path getDefaultStorageDirPath() {
        return Paths.get(this.getStorageDefaultFolder(), new String[0]).toAbsolutePath();
    }

    public Map<String, Long> getFilesHttpLocation(StorageData storageData, final String extension) throws IOException {
        Path storagePath = this.getStoragePath((IStorageData)storageData);
        if (storagePath == null || !Files.isDirectory(storagePath, new LinkOption[0])) {
            return Collections.emptyMap();
        }
        final ArrayList filesPaths = new ArrayList();
        Files.walkFileTree(storagePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.toString().endsWith(extension)) {
                    filesPaths.add(file);
                }
                return super.visitFile(file, attrs);
            }
        });
        HashMap<String, Long> result = new HashMap<String, Long>();
        for (Path path : filesPaths) {
            result.put(this.getPathAsHttp(path), Files.size(path));
        }
        return result;
    }

    public void addLabelToStorage(StorageData storageData, AbstractStorageLabel<?> storageLabel, boolean doOverwrite) throws IOException, SerializationException, BusinessException {
        StorageData local = this.getLocalStorageDataObject(storageData);
        if (null != local) {
            local.addLabel(storageLabel, doOverwrite);
            this.writeStorageDataToDisk(local);
        }
    }

    public boolean removeLabelFromStorage(StorageData storageData, AbstractStorageLabel<?> storageLabel) throws IOException, SerializationException, BusinessException {
        StorageData local = this.getLocalStorageDataObject(storageData);
        if (null != local) {
            boolean removed = local.removeLabel(storageLabel);
            this.writeStorageDataToDisk(local);
            return removed;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStorageData(StorageData storageData) throws BusinessException, IOException, SerializationException {
        StorageData local = this.getLocalStorageDataObject(storageData);
        if (null == local) {
            throw new BusinessException("Update of the storage data" + storageData + ".", (IErrorCode)StorageErrorCodeEnum.STORAGE_DOES_NOT_EXIST);
        }
        StorageData storageData2 = local;
        synchronized (storageData2) {
            local.setName(storageData.getName());
            local.setDescription(storageData.getDescription());
            this.writeStorageDataToDisk(local);
        }
    }

    public Map<StorageData, String> getWritersStatus() {
        HashMap<StorageData, String> map = new HashMap<StorageData, String>();
        for (Map.Entry<StorageData, StorageWriter> entry : this.openedStoragesMap.entrySet()) {
            map.put(entry.getKey(), entry.getValue().getExecutorServiceStatus());
        }
        if (this.storageRecorder.isRecordingOn()) {
            StorageData storageData = this.recorderStorageData;
            StorageWriter storageWriter = this.storageRecorder.getStorageWriter();
            if (null != storageData && null != storageWriter) {
                map.put(storageData, storageWriter.getExecutorServiceStatus());
            }
        }
        return map;
    }

    @Scheduled(fixedRate=30000L)
    protected void updateExistingStoragesSize() throws IOException, SerializationException {
        for (StorageData storageData : this.existingStoragesSet) {
            this.updateExistingStorageSize(storageData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateExistingStorageSize(StorageData storageData) throws IOException, SerializationException {
        if (null != storageData) {
            StorageData storageData2 = storageData;
            synchronized (storageData2) {
                long newSize = this.getDiskSizeForStorage(storageData);
                if (newSize != storageData.getDiskSize()) {
                    storageData.setDiskSize(newSize);
                    this.writeStorageDataToDisk(storageData);
                }
            }
        }
    }

    public void unpackUploadedStorage(final IStorageData packedStorageData) throws IOException, BusinessException {
        long storageBytesLeft = this.getBytesHardDriveOccupancyLeft();
        if (packedStorageData.getDiskSize() > storageBytesLeft) {
            throw new BusinessException("Unpack the uploaded storage " + packedStorageData + ".", (IErrorCode)StorageErrorCodeEnum.LOW_DISK_SPACE);
        }
        Path uploadPath = Paths.get(this.getStorageUploadsFolder(), new String[0]);
        if (Files.notExists(uploadPath, new LinkOption[0])) {
            throw new IOException("Can not perform storage unpacking. The main upload path " + uploadPath.toString() + " does not exist.");
        }
        Files.walkFileTree(uploadPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                try {
                    if (!file.toString().endsWith(StorageFileType.ZIP_STORAGE_FILE.getExtension())) {
                        return FileVisitResult.CONTINUE;
                    }
                    IStorageData storageData = CmrStorageManager.this.getStorageDataFromZip(file);
                    if (!Objects.equals(packedStorageData, storageData)) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (null != storageData) {
                        StorageData importedStorageData = new StorageData(storageData);
                        if (CmrStorageManager.this.existingStoragesSet.add(importedStorageData)) {
                            CmrStorageManager.this.printStorageCmrVersionWarn(storageData);
                            CmrStorageManager.this.unzipStorageData(file, CmrStorageManager.this.getStoragePath((IStorageData)importedStorageData));
                            Path localInformation = CmrStorageManager.this.getStoragePath((IStorageData)importedStorageData).resolve(importedStorageData.getId() + StorageFileType.LOCAL_STORAGE_FILE.getExtension());
                            Files.deleteIfExists(localInformation);
                            CmrStorageManager.this.writeStorageDataToDisk(importedStorageData);
                        } else {
                            CmrStorageManager.this.log.info("Uploaded storage file " + file.toString() + " contains the storage that is already available on the CMR. File will be deleted.");
                        }
                    }
                    Files.deleteIfExists(file);
                }
                catch (Exception e) {
                    CmrStorageManager.this.log.warn("Uploaded storage file " + file.toString() + " is not of correct type and can not be extracted. File will be deleted.", (Throwable)e);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createStorageFromUploadedDir(final IStorageData localStorageData) throws IOException, BusinessException, SerializationException {
        long storageBytesLeft = this.getBytesHardDriveOccupancyLeft();
        if (localStorageData.getDiskSize() > storageBytesLeft) {
            throw new BusinessException("Create the uploaded storage " + localStorageData + ".", (IErrorCode)StorageErrorCodeEnum.LOW_DISK_SPACE);
        }
        Path uploadPath = Paths.get(this.getStorageUploadsFolder(), new String[0]);
        if (Files.notExists(uploadPath, new LinkOption[0])) {
            throw new IOException("Can not perform storage unpacking. The main upload path " + uploadPath.toString() + " does not exist.");
        }
        MutableObject storageUploadPath = new MutableObject();
        MutableObject uploadedStorageData = new MutableObject();
        SerializationManager serializer = this.getSerializationManagerProvider().createSerializer();
        Files.walkFileTree(uploadPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>((ISerializer)serializer, uploadedStorageData, storageUploadPath){
            final /* synthetic */ ISerializer val$serializer;
            final /* synthetic */ MutableObject val$uploadedStorageData;
            final /* synthetic */ MutableObject val$storageUploadPath;
            {
                this.val$serializer = iSerializer;
                this.val$uploadedStorageData = mutableObject;
                this.val$storageUploadPath = mutableObject2;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (!file.toString().endsWith(localStorageData.getId() + StorageFileType.LOCAL_STORAGE_FILE.getExtension())) {
                    return FileVisitResult.CONTINUE;
                }
                InputStream inputStream = null;
                Input input = null;
                try {
                    inputStream = Files.newInputStream(file, StandardOpenOption.READ);
                    input = new Input(inputStream);
                    Object deserialized = this.val$serializer.deserialize(input);
                    if (Objects.equals(deserialized, localStorageData)) {
                        this.val$uploadedStorageData.setValue((Object)new StorageData(localStorageData));
                        this.val$storageUploadPath.setValue((Object)file.toAbsolutePath().getParent());
                        FileVisitResult fileVisitResult = FileVisitResult.TERMINATE;
                        return fileVisitResult;
                    }
                }
                catch (SerializationException e) {
                    CmrStorageManager.this.log.warn("Error de-serializing local storage file.", (Throwable)e);
                }
                finally {
                    if (null != input) {
                        input.close();
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
        Path parentDir = (Path)storageUploadPath.getValue();
        StorageData storageData = (StorageData)uploadedStorageData.getValue();
        if (null == storageData || null == parentDir) return;
        Path storageDir = this.getStoragePath((IStorageData)storageData);
        if (this.existingStoragesSet.add(storageData)) {
            if (!Files.notExists(storageDir, new LinkOption[0])) throw new IOException("Directory to place uploaded storage already exists.");
            this.printStorageCmrVersionWarn((IStorageData)storageData);
            Files.walkFileTree(parentDir, (FileVisitor<? super Path>)new CopyMoveFileVisitor(parentDir, storageDir, true));
            Path localInformation = this.getStoragePath((IStorageData)storageData).resolve(storageData.getId() + StorageFileType.LOCAL_STORAGE_FILE.getExtension());
            Files.deleteIfExists(localInformation);
            this.writeStorageDataToDisk(storageData);
            return;
        } else {
            this.log.info("Uploaded storage on path " + parentDir.toString() + " contains the storage that is already available on the CMR. Dir will be deleted.");
            Files.walkFileTree(parentDir, (FileVisitor<? super Path>)new DeleteFileVisitor());
        }
    }

    public String getCachedStorageDataFileLocation(StorageData storageData, int hash) {
        Path path = super.getCachedDataPath((IStorageData)storageData, hash);
        if (Files.exists(path, new LinkOption[0])) {
            return this.getPathAsHttp(path);
        }
        return null;
    }

    private String getPathAsHttp(Path path) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Path pathPart : this.getDefaultStorageDirPath().relativize(path)) {
            stringBuilder.append('/');
            stringBuilder.append(pathPart.toString());
        }
        return stringBuilder.toString();
    }

    private long getDiskSizeForStorage(StorageData storageData) {
        Path storageDir = this.getStoragePath((IStorageData)storageData);
        try {
            final MutableLong size = new MutableLong(0L);
            Files.walkFileTree(storageDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    size.add(attrs.size());
                    return super.visitFile(file, attrs);
                }
            });
            return size.longValue();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    private StorageData getLocalStorageDataObject(StorageData storageData) throws BusinessException {
        for (StorageData existing : this.existingStoragesSet) {
            if (!existing.getId().equals(storageData.getId())) continue;
            return existing;
        }
        throw new BusinessException("Find storage " + storageData + ".", (IErrorCode)StorageErrorCodeEnum.STORAGE_DOES_NOT_EXIST);
    }

    private void loadAllExistingStorages() {
        this.existingStoragesSet = Collections.newSetFromMap(new ConcurrentHashMap());
        Path defaultDirectory = Paths.get(this.getStorageDefaultFolder(), new String[0]);
        if (!Files.isDirectory(defaultDirectory, new LinkOption[0])) {
            return;
        }
        SerializationManager serializer = this.getSerializationManagerProvider().createSerializer();
        try {
            Files.walkFileTree(defaultDirectory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>((ISerializer)serializer){
                final /* synthetic */ ISerializer val$serializer;
                {
                    this.val$serializer = iSerializer;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (file.toString().endsWith(StorageFileType.STORAGE_FILE.getExtension())) {
                        InputStream inputStream = null;
                        Input input = null;
                        try {
                            StorageData storageData;
                            inputStream = Files.newInputStream(file, StandardOpenOption.READ);
                            input = new Input(inputStream);
                            Object deserialized = this.val$serializer.deserialize(input);
                            if (deserialized instanceof StorageData && (storageData = (StorageData)deserialized).getState() == StorageData.StorageState.CLOSED) {
                                CmrStorageManager.this.printStorageCmrVersionWarn((IStorageData)storageData);
                                CmrStorageManager.this.existingStoragesSet.add(storageData);
                            }
                        }
                        catch (IOException e) {
                            CmrStorageManager.this.log.error("Error reading existing storage data file. File path: " + file.toString() + ".", (Throwable)e);
                        }
                        catch (SerializationException e) {
                            CmrStorageManager.this.log.error("Error deserializing existing storage binary data in file:" + file.toString() + ".", (Throwable)e);
                        }
                        finally {
                            if (null != input) {
                                input.close();
                            }
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            this.log.error("Error exploring default storage directory. Directory path: " + defaultDirectory.toString() + ".", (Throwable)e);
        }
    }

    private void clearUploadFolder() {
        final Path uploadPath = Paths.get(this.getStorageUploadsFolder(), new String[0]);
        if (Files.notExists(uploadPath, new LinkOption[0])) {
            return;
        }
        try {
            Files.walkFileTree(uploadPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (dir.equals(uploadPath)) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (null == exc) {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                    throw exc;
                }
            });
        }
        catch (IOException e) {
            this.log.warn("Could not delete the storage upload folder on the start-up.", (Throwable)e);
        }
    }

    private String getRandomUUIDString() {
        return UUID.randomUUID().toString();
    }

    private void printStorageCmrVersionWarn(IStorageData storageData) {
        if (null == storageData.getCmrVersion()) {
            this.log.warn("The storage " + storageData + " does not define the CMR version. The storage might be unstable on the CMR version " + this.cmrVersion + ".");
        } else if (!Objects.equals(storageData.getCmrVersion(), this.cmrVersion)) {
            this.log.warn("The storage " + storageData + " has different CMR version (" + storageData.getCmrVersion() + ") than the current CMR version(" + this.cmrVersion + "). The storage might be unstable.");
        }
    }

    @PostConstruct
    public void postConstruct() throws Exception {
        this.cmrVersion = this.versionService.getVersionAsString();
        this.loadAllExistingStorages();
        this.updatedStorageSpaceLeft();
        this.clearUploadFolder();
    }

    public void onApplicationEvent(ContextClosedEvent event) {
        this.closeAllStorages();
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this);
        toStringBuilder.append("existingStoragesSet", this.existingStoragesSet);
        toStringBuilder.append("openedStoragesMap", this.openedStoragesMap);
        toStringBuilder.append("storageRecorder", (Object)this.storageRecorder);
        return toStringBuilder.toString();
    }
}

