/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.service;

import info.novatec.inspectit.cmr.dao.SqlDataDao;
import info.novatec.inspectit.cmr.service.ISqlDataAccessService;
import info.novatec.inspectit.cmr.spring.aop.MethodLog;
import info.novatec.inspectit.communication.data.SqlStatementData;
import info.novatec.inspectit.spring.logger.Log;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SqlDataAccessService
implements ISqlDataAccessService {
    @Log
    Logger log;
    @Autowired
    private SqlDataDao sqlDataDao;

    @MethodLog
    public List<SqlStatementData> getAggregatedSqlStatements(SqlStatementData sqlStatementData) {
        List<SqlStatementData> result = this.sqlDataDao.getAggregatedSqlStatements(sqlStatementData);
        return result;
    }

    @MethodLog
    public List<SqlStatementData> getAggregatedSqlStatements(SqlStatementData sqlStatementData, Date fromDate, Date toDate) {
        List<SqlStatementData> result = this.sqlDataDao.getAggregatedSqlStatements(sqlStatementData, fromDate, toDate);
        return result;
    }

    @MethodLog
    public List<SqlStatementData> getParameterAggregatedSqlStatements(SqlStatementData sqlStatementData) {
        List<SqlStatementData> result = this.sqlDataDao.getParameterAggregatedSqlStatements(sqlStatementData);
        return result;
    }

    @MethodLog
    public List<SqlStatementData> getParameterAggregatedSqlStatements(SqlStatementData sqlStatementData, Date fromDate, Date toDate) {
        List<SqlStatementData> result = this.sqlDataDao.getParameterAggregatedSqlStatements(sqlStatementData, fromDate, toDate);
        return result;
    }

    @PostConstruct
    public void postConstruct() throws Exception {
        if (this.log.isInfoEnabled()) {
            this.log.info("|-SQL Data Access Service active...");
        }
    }
}

