/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.service;

import info.novatec.inspectit.cmr.service.IKeepAliveService;
import info.novatec.inspectit.cmr.util.AgentStatusDataProvider;
import info.novatec.inspectit.spring.logger.Log;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class KeepAliveService
implements IKeepAliveService {
    @Log
    Logger log;
    @Autowired
    AgentStatusDataProvider agentStatusDataProvider;

    public void sendKeepAlive(long platformId) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received keep-alive signal from platform " + platformId);
        }
        this.agentStatusDataProvider.handleKeepAliveSignal(platformId);
    }

    @PostConstruct
    public void postConstruct() {
        if (this.log.isInfoEnabled()) {
            this.log.info("|-Keep Alive Service active...");
        }
    }
}

