/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.processor.impl;

import info.novatec.inspectit.cmr.dao.impl.TimerDataAggregator;
import info.novatec.inspectit.cmr.processor.AbstractCmrDataProcessor;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.data.HttpInfo;
import info.novatec.inspectit.communication.data.HttpTimerData;
import info.novatec.inspectit.communication.data.TimerData;
import info.novatec.inspectit.spring.logger.Log;
import info.novatec.inspectit.storage.serializer.SerializationException;
import info.novatec.inspectit.storage.serializer.impl.SerializationManager;
import info.novatec.inspectit.storage.serializer.provider.SerializationManagerProvider;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class TimerDataChartingCmrProcessor
extends AbstractCmrDataProcessor {
    @Log
    Logger log;
    @Autowired
    TimerDataAggregator timerDataAggregator;
    @Autowired
    private SerializationManagerProvider serializationManagerProvider;
    SerializationManager serializationManager;

    @Override
    protected void processData(DefaultData defaultData, EntityManager entityManager) {
        if (defaultData instanceof HttpTimerData) {
            try {
                HttpTimerData original = (HttpTimerData)defaultData;
                HttpInfo httpInfo = this.getHttpInfo(original, entityManager);
                HttpTimerData clone = this.getClone(original);
                clone.setHttpInfo(httpInfo);
                entityManager.persist((Object)clone);
            }
            catch (SerializationException e) {
                this.log.warn("TimerDataChartingCmrProcessor failed to clone the given HttpTimerData", (Throwable)e);
            }
        } else {
            this.timerDataAggregator.processTimerData((TimerData)defaultData);
        }
    }

    @Override
    public boolean canBeProcessed(DefaultData defaultData) {
        return defaultData instanceof TimerData && ((TimerData)defaultData).isCharting();
    }

    private synchronized HttpTimerData getClone(HttpTimerData original) throws SerializationException {
        HttpTimerData httpTimerData = (HttpTimerData)this.serializationManager.copy((Object)original);
        httpTimerData.setId(0L);
        return httpTimerData;
    }

    private HttpInfo getHttpInfo(HttpTimerData httpTimerData, EntityManager entityManager) {
        HttpInfo httpInfo = httpTimerData.getHttpInfo();
        String uri = httpInfo.isUriDefined() ? httpInfo.getUri() : null;
        String tag = httpInfo.hasInspectItTaggingHeader() ? httpInfo.getInspectItTaggingHeaderValue() : null;
        String requestMethod = httpInfo.getRequestMethod();
        CriteriaBuilder builder = entityManager.getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(HttpInfo.class);
        Root root = criteria.from(HttpInfo.class);
        Predicate requestMethodPredicate = builder.equal((Expression)root.get("requestMethod"), (Object)requestMethod);
        Predicate uriPredicate = null != uri ? builder.equal((Expression)root.get("uri"), (Object)uri) : builder.isNull((Expression)root.get("uri"));
        Predicate tagPredicate = null != tag ? builder.equal((Expression)root.get("inspectItTaggingHeaderValue"), (Object)tag) : builder.isNull((Expression)root.get("inspectItTaggingHeaderValue"));
        criteria.where(new Predicate[]{uriPredicate, tagPredicate, requestMethodPredicate});
        List httpInfoList = entityManager.createQuery(criteria).getResultList();
        if (CollectionUtils.isNotEmpty((Collection)httpInfoList)) {
            return (HttpInfo)httpInfoList.get(0);
        }
        return new HttpInfo(uri, requestMethod, tag);
    }

    @PostConstruct
    protected void init() {
        this.serializationManager = this.serializationManagerProvider.createSerializer();
    }
}

