/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.processor.impl;

import info.novatec.inspectit.cmr.processor.AbstractChainedCmrDataProcessor;
import info.novatec.inspectit.cmr.processor.AbstractCmrDataProcessor;
import info.novatec.inspectit.cmr.processor.impl.ExceptionMessageCmrProcessor;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.ExceptionEvent;
import info.novatec.inspectit.communication.data.ExceptionSensorData;
import info.novatec.inspectit.communication.data.InvocationSequenceData;
import info.novatec.inspectit.communication.data.InvocationSequenceDataHelper;
import info.novatec.inspectit.communication.data.SqlStatementData;
import info.novatec.inspectit.communication.data.TimerData;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class InvocationModifierCmrProcessor
extends AbstractChainedCmrDataProcessor {
    @Autowired
    ExceptionMessageCmrProcessor exceptionMessageCmrProcessor;

    public InvocationModifierCmrProcessor(List<AbstractCmrDataProcessor> dataProcessors) {
        super(dataProcessors);
    }

    @Override
    protected void processData(DefaultData defaultData, EntityManager entityManager) {
        InvocationSequenceData invocation = (InvocationSequenceData)defaultData;
        this.extractDataFromInvocation(entityManager, invocation, invocation);
    }

    @Override
    protected boolean shouldBePassedToChainedProcessors(DefaultData defaultData) {
        return false;
    }

    @Override
    public boolean canBeProcessed(DefaultData defaultData) {
        return defaultData instanceof InvocationSequenceData;
    }

    private void extractDataFromInvocation(EntityManager entityManager, InvocationSequenceData invData, InvocationSequenceData topInvocationParent) {
        double exclusiveDurationDelta = 0.0;
        for (InvocationSequenceData child : invData.getNestedSequences()) {
            this.passToChainedProcessors((DefaultData)child, entityManager);
            exclusiveDurationDelta = null != child.getTimerData() ? (exclusiveDurationDelta += child.getTimerData().getDuration()) : (null != child.getSqlStatementData() ? (exclusiveDurationDelta += child.getSqlStatementData().getDuration()) : (exclusiveDurationDelta += InvocationSequenceDataHelper.computeNestedDuration((InvocationSequenceData)child)));
            this.extractDataFromInvocation(entityManager, child, topInvocationParent);
        }
        this.processSqlStatementData(entityManager, invData, topInvocationParent);
        this.processTimerData(entityManager, invData, topInvocationParent, exclusiveDurationDelta);
        this.processExceptionSensorData(entityManager, invData, topInvocationParent);
    }

    private void processSqlStatementData(EntityManager entityManager, InvocationSequenceData invData, InvocationSequenceData topInvocationParent) {
        SqlStatementData sqlStatementData = invData.getSqlStatementData();
        if (null != sqlStatementData) {
            topInvocationParent.setNestedSqlStatements(Boolean.TRUE);
            sqlStatementData.addInvocationParentId(Long.valueOf(topInvocationParent.getId()));
            this.passToChainedProcessors((DefaultData)sqlStatementData, entityManager);
        }
    }

    private void processTimerData(EntityManager entityManager, InvocationSequenceData invData, InvocationSequenceData topInvocationParent, double exclusiveDurationDelta) {
        TimerData timerData = invData.getTimerData();
        if (null != timerData) {
            double exclusiveTime = invData.getTimerData().getDuration() - exclusiveDurationDelta;
            timerData.setExclusiveCount(1L);
            timerData.setExclusiveDuration(exclusiveTime);
            timerData.calculateExclusiveMax(exclusiveTime);
            timerData.calculateExclusiveMin(exclusiveTime);
            timerData.addInvocationParentId(Long.valueOf(topInvocationParent.getId()));
            this.passToChainedProcessors((DefaultData)invData.getTimerData(), entityManager);
        }
    }

    private void processExceptionSensorData(EntityManager entityManager, InvocationSequenceData invData, InvocationSequenceData topInvocationParent) {
        if (CollectionUtils.isNotEmpty((Collection)invData.getExceptionSensorDataObjects())) {
            for (ExceptionSensorData exceptionData : invData.getExceptionSensorDataObjects()) {
                if (exceptionData.getExceptionEvent() != ExceptionEvent.CREATED) continue;
                topInvocationParent.setNestedExceptions(Boolean.TRUE);
                this.exceptionMessageCmrProcessor.process((DefaultData)exceptionData, entityManager);
                exceptionData.addInvocationParentId(Long.valueOf(topInvocationParent.getId()));
                this.passToChainedProcessors((DefaultData)exceptionData, entityManager);
            }
        }
    }
}

