/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.jetty;

import info.novatec.inspectit.spring.logger.Log;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.servlet.Context;
import org.slf4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.support.GenericWebApplicationContext;

public class JettyWebApplicationContextInitializer
implements ApplicationContextAware {
    @Log
    Logger log;
    private String contextAttribute;
    private Context jettyContext;
    private ApplicationContext ctx;

    public void setContextAttribute(String contextAttribute) {
        this.contextAttribute = contextAttribute;
    }

    public void setJettyContext(Context jettyContext) {
        this.jettyContext = jettyContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.ctx = applicationContext;
    }

    @PostConstruct
    public void postConstruct() throws Exception {
        ContextHandler.SContext servletContext = this.jettyContext.getServletContext();
        GenericWebApplicationContext webCtx = new GenericWebApplicationContext();
        webCtx.setServletContext((ServletContext)servletContext);
        webCtx.setParent(this.ctx);
        webCtx.refresh();
        servletContext.setAttribute(this.contextAttribute, (Object)webCtx);
        this.jettyContext.start();
        if (this.log.isInfoEnabled()) {
            this.log.info("| Jetty Web Application Context started!");
        }
    }
}

