/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.dao.impl;

import info.novatec.inspectit.cmr.dao.impl.TimerDataAggregator;
import info.novatec.inspectit.communication.data.TimerData;

class TimerDataAggregatorCacheCleaner
extends Thread {
    private final TimerDataAggregator timerDataAggregator;
    private volatile TimerData mostRecentlyAdded;
    private TimerData lastChecked;

    public TimerDataAggregatorCacheCleaner(TimerDataAggregator timerDataAggregator) {
        this.timerDataAggregator = timerDataAggregator;
        this.setName("timer-data-aggregator-cache-cleaner-thread");
        this.setDaemon(true);
        this.setPriority(1);
    }

    @Override
    public void run() {
        while (true) {
            TimerData timerData;
            if ((timerData = this.mostRecentlyAdded) != null) {
                if (timerData == this.lastChecked) {
                    this.timerDataAggregator.removeAndPersistAll();
                }
                this.lastChecked = timerData;
            }
            this.timerDataAggregator.saveAllInPersistList();
            try {
                Thread.sleep(this.timerDataAggregator.cacheCleanSleepingPeriod);
                continue;
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                continue;
            }
            break;
        }
    }

    public void setMostRecentlyAdded(TimerData mostRecentlyAdded) {
        this.mostRecentlyAdded = mostRecentlyAdded;
    }
}

