/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.dao.impl;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

public abstract class AbstractJpaDao<T> {
    private Class<T> entityType;
    @PersistenceContext
    EntityManager entityManager;

    public AbstractJpaDao(Class<T> entityType) {
        this.entityType = entityType;
    }

    public T load(Long id) {
        return (T)this.entityManager.find(this.entityType, (Object)id);
    }

    public void create(T object) {
        this.getEntityManager().persist(object);
    }

    public T update(T object) {
        return (T)this.getEntityManager().merge(object);
    }

    public void delete(T object) {
        this.entityManager.remove(object);
    }

    public void deleteAll(List<T> objects) {
        for (T object : objects) {
            this.delete(object);
        }
    }

    protected EntityManager getEntityManager() {
        return this.entityManager;
    }
}

