/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.ci;

import info.novatec.inspectit.ci.AgentMapping;
import info.novatec.inspectit.ci.AgentMappings;
import info.novatec.inspectit.ci.Environment;
import info.novatec.inspectit.ci.Profile;
import info.novatec.inspectit.cmr.ci.ConfigurationInterfacePathResolver;
import info.novatec.inspectit.cmr.jaxb.JAXBTransformator;
import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.exception.IErrorCode;
import info.novatec.inspectit.exception.enumeration.ConfigurationInterfaceErrorCodeEnum;
import info.novatec.inspectit.spring.logger.Log;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.PostConstruct;
import javax.xml.bind.JAXBException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.xml.sax.SAXException;

@Component
public class ConfigurationInterfaceManager {
    @Log
    Logger log;
    @Autowired
    ConfigurationInterfacePathResolver pathResolver;
    private JAXBTransformator transformator = new JAXBTransformator();
    private ConcurrentHashMap<String, Profile> existingProfiles;
    private ConcurrentHashMap<String, Environment> existingEnvironments;
    private AtomicReference<AgentMappings> agentMappingsReference = new AtomicReference();

    public List<Profile> getAllProfiles() {
        return new ArrayList<Profile>(this.existingProfiles.values());
    }

    public Profile getProfile(String id) throws BusinessException {
        Profile profile = this.existingProfiles.get(id);
        if (null == profile) {
            throw new BusinessException("Load profile with the id=" + id + ".", (IErrorCode)ConfigurationInterfaceErrorCodeEnum.PROFILE_DOES_NOT_EXIST);
        }
        return profile;
    }

    public Profile createProfile(Profile profile) throws BusinessException, JAXBException, IOException {
        profile.setId(this.getRandomUUIDString());
        profile.setCreatedDate(new Date());
        this.existingProfiles.put(profile.getId(), profile);
        this.saveProfile(profile);
        return profile;
    }

    public synchronized Profile updateProfile(Profile profile) throws BusinessException, JAXBException, IOException {
        if (profile.isCommonProfile()) {
            throw new BusinessException("Update the profile '" + profile.getName() + ".", (IErrorCode)ConfigurationInterfaceErrorCodeEnum.COMMON_PROFILE_CAN_NOT_BE_ALTERED);
        }
        return this.updateProfileInternal(profile);
    }

    public void deleteProfile(Profile profile) throws BusinessException, IOException {
        if (profile.isCommonProfile()) {
            throw new BusinessException("Delete the profile '" + profile.getName() + ".", (IErrorCode)ConfigurationInterfaceErrorCodeEnum.COMMON_PROFILE_CAN_NOT_BE_ALTERED);
        }
        String id = profile.getId();
        Profile local = this.existingProfiles.remove(id);
        if (null != local) {
            Files.deleteIfExists(this.pathResolver.getProfileFilePath(local));
            for (Environment environment : this.existingEnvironments.values()) {
                if (!this.checkProfiles(environment)) continue;
                try {
                    this.updateEnvironment(environment, false);
                }
                catch (Exception e) {
                    this.log.error("Update of the environment on the profile deletion failed.", (Throwable)e);
                }
            }
        }
    }

    public Collection<Environment> getAllEnvironments() {
        return new ArrayList<Environment>(this.existingEnvironments.values());
    }

    public Environment getEnvironment(String id) throws BusinessException {
        Environment environment = this.existingEnvironments.get(id);
        if (null == environment) {
            throw new BusinessException("Load environemnt with the id=" + id + ".", (IErrorCode)ConfigurationInterfaceErrorCodeEnum.ENVIRONMENT_DOES_NOT_EXIST);
        }
        return environment;
    }

    public Environment createEnvironment(Environment environment) throws JAXBException, IOException {
        environment.setId(this.getRandomUUIDString());
        this.existingEnvironments.put(environment.getId(), environment);
        HashSet<String> profileIds = new HashSet<String>();
        for (Profile profile : this.existingProfiles.values()) {
            if (!profile.isDefaultProfile()) continue;
            profileIds.add(profile.getId());
        }
        environment.setProfileIds(profileIds);
        this.saveEnvironment(environment);
        return environment;
    }

    public synchronized Environment updateEnvironment(Environment environment, boolean checkProfiles) throws BusinessException, JAXBException, IOException {
        if (checkProfiles) {
            this.checkProfiles(environment);
        }
        String id = environment.getId();
        environment.setRevision(environment.getRevision() + 1);
        Environment local = this.existingEnvironments.replace(id, environment);
        if (null == local) {
            this.existingEnvironments.remove(id);
            throw new BusinessException("Update of the environment '" + environment.getName() + ".", (IErrorCode)ConfigurationInterfaceErrorCodeEnum.ENVIRONMENT_DOES_NOT_EXIST);
        }
        if (local != environment && local.getRevision() + 1 != environment.getRevision()) {
            this.existingEnvironments.replace(id, local);
            BusinessException e = new BusinessException("Update of the environment '" + environment.getName() + ".", (IErrorCode)ConfigurationInterfaceErrorCodeEnum.REVISION_CHECK_FAILED);
            environment.setRevision(environment.getRevision() - 1);
            throw e;
        }
        this.saveEnvironment(environment);
        if (!Objects.equals(environment.getName(), local.getName())) {
            Files.deleteIfExists(this.pathResolver.getEnvironmentFilePath(local));
        }
        return environment;
    }

    public void deleteEnvironment(Environment environment) throws IOException {
        String id = environment.getId();
        Environment local = this.existingEnvironments.remove(id);
        if (null != local) {
            Files.deleteIfExists(this.pathResolver.getEnvironmentFilePath(local));
            AgentMappings agentMappings = this.agentMappingsReference.get();
            if (this.checkEnvironments(agentMappings)) {
                try {
                    this.saveAgentMappings(agentMappings, false);
                }
                catch (Exception e) {
                    this.log.error("Update of the agent mappings on the environment deletion failed.", (Throwable)e);
                }
            }
        }
    }

    public AgentMappings getAgentMappings() {
        return this.agentMappingsReference.get();
    }

    public AgentMappings saveAgentMappings(AgentMappings agentMappings, boolean checkEnvironments) throws BusinessException, JAXBException, IOException {
        AgentMappings current;
        if (checkEnvironments) {
            this.checkEnvironments(agentMappings);
        }
        do {
            if ((current = this.agentMappingsReference.get()).getRevision() == agentMappings.getRevision()) continue;
            throw new BusinessException("Update of the agent mappings.", (IErrorCode)ConfigurationInterfaceErrorCodeEnum.REVISION_CHECK_FAILED);
        } while (!this.agentMappingsReference.compareAndSet(current, agentMappings));
        agentMappings.setRevision(agentMappings.getRevision() + 1);
        this.saveAgentMapping(agentMappings);
        return agentMappings;
    }

    private Profile updateProfileInternal(Profile profile) throws BusinessException, JAXBException, IOException {
        String id = profile.getId();
        profile.setRevision(profile.getRevision() + 1);
        Profile local = this.existingProfiles.replace(id, profile);
        if (null == local) {
            this.existingProfiles.remove(id);
            throw new BusinessException("Update of the profile '" + profile.getName() + ".", (IErrorCode)ConfigurationInterfaceErrorCodeEnum.PROFILE_DOES_NOT_EXIST);
        }
        if (local != profile && local.getRevision() + 1 != profile.getRevision()) {
            this.existingProfiles.replace(id, local);
            BusinessException e = new BusinessException("Update of the profile '" + profile.getName() + ".", (IErrorCode)ConfigurationInterfaceErrorCodeEnum.REVISION_CHECK_FAILED);
            profile.setRevision(profile.getRevision() - 1);
            throw e;
        }
        profile.setUpdatedDate(new Date());
        this.saveProfile(profile);
        if (!Objects.equals(profile.getName(), local.getName())) {
            Files.deleteIfExists(this.pathResolver.getProfileFilePath(local));
        }
        return profile;
    }

    private boolean checkProfiles(Environment environment) {
        boolean changed = false;
        if (CollectionUtils.isNotEmpty((Collection)environment.getProfileIds())) {
            Iterator it = environment.getProfileIds().iterator();
            while (it.hasNext()) {
                String profileId = (String)it.next();
                if (this.existingProfiles.containsKey(profileId)) continue;
                it.remove();
                changed = true;
            }
        }
        return changed;
    }

    private boolean checkEnvironments(AgentMappings agentMappings) {
        boolean changed = false;
        if (CollectionUtils.isNotEmpty((Collection)agentMappings.getMappings())) {
            Iterator it = agentMappings.getMappings().iterator();
            while (it.hasNext()) {
                AgentMapping agentMapping = (AgentMapping)it.next();
                if (this.existingEnvironments.containsKey(agentMapping.getEnvironmentId())) continue;
                it.remove();
                changed = true;
            }
        }
        return changed;
    }

    private void saveProfile(Profile profile) throws BusinessException, JAXBException, IOException {
        if (profile.isCommonProfile()) {
            throw new BusinessException("Save the profile '" + profile.getName() + " to disk.", (IErrorCode)ConfigurationInterfaceErrorCodeEnum.COMMON_PROFILE_CAN_NOT_BE_ALTERED);
        }
        this.transformator.marshall(this.pathResolver.getProfileFilePath(profile), profile, this.getRelativeToSchemaPath(this.pathResolver.getProfilesPath()).toString());
    }

    private void saveEnvironment(Environment environment) throws JAXBException, IOException {
        this.transformator.marshall(this.pathResolver.getEnvironmentFilePath(environment), environment, this.getRelativeToSchemaPath(this.pathResolver.getEnvironmentPath()).toString());
    }

    private void saveAgentMapping(AgentMappings agentMappings) throws JAXBException, IOException {
        this.transformator.marshall(this.pathResolver.getAgentMappingFilePath(), agentMappings, this.getRelativeToSchemaPath(this.pathResolver.getDefaultCiPath()).toString());
    }

    private Path getRelativeToSchemaPath(Path path) {
        return path.relativize(this.pathResolver.getSchemaPath());
    }

    @PostConstruct
    public void init() {
        this.loadExistingProfiles();
        this.loadExistingEnvironments();
        this.loadAgentMappings();
    }

    private void loadExistingProfiles() {
        this.log.info("|-Loading the existing Configuration interface profiles..");
        this.existingProfiles = new ConcurrentHashMap(16, 0.75f, 2);
        Path path = this.pathResolver.getProfilesPath();
        final Path schemaPath = this.pathResolver.getSchemaPath();
        if (Files.notExists(path, new LinkOption[0])) {
            this.log.info("Default configuration interface profiles path does not exists. No profile is loaded.");
            return;
        }
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (ConfigurationInterfaceManager.this.isXmlFile(file)) {
                        try {
                            Profile profile = ConfigurationInterfaceManager.this.transformator.unmarshall(file, schemaPath, Profile.class);
                            ConfigurationInterfaceManager.this.existingProfiles.put(profile.getId(), profile);
                        }
                        catch (JAXBException | SAXException e) {
                            ConfigurationInterfaceManager.this.log.error("Error reading existing Configuration interface profile file. File path: " + file.toString() + ".", e);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            this.log.error("Error exploring Configuration interface profiles directory. Directory path: " + path.toString() + ".", (Throwable)e);
        }
        if (MapUtils.isEmpty(this.existingProfiles)) {
            this.log.info("No profile exists in the default profiles path.");
        }
    }

    private void loadExistingEnvironments() {
        this.log.info("|-Loading the existing Configuration interface environments..");
        this.existingEnvironments = new ConcurrentHashMap(16, 0.75f, 2);
        Path path = this.pathResolver.getEnvironmentPath();
        final Path schemaPath = this.pathResolver.getSchemaPath();
        if (Files.notExists(path, new LinkOption[0])) {
            this.log.info("Default configuration interface environment path does not exists. No environment is loaded.");
            return;
        }
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (ConfigurationInterfaceManager.this.isXmlFile(file)) {
                        try {
                            Environment environment = ConfigurationInterfaceManager.this.transformator.unmarshall(file, schemaPath, Environment.class);
                            ConfigurationInterfaceManager.this.existingEnvironments.put(environment.getId(), environment);
                            if (ConfigurationInterfaceManager.this.checkProfiles(environment)) {
                                try {
                                    ConfigurationInterfaceManager.this.saveEnvironment(environment);
                                    ConfigurationInterfaceManager.this.log.info("Environment '" + environment.getName() + "' was auto-updated as it was referencing the non-existing profile(s).");
                                }
                                catch (IOException | JAXBException e) {
                                    ConfigurationInterfaceManager.this.log.error("Error updating existing Configuration interface environment file. File path: " + file.toString() + ".", e);
                                }
                            }
                        }
                        catch (JAXBException | SAXException e) {
                            ConfigurationInterfaceManager.this.log.error("Error reading existing Configuration interface environment file. File path: " + file.toString() + ".", e);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            this.log.error("Error exploring Configuration interface environments directory. Directory path: " + path.toString() + ".", (Throwable)e);
        }
        if (MapUtils.isEmpty(this.existingEnvironments)) {
            Environment environment = new Environment();
            environment.setName("Default Environment");
            environment.setDescription("Environment that contains the default inspectIT monitoring settings and all default profiles.");
            try {
                this.createEnvironment(environment);
            }
            catch (Exception e) {
                this.log.error("Error creating default Configuration interface environment on the CMR.", (Throwable)e);
            }
        }
    }

    private void loadAgentMappings() {
        AgentMappings agentMappings;
        this.log.info("|-Loading the existing Configuration interface agent mappings..");
        Path path = this.pathResolver.getAgentMappingFilePath();
        if (Files.notExists(path, new LinkOption[0])) {
            agentMappings = new AgentMappings(Collections.emptyList());
        } else {
            try {
                agentMappings = this.transformator.unmarshall(path, this.pathResolver.getSchemaPath(), AgentMappings.class);
            }
            catch (IOException | JAXBException | SAXException e) {
                agentMappings = new AgentMappings(Collections.emptyList());
                this.log.error("Error loading Configuration interface agent mappings file. File path: " + path.toString() + ".", e);
            }
        }
        this.agentMappingsReference.set(agentMappings);
        if (this.checkEnvironments(agentMappings)) {
            try {
                this.saveAgentMapping(agentMappings);
                this.log.info("Agent mappings configuration is auto-updated as it was referencing the non-existing environment(s).");
            }
            catch (IOException | JAXBException e) {
                this.log.error("Error save Configuration interface agent mappings file. File path: " + path.toString() + ".", e);
            }
        }
    }

    private boolean isXmlFile(Path path) {
        return !Files.isDirectory(path, new LinkOption[0]) && path.toString().endsWith(".xml");
    }

    private String getRandomUUIDString() {
        return String.valueOf(UUID.randomUUID().getLeastSignificantBits());
    }
}

