/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.cache.impl;

import info.novatec.inspectit.cmr.cache.IBuffer;
import info.novatec.inspectit.cmr.cache.IBufferElement;
import info.novatec.inspectit.cmr.cache.IObjectSizes;
import info.novatec.inspectit.cmr.cache.impl.AnalyzeBufferElementProcessor;
import info.novatec.inspectit.cmr.cache.impl.BufferProperties;
import info.novatec.inspectit.cmr.cache.impl.IndexBufferElementProcessor;
import info.novatec.inspectit.cmr.property.spring.PropertyUpdate;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.indexing.buffer.IBufferTreeComponent;
import info.novatec.inspectit.spring.logger.Log;
import java.text.NumberFormat;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AtomicBuffer<E extends DefaultData>
implements IBuffer<E> {
    @Log
    Logger log;
    @Autowired
    BufferProperties bufferProperties;
    @Autowired
    IObjectSizes objectSizes;
    @Autowired
    IBufferTreeComponent<E> indexingTree;
    private AtomicReference<IBufferElement<E>> first;
    private AtomicLong maxSize;
    private AtomicInteger evictionOccupancyPercentage;
    private AtomicLong currentSize = new AtomicLong();
    private AtomicLong elementsAdded = new AtomicLong();
    AtomicReference<IBufferElement<E>> last;
    private AtomicLong elementsEvicted = new AtomicLong();
    AtomicLong elementsIndexed = new AtomicLong();
    AtomicLong elementsAnalyzed = new AtomicLong();
    AtomicReference<IBufferElement<E>> lastAnalyzed;
    private ReentrantLock evictLock = new ReentrantLock();
    private Condition nothingToEvict = this.evictLock.newCondition();
    private ReentrantLock analyzeLock = new ReentrantLock();
    private Condition nothingToAnalyze = this.analyzeLock.newCondition();
    private ReentrantLock indexingLock = new ReentrantLock();
    private Condition nothingToIndex = this.indexingLock.newCondition();
    private AtomicReference<IBufferElement<E>> lastIndexed;
    AtomicLong indexingTreeSize = new AtomicLong();
    ExecutorService indexingTreeCleaningExecutorService;
    AtomicLong dataAddedInBytes = new AtomicLong();
    AtomicLong dataRemovedInBytes = new AtomicLong();
    EmptyBufferElement emptyBufferElement = new EmptyBufferElement();
    volatile long flagsSetOnBytes;
    Lock clearReadLock;
    private Lock clearWriteLock;
    private AnalyzeBufferElementProcessor<E> analyzeProcessor;
    private IndexBufferElementProcessor<E> indexProcessor;

    public AtomicBuffer() {
        ReentrantReadWriteLock readWriteCleanLock = new ReentrantReadWriteLock();
        this.clearReadLock = readWriteCleanLock.readLock();
        this.clearWriteLock = readWriteCleanLock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(IBufferElement<E> element) {
        IBufferElement<E> currentlyFirst;
        boolean informAnalyzing = false;
        boolean informIndexing = false;
        element.setNextElement(this.emptyBufferElement);
        while (!this.first.compareAndSet(currentlyFirst = this.first.get(), element)) {
        }
        this.elementsAdded.incrementAndGet();
        if (!this.emptyBufferElement.equals(currentlyFirst)) {
            currentlyFirst.setNextElement(element);
            informAnalyzing = currentlyFirst == this.lastAnalyzed.get();
            informIndexing = currentlyFirst == this.lastIndexed.get();
        } else {
            this.last.set(element);
            informAnalyzing = true;
            informIndexing = true;
        }
        if (informAnalyzing) {
            this.analyzeLock.lock();
            try {
                this.nothingToAnalyze.signal();
            }
            finally {
                this.analyzeLock.unlock();
            }
        }
        if (informIndexing) {
            this.indexingLock.lock();
            try {
                this.nothingToIndex.signal();
            }
            finally {
                this.indexingLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evict() throws InterruptedException {
        while (!this.shouldEvict()) {
            this.evictLock.lock();
            try {
                if (this.shouldEvict()) continue;
                this.nothingToEvict.await();
            }
            finally {
                this.evictLock.unlock();
            }
        }
        while (true) {
            this.clearReadLock.lock();
            try {
                IBufferElement<E> currentLastElement = this.last.get();
                if (this.emptyBufferElement.equals(currentLastElement)) break;
                IBufferElement<E> newLastElement = currentLastElement;
                long evictionFragmentMaxSize = (long)((float)this.getMaxSize() * this.bufferProperties.getEvictionFragmentSizePercentage());
                long fragmentSize = 0L;
                int elementsInFragment = 0;
                while (fragmentSize < evictionFragmentMaxSize) {
                    fragmentSize += newLastElement.getBufferElementSize();
                    newLastElement.setBufferElementState(IBufferElement.BufferElementState.EVICTED);
                    ++elementsInFragment;
                    if (!this.emptyBufferElement.equals(newLastElement = newLastElement.getNextElement())) continue;
                }
                if (!this.last.compareAndSet(currentLastElement, newLastElement)) continue;
                this.substractFromCurrentSize(fragmentSize);
                this.elementsEvicted.addAndGet(elementsInFragment);
                if (this.emptyBufferElement != this.last.get()) break;
                this.first.set(this.emptyBufferElement);
            }
            finally {
                this.clearReadLock.unlock();
                continue;
            }
            break;
        }
    }

    @Override
    public void analyzeNext() throws InterruptedException {
        this.analyzeProcessor.process();
    }

    @Override
    public void indexNext() throws InterruptedException {
        this.indexProcessor.process();
    }

    @Override
    public long getMaxSize() {
        return this.maxSize.get();
    }

    @Override
    public void setMaxSize(long maxSize) {
        this.maxSize.set(maxSize);
        this.notifyEvictionIfNeeded();
    }

    @Override
    public long getCurrentSize() {
        return this.currentSize.get();
    }

    public void setCurrentSize(long currentSize) {
        this.currentSize.set(currentSize);
        this.notifyEvictionIfNeeded();
    }

    void addToCurrentSize(long size, boolean areObjects) {
        this.currentSize.addAndGet(size);
        this.notifyEvictionIfNeeded();
        if (areObjects) {
            this.dataAddedInBytes.addAndGet(size);
        }
    }

    private void substractFromCurrentSize(long size) {
        this.currentSize.addAndGet(-size);
        this.dataRemovedInBytes.addAndGet(size);
    }

    @Override
    public float getEvictionOccupancyPercentage() {
        return Float.intBitsToFloat(this.evictionOccupancyPercentage.get());
    }

    @Override
    public void setEvictionOccupancyPercentage(float evictionOccupancyPercentage) {
        this.evictionOccupancyPercentage.set(Float.floatToIntBits(evictionOccupancyPercentage));
        this.notifyEvictionIfNeeded();
    }

    @Override
    public float getOccupancyPercentage() {
        return (float)this.currentSize.get() / (float)this.maxSize.get();
    }

    public boolean shouldEvict() {
        return this.getOccupancyPercentage() > Float.intBitsToFloat(this.evictionOccupancyPercentage.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAll() {
        this.clearWriteLock.lock();
        try {
            this.last.set(this.emptyBufferElement);
            this.lastAnalyzed.set(this.emptyBufferElement);
            this.lastIndexed.set(this.emptyBufferElement);
            this.setCurrentSize(0L);
            this.elementsAdded.set(0L);
            this.elementsAnalyzed.set(0L);
            this.elementsIndexed.set(0L);
            this.elementsEvicted.set(0L);
            this.indexingTree.clearAll();
            this.indexingTreeSize.set(0L);
            this.dataAddedInBytes.set(0L);
            this.dataRemovedInBytes.set(0L);
            this.first.set(this.emptyBufferElement);
        }
        finally {
            this.clearWriteLock.unlock();
        }
    }

    public long getInsertedElemenets() {
        return this.elementsAdded.get();
    }

    public long getEvictedElemenets() {
        return this.elementsEvicted.get();
    }

    public long getIndexedElements() {
        return this.elementsIndexed.get();
    }

    public long getAnalyzedElements() {
        return this.elementsAnalyzed.get();
    }

    @Override
    public E getOldestElement() {
        IBufferElement<E> bufferElement = this.last.get();
        if (null != bufferElement) {
            return (E)((DefaultData)bufferElement.getObject());
        }
        return null;
    }

    @Override
    public E getNewestElement() {
        IBufferElement<E> bufferElement = this.first.get();
        if (null != bufferElement) {
            return (E)((DefaultData)bufferElement.getObject());
        }
        return null;
    }

    @PostConstruct
    public void postConstruct() throws Exception {
        this.maxSize = new AtomicLong(this.bufferProperties.getInitialBufferSize());
        this.evictionOccupancyPercentage = new AtomicInteger(Float.floatToIntBits(this.bufferProperties.getEvictionOccupancyPercentage()));
        this.objectSizes.setObjectSecurityExpansionRate(this.bufferProperties.getObjectSecurityExpansionRate(this.maxSize.get()));
        this.first = new AtomicReference<EmptyBufferElement>(this.emptyBufferElement);
        this.last = new AtomicReference<EmptyBufferElement>(this.emptyBufferElement);
        this.lastAnalyzed = new AtomicReference<EmptyBufferElement>(this.emptyBufferElement);
        this.lastIndexed = new AtomicReference<EmptyBufferElement>(this.emptyBufferElement);
        this.indexingTreeCleaningExecutorService = Executors.newFixedThreadPool(this.bufferProperties.getIndexingTreeCleaningThreads());
        this.flagsSetOnBytes = this.bufferProperties.getFlagsSetOnBytes(this.maxSize.get());
        this.analyzeProcessor = new AnalyzeBufferElementProcessor<E>(this, this.lastAnalyzed, this.analyzeLock, this.nothingToAnalyze);
        this.indexProcessor = new IndexBufferElementProcessor<E>(this, this.lastIndexed, this.indexingLock, this.nothingToIndex);
        if (this.log.isInfoEnabled()) {
            this.log.info("|-Using buffer with maximum size " + NumberFormat.getInstance().format(this.maxSize) + " bytes...");
            this.log.info("|-Indexing tree maintenance on " + NumberFormat.getInstance().format(this.flagsSetOnBytes) + " bytes added/removed...");
            this.log.info("|-Using object expansion rate of " + NumberFormat.getInstance().format(this.objectSizes.getObjectSecurityExpansionRate() * 100.0f) + "%");
        }
    }

    @PropertyUpdate(properties={"buffer.evictionOccupancyPercentage", "buffer.bytesMaintenancePercentage"})
    protected void updateEvictionOccupancyPercentage() {
        this.evictionOccupancyPercentage.set(Float.floatToIntBits(this.bufferProperties.getEvictionOccupancyPercentage()));
    }

    @PropertyUpdate(properties={"buffer.bytesMaintenancePercentage"})
    protected void updateBytesMaintenancePercentage() {
        this.flagsSetOnBytes = this.bufferProperties.getFlagsSetOnBytes(this.maxSize.get());
    }

    @PropertyUpdate(properties={"buffer.minOldSpaceOccupancy", "buffer.maxOldSpaceOccupancy", "buffer.minOldSpaceOccupancyActiveTillOldGenSize", "buffer.maxOldSpaceOccupancyActiveFromOldGenSize"})
    protected void updateBufferSizeAndRelated() {
        this.maxSize.set(this.bufferProperties.getInitialBufferSize());
        this.objectSizes.setObjectSecurityExpansionRate(this.bufferProperties.getObjectSecurityExpansionRate(this.maxSize.get()));
        this.flagsSetOnBytes = this.bufferProperties.getFlagsSetOnBytes(this.maxSize.get());
    }

    @PropertyUpdate(properties={"buffer.minObjectExpansionRate", "buffer.maxObjectExpansionRate", "buffer.maxObjectExpansionRateActiveTillBufferSize", "buffer.minObjectExpansionRateActiveFromBufferSize", "buffer.maxObjectExpansionRateActiveFromOccupancy", "buffer.minObjectExpansionRateActiveTillOccupancy"})
    protected void updateObjectSecurityExpansionRate() {
        this.objectSizes.setObjectSecurityExpansionRate(this.bufferProperties.getObjectSecurityExpansionRate(this.maxSize.get()));
    }

    public String toString() {
        StringBuffer msg = new StringBuffer(256);
        msg.append("The buffer occupancy status: ");
        msg.append(NumberFormat.getInstance().format(this.currentSize.get()));
        msg.append(" bytes occupied from total ");
        msg.append(NumberFormat.getInstance().format(this.maxSize.get()));
        msg.append(" bytes available (");
        msg.append(NumberFormat.getInstance().format(this.getOccupancyPercentage() * 100.0f));
        msg.append("%).\nElements processed in the buffer since last clear buffer:\n-Elements added: ");
        msg.append(NumberFormat.getInstance().format(this.elementsAdded.get()));
        msg.append("\n-Elements analyzed: ");
        msg.append(NumberFormat.getInstance().format(this.elementsAnalyzed.get()));
        msg.append("\n-Elements indexed: ");
        msg.append(NumberFormat.getInstance().format(this.elementsIndexed.get()));
        msg.append("\n-Elements evicted: ");
        msg.append(NumberFormat.getInstance().format(this.elementsEvicted.get()));
        msg.append('\n');
        return msg.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyEvictionIfNeeded() {
        if (this.shouldEvict()) {
            this.evictLock.lock();
            try {
                this.nothingToEvict.signal();
            }
            finally {
                this.evictLock.unlock();
            }
        }
    }

    private class EmptyBufferElement
    implements IBufferElement<E> {
        private EmptyBufferElement() {
        }

        @Override
        public E getObject() {
            return null;
        }

        @Override
        public long getBufferElementSize() {
            return 0L;
        }

        @Override
        public void setBufferElementSize(long size) {
        }

        @Override
        public void calculateAndSetBufferElementSize(IObjectSizes objectSizes) {
        }

        @Override
        public IBufferElement<E> getNextElement() {
            return null;
        }

        @Override
        public void setNextElement(IBufferElement<E> element) {
        }

        @Override
        public boolean isAnalyzed() {
            return false;
        }

        @Override
        public boolean isEvicted() {
            return false;
        }

        @Override
        public boolean isIndexed() {
            return false;
        }

        @Override
        public IBufferElement.BufferElementState getBufferElementState() {
            return null;
        }

        @Override
        public void setBufferElementState(IBufferElement.BufferElementState bufferElementState) {
        }
    }
}

