/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.cache.impl;

import info.novatec.inspectit.cmr.cache.IBufferElement;
import info.novatec.inspectit.cmr.cache.impl.AbstractBufferElementProcessor;
import info.novatec.inspectit.cmr.cache.impl.AtomicBuffer;
import info.novatec.inspectit.communication.DefaultData;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

class AnalyzeBufferElementProcessor<E extends DefaultData>
extends AbstractBufferElementProcessor<E> {
    public AnalyzeBufferElementProcessor(AtomicBuffer<E> atomicBuffer, AtomicReference<IBufferElement<E>> lastProcessed, Lock lock, Condition condition) {
        super(atomicBuffer, lastProcessed, lock, condition);
    }

    @Override
    public boolean process(IBufferElement<E> elementToProcess, IBufferElement<E> lastProcessedElement) {
        if (this.lastProcessed.compareAndSet(lastProcessedElement, elementToProcess)) {
            elementToProcess.calculateAndSetBufferElementSize(this.atomicBuffer.objectSizes);
            elementToProcess.setBufferElementState(IBufferElement.BufferElementState.ANALYZED);
            this.atomicBuffer.addToCurrentSize(elementToProcess.getBufferElementSize(), true);
            this.atomicBuffer.elementsAnalyzed.incrementAndGet();
            return true;
        }
        return false;
    }
}

