/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.util;

import info.novatec.inspectit.cmr.CMR;
import info.novatec.inspectit.spring.logger.Log;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class ShutdownService {
    private static final int RESTART_EXIT_CODE = 10;
    private static final String RESTART_CMR_COMMAND = "cmd.exe /c net stop inspectITCMR >NUL & net start inspectITCMR >NUL";
    private static final String SHUTDOWN_CMR_COMMAND = "cmd.exe /c net stop inspectITCMR >NUL";
    @Log
    Logger log;
    private volatile boolean isShutdown = false;
    private ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart() {
        ShutdownService shutdownService = this;
        synchronized (shutdownService) {
            if (this.isShutdown) {
                return;
            }
            this.isShutdown = true;
        }
        this.doShutdown(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        ShutdownService shutdownService = this;
        synchronized (shutdownService) {
            if (this.isShutdown) {
                return;
            }
            this.isShutdown = true;
        }
        this.doShutdown(false);
    }

    private void doShutdown(final boolean restart) {
        if (restart) {
            this.log.info("Restart initialized");
        } else {
            this.log.info("Shutdown initialized");
        }
        Runnable shutdownRunnable = new Runnable(){

            @Override
            public void run() {
                if (restart) {
                    if (CMR.isStartedAsService()) {
                        try {
                            Runtime.getRuntime().exec(ShutdownService.RESTART_CMR_COMMAND);
                        }
                        catch (IOException e) {
                            ShutdownService.this.log.error(e.getMessage());
                        }
                    } else {
                        System.exit(10);
                    }
                } else if (CMR.isStartedAsService()) {
                    try {
                        Runtime.getRuntime().exec(ShutdownService.SHUTDOWN_CMR_COMMAND);
                    }
                    catch (IOException e) {
                        ShutdownService.this.log.error(e.getMessage());
                    }
                } else {
                    System.exit(0);
                }
            }
        };
        this.executorService.schedule(shutdownRunnable, 500L, TimeUnit.MILLISECONDS);
    }

    @PostConstruct
    public void postConstruct() throws IOException {
        if (this.log.isInfoEnabled()) {
            this.log.info("|-Shutdown Service active...");
        }
    }
}

