/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.util;

import info.novatec.inspectit.cmr.model.PlatformIdent;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.stereotype.Component;

@Component
public class PlatformIdentCache {
    private Map<Long, PlatformIdent> cleanPlatformIdents = new ConcurrentHashMap<Long, PlatformIdent>();
    private Map<Long, PlatformIdent> dirtyPlatformIdents = new ConcurrentHashMap<Long, PlatformIdent>();

    public void markDirty(PlatformIdent platformIdent) {
        this.mark(platformIdent, true);
    }

    public void markClean(PlatformIdent platformIdent) {
        this.mark(platformIdent, false);
    }

    public void remove(PlatformIdent platformIdent) {
        this.cleanPlatformIdents.remove(platformIdent.getId());
        this.dirtyPlatformIdents.remove(platformIdent.getId());
    }

    public Collection<PlatformIdent> getCleanPlatformIdents() {
        return this.getPlatformIdents(false);
    }

    public Collection<PlatformIdent> getDirtyPlatformIdents() {
        return this.getPlatformIdents(true);
    }

    public int getSize() {
        return this.cleanPlatformIdents.size() + this.dirtyPlatformIdents.size();
    }

    private Collection<PlatformIdent> getPlatformIdents(boolean dirty) {
        if (dirty) {
            return this.dirtyPlatformIdents.values();
        }
        return this.cleanPlatformIdents.values();
    }

    private void mark(PlatformIdent platformIdent, boolean dirty) {
        this.cleanPlatformIdents.remove(platformIdent.getId());
        this.dirtyPlatformIdents.remove(platformIdent.getId());
        if (dirty) {
            this.dirtyPlatformIdents.put(platformIdent.getId(), platformIdent);
        } else {
            this.cleanPlatformIdents.put(platformIdent.getId(), platformIdent);
        }
    }
}

