/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.util;

import info.novatec.inspectit.cmr.cache.IBuffer;
import info.novatec.inspectit.cmr.service.ICmrManagementService;
import info.novatec.inspectit.cmr.storage.CmrStorageManager;
import info.novatec.inspectit.spring.logger.Log;
import info.novatec.inspectit.storage.StorageData;
import info.novatec.inspectit.storage.nio.ByteBufferProvider;
import info.novatec.inspectit.storage.nio.write.WritingChannelManager;
import info.novatec.inspectit.storage.recording.RecordingState;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class HealthStatus {
    @Log
    Logger log;
    private static final char START_END_CHAR = '+';
    private static final int WIDTH = 30;
    private static final int FIXED_RATE = 60000;
    private boolean beansAvailable = false;
    private MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
    private OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
    private ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
    @Autowired
    private IBuffer<?> buffer;
    @Autowired
    private ICmrManagementService cmrManagementService;
    @Autowired
    private WritingChannelManager writingChannelManager;
    @Autowired
    private CmrStorageManager storageManager;
    @Autowired
    private ByteBufferProvider byteBufferProvider;

    @Scheduled(fixedRate=60000L)
    public void logStatistics() {
        if (this.beansAvailable && this.log.isInfoEnabled()) {
            this.logOperatingSystemStatistics();
            this.logRuntimeStatistics();
            this.logMemoryStatistics();
            this.logThreadStatistics();
            this.log.info("\n");
        }
        if (this.log.isInfoEnabled()) {
            this.logDroppedData();
            this.logBufferStatistics();
            this.logStorageStatistics();
        }
    }

    private void logOperatingSystemStatistics() {
        String arch = this.operatingSystemMXBean.getArch();
        String name = this.operatingSystemMXBean.getName();
        String version = this.operatingSystemMXBean.getVersion();
        int availCpus = this.operatingSystemMXBean.getAvailableProcessors();
        double loadAverage = this.operatingSystemMXBean.getSystemLoadAverage();
        StringBuilder sb = new StringBuilder();
        sb.append("System: ");
        sb.append(name);
        sb.append(' ');
        sb.append(version);
        sb.append(' ');
        sb.append(arch);
        sb.append(" (");
        sb.append(availCpus);
        sb.append(" cpu(s) load average: ");
        sb.append(loadAverage);
        this.log.info(sb.toString());
        this.logGraphicalLoadAverage(loadAverage, availCpus);
    }

    private void logGraphicalLoadAverage(double loadAvg, int availCpus) {
        int i;
        double value;
        long load;
        double loadAverage = loadAvg;
        if (loadAverage < 0.0) {
            loadAverage = 0.0;
        }
        if ((load = Math.round(loadAverage * (value = 30.0 / (double)availCpus))) > 30L) {
            load = 30L;
        }
        String title = "CPU load";
        StringBuilder sb = new StringBuilder();
        sb.append('+');
        sb.append('-');
        sb.append(title);
        for (i = title.length() + 1; i < 30; ++i) {
            sb.append('-');
        }
        sb.append('+');
        this.log.info(sb.toString());
        sb = new StringBuilder();
        sb.append('+');
        i = 0;
        while ((long)i < load) {
            sb.append('/');
            ++i;
        }
        for (long i2 = load; i2 < 30L; ++i2) {
            sb.append(' ');
        }
        sb.append('+');
        this.log.info(sb.toString());
        sb = new StringBuilder();
        sb.append('+');
        for (int i3 = 0; i3 < 30; ++i3) {
            sb.append('-');
        }
        sb.append('+');
        this.log.info(sb.toString());
    }

    private void logRuntimeStatistics() {
        String name = this.runtimeMXBean.getName();
        long uptime = this.runtimeMXBean.getUptime();
        String vmName = this.runtimeMXBean.getVmName();
        String vmVendor = this.runtimeMXBean.getVmVendor();
        StringBuilder sb = new StringBuilder();
        sb.append("VM: ");
        sb.append(vmName);
        sb.append(" (");
        sb.append(vmVendor);
        sb.append(") process: ");
        sb.append(name);
        sb.append(" uptime: ");
        sb.append(uptime);
        sb.append(" ms");
        this.log.info(sb.toString());
    }

    private void logMemoryStatistics() {
        MemoryUsage heapMemoryUsage = this.memoryMXBean.getHeapMemoryUsage();
        MemoryUsage nonHeapMemoryUsage = this.memoryMXBean.getNonHeapMemoryUsage();
        this.log.info("Heap: " + heapMemoryUsage);
        this.logGraphicalMemoryUsage(heapMemoryUsage, "Heap");
        this.log.info("Non Heap: " + nonHeapMemoryUsage);
        this.logGraphicalMemoryUsage(nonHeapMemoryUsage, "Non-Heap");
        this.log.info("Pending finalizations: " + this.memoryMXBean.getObjectPendingFinalizationCount());
    }

    private void logGraphicalMemoryUsage(MemoryUsage memoryUsage, String title) {
        if (this.areMemoryUsageValuesCorrect(memoryUsage)) {
            long i;
            int i2;
            double value = 30.0 / (double)memoryUsage.getMax();
            long used = Math.round((double)memoryUsage.getUsed() * value);
            long committed = Math.round((double)memoryUsage.getCommitted() * value);
            StringBuilder sb = new StringBuilder();
            sb.append('+');
            sb.append('-');
            sb.append(title);
            for (i2 = title.length() + 1; i2 < 30; ++i2) {
                sb.append('-');
            }
            sb.append('+');
            this.log.info(sb.toString());
            sb = new StringBuilder();
            sb.append('+');
            i2 = 0;
            while ((long)i2 < used) {
                sb.append('/');
                ++i2;
            }
            long pos = used;
            if (pos <= committed) {
                for (i = pos; i < committed; ++i) {
                    sb.append(' ');
                }
                sb.append('|');
                pos = committed + 1L;
            }
            for (i = pos; i < 30L; ++i) {
                sb.append(' ');
            }
            if (committed < 30L) {
                sb.append('+');
            }
            this.log.info(sb.toString());
            sb = new StringBuilder();
            sb.append('+');
            for (int i3 = 0; i3 < 30; ++i3) {
                sb.append('-');
            }
            sb.append('+');
            this.log.info(sb.toString());
        }
    }

    private boolean areMemoryUsageValuesCorrect(MemoryUsage memoryUsage) {
        if (memoryUsage.getCommitted() < 0L || memoryUsage.getUsed() < 0L || memoryUsage.getMax() < 0L) {
            return false;
        }
        if (memoryUsage.getUsed() > memoryUsage.getMax()) {
            return false;
        }
        if (memoryUsage.getUsed() > memoryUsage.getCommitted()) {
            return false;
        }
        return memoryUsage.getCommitted() <= memoryUsage.getMax();
    }

    private void logThreadStatistics() {
        int threadCount = this.threadMXBean.getThreadCount();
        long totalStartedThreads = this.threadMXBean.getTotalStartedThreadCount();
        StringBuilder sb = new StringBuilder();
        sb.append("Threads: ");
        sb.append(threadCount);
        sb.append(" total started: ");
        sb.append(totalStartedThreads);
        this.log.info(sb.toString());
    }

    private void logBufferStatistics() {
        String[] lines;
        for (String str : lines = this.buffer.toString().split("\n")) {
            this.log.info(str);
        }
        this.logGraphicalBufferOccupancy(this.buffer.getOccupancyPercentage());
    }

    private void logGraphicalBufferOccupancy(float bufferOccupancy) {
        int i;
        String title = "Buffer";
        int used = (int)(bufferOccupancy * 30.0f);
        StringBuilder sb = new StringBuilder();
        sb.append('+');
        sb.append('-');
        sb.append(title);
        for (i = title.length() + 1; i < 30; ++i) {
            sb.append('-');
        }
        sb.append('+');
        this.log.info(sb.toString());
        sb = new StringBuilder();
        sb.append('+');
        for (i = 0; i < used; ++i) {
            sb.append('/');
        }
        for (int j = used; j < 30; ++j) {
            sb.append(' ');
        }
        sb.append('+');
        this.log.info(sb.toString());
        sb = new StringBuilder();
        sb.append('+');
        for (i = 0; i < 30; ++i) {
            sb.append('-');
        }
        sb.append('+');
        this.log.info(sb.toString());
    }

    private void logStorageStatistics() {
        this.log.info("Status of the Write Channel Manager's executor service: " + this.writingChannelManager.getExecutorServiceStatus());
        this.log.info("Status of each writable storage and its executor service:");
        Map<StorageData, String> writersStatusMap = this.storageManager.getWritersStatus();
        if (!writersStatusMap.isEmpty()) {
            for (Map.Entry<StorageData, String> entry : writersStatusMap.entrySet()) {
                this.log.info("Storage " + entry.getKey() + " - " + entry.getValue());
            }
        } else {
            this.log.info("No active writable storage available.");
        }
        if (this.storageManager.getRecordingState() == RecordingState.ON) {
            StorageData recordingStorageData = this.storageManager.getRecordingStorage();
            if (null != recordingStorageData) {
                this.log.info("Recording is active on the storage " + recordingStorageData + ".");
            }
        } else {
            this.log.info("Recording is not active.");
        }
        this.log.info("Byte buffer provider has " + this.byteBufferProvider.getBufferPoolSize() + " available buffers in the pool with total capacity of " + this.byteBufferProvider.getAvailableCapacity() + " bytes. Total created capacity of the pool is " + this.byteBufferProvider.getCreatedCapacity() + " bytes.");
    }

    private void logDroppedData() {
        this.log.info("Dropped elements due to the high load on the CMR (total count): " + this.cmrManagementService.getDroppedDataCount());
    }

    private void startUpCheck() {
        try {
            this.operatingSystemMXBean.getArch();
            this.operatingSystemMXBean.getName();
            this.operatingSystemMXBean.getVersion();
            this.operatingSystemMXBean.getAvailableProcessors();
            this.operatingSystemMXBean.getSystemLoadAverage();
            this.runtimeMXBean.getName();
            this.runtimeMXBean.getUptime();
            this.runtimeMXBean.getVmName();
            this.runtimeMXBean.getVmVendor();
            this.memoryMXBean.getHeapMemoryUsage();
            this.memoryMXBean.getNonHeapMemoryUsage();
            this.threadMXBean.getThreadCount();
            this.threadMXBean.getTotalStartedThreadCount();
            this.beansAvailable = true;
        }
        catch (Exception e) {
            this.beansAvailable = false;
        }
    }

    @PostConstruct
    public void postConstruct() throws Exception {
        this.startUpCheck();
        if (this.beansAvailable) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Health Service active...");
            }
        } else if (this.log.isInfoEnabled()) {
            this.log.info("Health Service not active...");
        }
    }
}

