/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.util;

import info.novatec.inspectit.communication.data.cmr.AgentStatusData;
import info.novatec.inspectit.spring.logger.Log;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AgentStatusDataProvider
implements InitializingBean {
    private final Runnable keepAliveCheckRunner = new Runnable(){

        @Override
        public void run() {
            long currentTime = System.currentTimeMillis();
            for (Map.Entry entry : AgentStatusDataProvider.this.agentStatusDataMap.entrySet()) {
                long timeToLastSignal;
                if (((AgentStatusData)entry.getValue()).getAgentConnection() != AgentStatusData.AgentConnection.CONNECTED || currentTime - ((AgentStatusData)entry.getValue()).getConnectionTimestamp() < 5000L || (timeToLastSignal = currentTime - ((AgentStatusData)entry.getValue()).getLastKeepAliveTimestamp()) <= 5000L) continue;
                AgentStatusDataProvider.this.registerKeepAliveTimeout((Long)entry.getKey());
                if (!AgentStatusDataProvider.this.log.isInfoEnabled()) continue;
                AgentStatusDataProvider.this.log.info("Platform " + entry.getKey() + " timed out.");
            }
        }
    };
    @Log
    Logger log;
    @Autowired
    @Resource(name="scheduledExecutorService")
    ScheduledExecutorService executorService;
    private ConcurrentHashMap<Long, AgentStatusData> agentStatusDataMap = new ConcurrentHashMap(8, 0.75f, 1);

    public void registerConnected(long platformIdent) {
        AgentStatusData agentStatusData = this.agentStatusDataMap.get(platformIdent);
        if (null == agentStatusData) {
            agentStatusData = new AgentStatusData(AgentStatusData.AgentConnection.CONNECTED);
            AgentStatusData existing = this.agentStatusDataMap.putIfAbsent(platformIdent, agentStatusData);
            if (null != existing) {
                agentStatusData = existing;
            }
        }
        agentStatusData.setConnectionTimestamp(System.currentTimeMillis());
        agentStatusData.setAgentConnection(AgentStatusData.AgentConnection.CONNECTED);
    }

    public void registerDisconnected(long platformIdent) {
        AgentStatusData agentStatusData = this.agentStatusDataMap.get(platformIdent);
        if (null != agentStatusData) {
            agentStatusData.setAgentConnection(AgentStatusData.AgentConnection.DISCONNECTED);
        }
    }

    public void registerDataSent(long platformIdent) {
        AgentStatusData agentStatusData = this.agentStatusDataMap.get(platformIdent);
        if (null != agentStatusData) {
            agentStatusData.setLastDataSendTimestamp(System.currentTimeMillis());
        }
    }

    public void handleKeepAliveSignal(long platformIdent) {
        AgentStatusData agentStatusData = this.agentStatusDataMap.get(platformIdent);
        if (null != agentStatusData) {
            agentStatusData.setLastKeepAliveTimestamp(System.currentTimeMillis());
            if (agentStatusData.getAgentConnection() == AgentStatusData.AgentConnection.NO_KEEP_ALIVE) {
                agentStatusData.setAgentConnection(AgentStatusData.AgentConnection.CONNECTED);
                if (this.log.isInfoEnabled()) {
                    this.log.info("Platform " + platformIdent + " sending keep-alive signals again.");
                }
            }
        }
    }

    public void registerKeepAliveTimeout(long platformIdent) {
        AgentStatusData agentStatusData = this.agentStatusDataMap.get(platformIdent);
        if (null != agentStatusData) {
            agentStatusData.setAgentConnection(AgentStatusData.AgentConnection.NO_KEEP_ALIVE);
        }
    }

    public void registerDeleted(long platformId) {
        this.agentStatusDataMap.remove(platformId);
    }

    public Map<Long, AgentStatusData> getAgentStatusDataMap() {
        long currentTime = System.currentTimeMillis();
        HashMap<Long, AgentStatusData> map = new HashMap<Long, AgentStatusData>();
        for (Map.Entry<Long, AgentStatusData> entry : this.agentStatusDataMap.entrySet()) {
            entry.getValue().setServerTimestamp(currentTime);
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public void afterPropertiesSet() throws Exception {
        this.executorService.scheduleAtFixedRate(this.keepAliveCheckRunner, 2500L, 5000L, TimeUnit.MILLISECONDS);
    }
}

