/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.storage;

import info.novatec.inspectit.communication.data.ExceptionSensorData;
import info.novatec.inspectit.communication.data.SqlStatementData;
import info.novatec.inspectit.communication.data.TimerData;
import info.novatec.inspectit.indexing.IIndexQuery;
import info.novatec.inspectit.indexing.aggregation.Aggregators;
import info.novatec.inspectit.indexing.aggregation.IAggregator;
import info.novatec.inspectit.indexing.aggregation.impl.ExceptionDataAggregator;
import info.novatec.inspectit.indexing.aggregation.impl.SqlStatementDataAggregator;
import info.novatec.inspectit.indexing.aggregation.impl.TimerDataAggregator;
import info.novatec.inspectit.indexing.query.factory.impl.ExceptionSensorDataQueryFactory;
import info.novatec.inspectit.indexing.query.factory.impl.SqlStatementDataQueryFactory;
import info.novatec.inspectit.indexing.query.factory.impl.TimerDataQueryFactory;
import info.novatec.inspectit.indexing.query.provider.IIndexQueryProvider;
import info.novatec.inspectit.indexing.query.provider.impl.StorageIndexQueryProvider;
import info.novatec.inspectit.indexing.storage.impl.StorageIndexQuery;
import info.novatec.inspectit.storage.processor.write.AbstractWriteDataProcessor;
import info.novatec.inspectit.storage.processor.write.impl.QueryCachingDataProcessor;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;

@Configuration
public class CachingWriteDataProcessorProvider {
    @Autowired
    private StorageIndexQueryProvider storageIndexQueryProvider;
    private TimerDataQueryFactory<StorageIndexQuery> timerDataQueryFactory;
    private SqlStatementDataQueryFactory<StorageIndexQuery> sqlStatementDataQueryFactory;
    private ExceptionSensorDataQueryFactory<StorageIndexQuery> exceptionSensorDataQueryFactory;

    @Bean
    @Lazy
    @Scope(value="prototype")
    public AbstractWriteDataProcessor getTimerDataCachingDataProcessor() {
        IIndexQuery query = this.timerDataQueryFactory.getAggregatedTimerDataQuery(new TimerData(), null, null);
        TimerDataAggregator aggregator = Aggregators.TIMER_DATA_AGGREGATOR;
        return new QueryCachingDataProcessor(query, (IAggregator)aggregator);
    }

    @Bean
    @Lazy
    @Scope(value="prototype")
    public AbstractWriteDataProcessor getSqlDataCachingDataProcessor() {
        IIndexQuery query = this.sqlStatementDataQueryFactory.getAggregatedSqlStatementsQuery(new SqlStatementData(), null, null);
        SqlStatementDataAggregator aggregator = Aggregators.SQL_STATEMENT_DATA_AGGREGATOR;
        return new QueryCachingDataProcessor(query, (IAggregator)aggregator);
    }

    @Bean
    @Lazy
    @Scope(value="prototype")
    public AbstractWriteDataProcessor getGroupedExceptionsDataCachingDataProcessor() {
        IIndexQuery query = this.exceptionSensorDataQueryFactory.getDataForGroupedExceptionOverviewQuery(new ExceptionSensorData(), null, null);
        ExceptionDataAggregator aggregator = Aggregators.GROUP_EXCEPTION_OVERVIEW_AGGREGATOR;
        return new QueryCachingDataProcessor(query, (IAggregator)aggregator);
    }

    @PostConstruct
    public void initFactories() {
        this.timerDataQueryFactory = new TimerDataQueryFactory();
        this.timerDataQueryFactory.setIndexQueryProvider((IIndexQueryProvider)this.storageIndexQueryProvider);
        this.sqlStatementDataQueryFactory = new SqlStatementDataQueryFactory();
        this.sqlStatementDataQueryFactory.setIndexQueryProvider((IIndexQueryProvider)this.storageIndexQueryProvider);
        this.exceptionSensorDataQueryFactory = new ExceptionSensorDataQueryFactory();
        this.exceptionSensorDataQueryFactory.setIndexQueryProvider((IIndexQueryProvider)this.storageIndexQueryProvider);
    }
}

