/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.spring.exporter;

import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import info.novatec.inspectit.storage.serializer.SerializationException;
import info.novatec.inspectit.storage.serializer.impl.SerializationManager;
import info.novatec.inspectit.storage.serializer.provider.SerializationManagerProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.remoting.httpinvoker.HttpInvokerServiceExporter;
import org.springframework.remoting.support.RemoteInvocation;
import org.springframework.remoting.support.RemoteInvocationResult;

public class KryoHttpInvokerServiceExporter
extends HttpInvokerServiceExporter {
    @Autowired
    private SerializationManagerProvider serializationManagerProvider;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected RemoteInvocation readRemoteInvocation(HttpServletRequest request, InputStream is) throws IOException, ClassNotFoundException {
        try (Input input = new Input(is);){
            SerializationManager serializer = this.serializationManagerProvider.createSerializer();
            RemoteInvocation remoteInvocation = (RemoteInvocation)serializer.deserialize(input);
            return remoteInvocation;
        }
        catch (SerializationException e) {
            throw new IOException(e);
        }
    }

    protected void writeRemoteInvocationResult(HttpServletRequest request, HttpServletResponse response, RemoteInvocationResult result, OutputStream os) throws IOException {
        try (Output output = new Output(os);){
            if (!result.hasException()) {
                Object value = result.getValue();
                result = new RemoteInvocationResult(value);
            }
            SerializationManager serializer = this.serializationManagerProvider.createSerializer();
            serializer.serialize((Object)result, output);
        }
        catch (SerializationException e) {
            throw new IOException(e);
        }
    }
}

