/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.service;

import info.novatec.inspectit.cmr.dao.StorageDataDao;
import info.novatec.inspectit.cmr.service.IStorageService;
import info.novatec.inspectit.cmr.spring.aop.MethodLog;
import info.novatec.inspectit.cmr.storage.CmrStorageManager;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.data.cmr.RecordingData;
import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.exception.IErrorCode;
import info.novatec.inspectit.exception.TechnicalException;
import info.novatec.inspectit.exception.enumeration.StorageErrorCodeEnum;
import info.novatec.inspectit.spring.logger.Log;
import info.novatec.inspectit.storage.IStorageData;
import info.novatec.inspectit.storage.StorageData;
import info.novatec.inspectit.storage.StorageFileType;
import info.novatec.inspectit.storage.label.AbstractStorageLabel;
import info.novatec.inspectit.storage.label.management.AbstractLabelManagementAction;
import info.novatec.inspectit.storage.label.type.AbstractStorageLabelType;
import info.novatec.inspectit.storage.processor.AbstractDataProcessor;
import info.novatec.inspectit.storage.recording.RecordingProperties;
import info.novatec.inspectit.storage.recording.RecordingState;
import info.novatec.inspectit.storage.serializer.SerializationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StorageService
implements IStorageService {
    @Log
    Logger log;
    @Autowired
    private CmrStorageManager storageManager;
    @Autowired
    private StorageDataDao storageLabelDataDao;

    @MethodLog
    public void createStorage(StorageData storageData) throws BusinessException {
        try {
            this.storageManager.createStorage(storageData);
        }
        catch (SerializationException e) {
            throw new TechnicalException("Create the storage " + storageData + ".", (IErrorCode)StorageErrorCodeEnum.SERIALIZATION_FAILED, (Throwable)e);
        }
        catch (IOException e) {
            throw new TechnicalException("Create the storage " + storageData + ".", (IErrorCode)StorageErrorCodeEnum.INPUT_OUTPUT_OPERATION_FAILED, (Throwable)e);
        }
    }

    @MethodLog
    public void openStorage(StorageData storageData) throws BusinessException {
        if (!this.storageManager.isStorageExisting(storageData)) {
            throw new BusinessException("Open the storage " + storageData + ".", (IErrorCode)StorageErrorCodeEnum.STORAGE_DOES_NOT_EXIST);
        }
        try {
            this.storageManager.openStorage(storageData);
        }
        catch (SerializationException e) {
            throw new TechnicalException("Open the storage " + storageData + ".", (IErrorCode)StorageErrorCodeEnum.SERIALIZATION_FAILED, (Throwable)e);
        }
        catch (IOException e) {
            throw new TechnicalException("Open the storage " + storageData + ".", (IErrorCode)StorageErrorCodeEnum.INPUT_OUTPUT_OPERATION_FAILED, (Throwable)e);
        }
    }

    @MethodLog
    public StorageData createAndOpenStorage(StorageData storageData) throws BusinessException {
        this.createStorage(storageData);
        this.openStorage(storageData);
        return storageData;
    }

    @MethodLog
    public void closeStorage(StorageData storageData) throws BusinessException {
        try {
            this.storageManager.closeStorage(storageData);
        }
        catch (SerializationException e) {
            throw new TechnicalException("Close the storage " + storageData + ".", (IErrorCode)StorageErrorCodeEnum.SERIALIZATION_FAILED, (Throwable)e);
        }
        catch (IOException e) {
            throw new TechnicalException("Close the storage " + storageData + ".", (IErrorCode)StorageErrorCodeEnum.INPUT_OUTPUT_OPERATION_FAILED, (Throwable)e);
        }
    }

    @MethodLog
    public void deleteStorage(StorageData storageData) throws BusinessException {
        try {
            this.storageManager.deleteStorage(storageData);
        }
        catch (IOException e) {
            throw new TechnicalException("Delete the storage " + storageData + ".", (IErrorCode)StorageErrorCodeEnum.INPUT_OUTPUT_OPERATION_FAILED, (Throwable)e);
        }
    }

    @MethodLog
    public boolean isStorageOpen(StorageData storageData) {
        return this.storageManager.isStorageOpen(storageData);
    }

    @MethodLog
    public List<StorageData> getOpenedStorages() {
        return this.storageManager.getOpenedStorages();
    }

    @MethodLog
    public List<StorageData> getExistingStorages() {
        return this.storageManager.getExistingStorages();
    }

    @MethodLog
    public List<StorageData> getReadableStorages() {
        return this.storageManager.getReadableStorages();
    }

    @MethodLog
    public RecordingState getRecordingState() {
        return this.storageManager.getRecordingState();
    }

    @MethodLog
    public StorageData startOrScheduleRecording(StorageData storageData, RecordingProperties recordingProperties) throws BusinessException {
        if (!(this.storageManager.getRecordingState() != RecordingState.ON && this.storageManager.getRecordingState() != RecordingState.SCHEDULED || storageData.equals((Object)this.storageManager.getRecordingStorage()))) {
            throw new BusinessException("Start or schedule recording on the storage " + storageData + ".", (IErrorCode)StorageErrorCodeEnum.CAN_NOT_START_RECORDING);
        }
        if (this.storageManager.getRecordingState() == RecordingState.ON || this.storageManager.getRecordingState() == RecordingState.SCHEDULED) {
            throw new BusinessException("Start or schedule recording on the storage " + storageData + ".", (IErrorCode)StorageErrorCodeEnum.CAN_NOT_START_RECORDING);
        }
        try {
            this.storageManager.startOrScheduleRecording(storageData, recordingProperties);
            return this.storageManager.getRecordingStorage();
        }
        catch (SerializationException e) {
            throw new TechnicalException("Start or schedule recording on the storage " + storageData + ".", (IErrorCode)StorageErrorCodeEnum.SERIALIZATION_FAILED, (Throwable)e);
        }
        catch (IOException e) {
            throw new TechnicalException("Start or schedule recording on the storage " + storageData + ".", (IErrorCode)StorageErrorCodeEnum.INPUT_OUTPUT_OPERATION_FAILED, (Throwable)e);
        }
    }

    @MethodLog
    public void stopRecording() throws BusinessException {
        try {
            this.storageManager.stopRecording();
        }
        catch (SerializationException e) {
            throw new TechnicalException("Stop recording.", (IErrorCode)StorageErrorCodeEnum.SERIALIZATION_FAILED, (Throwable)e);
        }
        catch (IOException e) {
            throw new TechnicalException("Stop recording.", (IErrorCode)StorageErrorCodeEnum.INPUT_OUTPUT_OPERATION_FAILED, (Throwable)e);
        }
    }

    @MethodLog
    public RecordingData getRecordingData() {
        if (this.storageManager.getRecordingState() == RecordingState.ON || this.storageManager.getRecordingState() == RecordingState.SCHEDULED) {
            RecordingData recordingData = new RecordingData();
            RecordingProperties recordingProperties = this.storageManager.getRecordingProperties();
            if (null != recordingProperties) {
                recordingData.setRecordStartDate(recordingProperties.getRecordStartDate());
                recordingData.setRecordEndDate(recordingProperties.getRecordEndDate());
            }
            recordingData.setRecordingStorage(this.storageManager.getRecordingStorage());
            recordingData.setRecordingWritingStatus(this.storageManager.getRecordingStatus());
            return recordingData;
        }
        return null;
    }

    @MethodLog
    public void writeToStorage(StorageData storageData, Collection<DefaultData> defaultDataCollection, Collection<AbstractDataProcessor> dataProcessors, boolean synchronously) throws BusinessException {
        if (!this.storageManager.isStorageOpen(storageData)) {
            throw new BusinessException("Write to the storage " + storageData + ".", (IErrorCode)StorageErrorCodeEnum.STORAGE_IS_NOT_OPENED);
        }
        try {
            this.storageManager.writeToStorage(storageData, defaultDataCollection, dataProcessors, synchronously);
        }
        catch (SerializationException e) {
            throw new TechnicalException("Write to the storage " + storageData + ".", (IErrorCode)StorageErrorCodeEnum.SERIALIZATION_FAILED, (Throwable)e);
        }
        catch (IOException e) {
            throw new TechnicalException("Write to the storage " + storageData + ".", (IErrorCode)StorageErrorCodeEnum.INPUT_OUTPUT_OPERATION_FAILED, (Throwable)e);
        }
    }

    @MethodLog
    public StorageData copyBufferToStorage(StorageData storageData, List<Long> platformIdents, Collection<AbstractDataProcessor> dataProcessors, boolean autoFinalize) throws BusinessException {
        try {
            this.storageManager.copyBufferToStorage(storageData, platformIdents, dataProcessors, autoFinalize);
            return storageData;
        }
        catch (SerializationException e) {
            throw new TechnicalException("Copy buffer to the storage " + storageData + ".", (IErrorCode)StorageErrorCodeEnum.SERIALIZATION_FAILED, (Throwable)e);
        }
        catch (IOException e) {
            throw new TechnicalException("Copy buffer to the storage " + storageData + ".", (IErrorCode)StorageErrorCodeEnum.INPUT_OUTPUT_OPERATION_FAILED, (Throwable)e);
        }
    }

    public StorageData copyDataToStorage(StorageData storageData, Collection<Long> elementIds, long platformIdent, Collection<AbstractDataProcessor> dataProcessors, boolean autoFinalize) throws BusinessException {
        try {
            this.storageManager.copyDataToStorage(storageData, elementIds, platformIdent, dataProcessors, autoFinalize);
            return storageData;
        }
        catch (SerializationException e) {
            throw new TechnicalException("Write to the storage " + storageData + ".", (IErrorCode)StorageErrorCodeEnum.SERIALIZATION_FAILED, (Throwable)e);
        }
        catch (IOException e) {
            throw new TechnicalException("Write to the storage " + storageData + ".", (IErrorCode)StorageErrorCodeEnum.INPUT_OUTPUT_OPERATION_FAILED, (Throwable)e);
        }
    }

    @MethodLog
    public Map<String, Long> getIndexFilesLocations(StorageData storageData) throws BusinessException {
        if (!this.storageManager.isStorageExisting(storageData)) {
            throw new BusinessException("Load index files locations for the storage " + storageData + ".", (IErrorCode)StorageErrorCodeEnum.STORAGE_DOES_NOT_EXIST);
        }
        try {
            return this.storageManager.getFilesHttpLocation(storageData, StorageFileType.INDEX_FILE.getExtension());
        }
        catch (IOException e) {
            throw new TechnicalException("Load index files locations for the storage " + storageData + ".", (IErrorCode)StorageErrorCodeEnum.INPUT_OUTPUT_OPERATION_FAILED, (Throwable)e);
        }
    }

    @MethodLog
    public Map<String, Long> getDataFilesLocations(StorageData storageData) throws BusinessException {
        if (!this.storageManager.isStorageExisting(storageData)) {
            throw new BusinessException("Load data files locations for the storage " + storageData + ".", (IErrorCode)StorageErrorCodeEnum.STORAGE_DOES_NOT_EXIST);
        }
        try {
            return this.storageManager.getFilesHttpLocation(storageData, StorageFileType.DATA_FILE.getExtension());
        }
        catch (IOException e) {
            throw new TechnicalException("Load data files locations for the storage " + storageData + ".", (IErrorCode)StorageErrorCodeEnum.INPUT_OUTPUT_OPERATION_FAILED, (Throwable)e);
        }
    }

    @MethodLog
    public Map<String, Long> getCachedDataFilesLocations(StorageData storageData) throws BusinessException {
        if (!this.storageManager.isStorageExisting(storageData)) {
            throw new BusinessException("Load cached files locations for the storage " + storageData + ".", (IErrorCode)StorageErrorCodeEnum.STORAGE_DOES_NOT_EXIST);
        }
        try {
            return this.storageManager.getFilesHttpLocation(storageData, StorageFileType.CACHED_DATA_FILE.getExtension());
        }
        catch (IOException e) {
            throw new TechnicalException("Load cache files locations for the storage " + storageData + ".", (IErrorCode)StorageErrorCodeEnum.INPUT_OUTPUT_OPERATION_FAILED, (Throwable)e);
        }
    }

    @MethodLog
    public Map<String, Long> getAgentFilesLocations(StorageData storageData) throws BusinessException {
        if (!this.storageManager.isStorageExisting(storageData)) {
            throw new BusinessException("Load agent files locations for the storage " + storageData + ".", (IErrorCode)StorageErrorCodeEnum.STORAGE_DOES_NOT_EXIST);
        }
        try {
            return this.storageManager.getFilesHttpLocation(storageData, StorageFileType.AGENT_FILE.getExtension());
        }
        catch (IOException e) {
            throw new TechnicalException("Load agent files locations for the storage " + storageData + ".", (IErrorCode)StorageErrorCodeEnum.INPUT_OUTPUT_OPERATION_FAILED, (Throwable)e);
        }
    }

    @Transactional
    @MethodLog
    public StorageData addLabelToStorage(StorageData storageData, AbstractStorageLabel<?> storageLabel, boolean doOverwrite) throws BusinessException {
        try {
            this.storageManager.addLabelToStorage(storageData, storageLabel, doOverwrite);
            this.storageLabelDataDao.saveLabel(storageLabel);
            return this.storageManager.getStorageData(storageData.getId());
        }
        catch (SerializationException e) {
            throw new TechnicalException("Add a label to the storage " + storageData + ".", (IErrorCode)StorageErrorCodeEnum.SERIALIZATION_FAILED, (Throwable)e);
        }
        catch (IOException e) {
            throw new TechnicalException("Add a label to the storage " + storageData + ".", (IErrorCode)StorageErrorCodeEnum.INPUT_OUTPUT_OPERATION_FAILED, (Throwable)e);
        }
    }

    @Transactional
    @MethodLog
    public StorageData addLabelsToStorage(StorageData storageData, Collection<AbstractStorageLabel<?>> storageLabels, boolean doOverwrite) throws BusinessException {
        try {
            for (AbstractStorageLabel<?> storageLabel : storageLabels) {
                this.storageManager.addLabelToStorage(storageData, storageLabel, doOverwrite);
                this.storageLabelDataDao.saveLabel(storageLabel);
            }
            return this.storageManager.getStorageData(storageData.getId());
        }
        catch (SerializationException e) {
            throw new TechnicalException("Add labels to the storage " + storageData + ".", (IErrorCode)StorageErrorCodeEnum.SERIALIZATION_FAILED, (Throwable)e);
        }
        catch (IOException e) {
            throw new TechnicalException("Add labels to the storage " + storageData + ".", (IErrorCode)StorageErrorCodeEnum.INPUT_OUTPUT_OPERATION_FAILED, (Throwable)e);
        }
    }

    @Transactional
    @MethodLog
    public StorageData removeLabelFromStorage(StorageData storageData, AbstractStorageLabel<?> storageLabel) throws BusinessException {
        try {
            this.storageManager.removeLabelFromStorage(storageData, storageLabel);
            return this.storageManager.getStorageData(storageData.getId());
        }
        catch (SerializationException e) {
            throw new TechnicalException("Remove a label from the storage " + storageData + ".", (IErrorCode)StorageErrorCodeEnum.SERIALIZATION_FAILED, (Throwable)e);
        }
        catch (IOException e) {
            throw new TechnicalException("Remove a label from the storage " + storageData + ".", (IErrorCode)StorageErrorCodeEnum.INPUT_OUTPUT_OPERATION_FAILED, (Throwable)e);
        }
    }

    @Transactional
    @MethodLog
    public StorageData removeLabelsFromStorage(StorageData storageData, List<AbstractStorageLabel<?>> storageLabelList) throws BusinessException {
        try {
            for (AbstractStorageLabel<?> label : storageLabelList) {
                this.storageManager.removeLabelFromStorage(storageData, label);
            }
            return this.storageManager.getStorageData(storageData.getId());
        }
        catch (SerializationException e) {
            throw new TechnicalException("Remove labels from the storage " + storageData + ".", (IErrorCode)StorageErrorCodeEnum.SERIALIZATION_FAILED, (Throwable)e);
        }
        catch (IOException e) {
            throw new TechnicalException("Remove labels from the storage " + storageData + ".", (IErrorCode)StorageErrorCodeEnum.INPUT_OUTPUT_OPERATION_FAILED, (Throwable)e);
        }
    }

    @Transactional
    @MethodLog
    public void executeLabelManagementActions(Collection<AbstractLabelManagementAction> managementActions) throws BusinessException {
        for (AbstractLabelManagementAction managementAction : managementActions) {
            managementAction.execute((IStorageService)this);
        }
    }

    @MethodLog
    public Collection<AbstractStorageLabel<?>> getAllLabelsInStorages() {
        HashSet labels = new HashSet();
        for (StorageData storageData : this.getExistingStorages()) {
            labels.addAll(storageData.getLabelList());
        }
        return labels;
    }

    @MethodLog
    public List<AbstractStorageLabel<?>> getAllLabels() {
        return this.storageLabelDataDao.getAllLabels();
    }

    @MethodLog
    public <E> List<AbstractStorageLabel<E>> getLabelSuggestions(AbstractStorageLabelType<E> labeltype) {
        List<AbstractStorageLabel<E>> results = this.storageLabelDataDao.getAllLabelsForType(labeltype);
        return results;
    }

    @Transactional
    @MethodLog
    public void saveLabelToCmr(AbstractStorageLabel<?> storageLabel) {
        this.storageLabelDataDao.saveLabel(storageLabel);
    }

    @Transactional
    @MethodLog
    public void saveLabelsToCmr(Collection<AbstractStorageLabel<?>> storageLabels) {
        for (AbstractStorageLabel<?> label : storageLabels) {
            this.storageLabelDataDao.saveLabel(label);
        }
    }

    @Transactional
    @MethodLog
    public void removeLabelFromCmr(AbstractStorageLabel<?> storageLabel, boolean removeFromStoragesAlso) throws BusinessException {
        this.storageLabelDataDao.removeLabel(storageLabel);
        if (removeFromStoragesAlso) {
            for (StorageData storageData : this.getExistingStorages()) {
                this.removeLabelFromStorage(storageData, storageLabel);
            }
        }
    }

    @Transactional
    @MethodLog
    public void removeLabelsFromCmr(Collection<AbstractStorageLabel<?>> storageLabels, boolean removeFromStoragesAlso) throws BusinessException {
        this.storageLabelDataDao.removeLabels(storageLabels);
        if (removeFromStoragesAlso) {
            for (StorageData storageData : this.getExistingStorages()) {
                this.removeLabelsFromStorage(storageData, new ArrayList(storageLabels));
            }
        }
    }

    @Transactional
    @MethodLog
    public void saveLabelType(AbstractStorageLabelType<?> labelType) {
        this.storageLabelDataDao.saveLabelType(labelType);
    }

    @Transactional
    @MethodLog
    public void removeLabelType(AbstractStorageLabelType<?> labelType) throws BusinessException {
        this.storageLabelDataDao.removeLabelType(labelType);
    }

    @MethodLog
    public <E extends AbstractStorageLabelType<?>> List<E> getLabelTypes(Class<E> labelTypeClass) {
        return this.storageLabelDataDao.getLabelTypes(labelTypeClass);
    }

    @MethodLog
    public List<AbstractStorageLabelType<?>> getAllLabelTypes() {
        return this.storageLabelDataDao.getAllLabelTypes();
    }

    @MethodLog
    public void updateStorageData(StorageData storageData) throws BusinessException {
        try {
            this.storageManager.updateStorageData(storageData);
        }
        catch (SerializationException e) {
            throw new TechnicalException("Update data for the storage " + storageData + ".", (IErrorCode)StorageErrorCodeEnum.SERIALIZATION_FAILED, (Throwable)e);
        }
        catch (IOException e) {
            throw new TechnicalException("Update data for the storage " + storageData + ".", (IErrorCode)StorageErrorCodeEnum.INPUT_OUTPUT_OPERATION_FAILED, (Throwable)e);
        }
    }

    @MethodLog
    public long getStorageQueuedWriteTaskCount(StorageData storageData) {
        return this.storageManager.getStorageQueuedWriteTaskCount(storageData);
    }

    @MethodLog
    public void unpackUploadedStorage(IStorageData storageData) throws BusinessException {
        try {
            this.storageManager.unpackUploadedStorage(storageData);
        }
        catch (IOException e) {
            throw new TechnicalException("Un-pack uploaded data for the storage " + storageData + ".", (IErrorCode)StorageErrorCodeEnum.INPUT_OUTPUT_OPERATION_FAILED, (Throwable)e);
        }
    }

    @MethodLog
    public void createStorageFromUploadedDir(IStorageData localStorageData) throws BusinessException {
        try {
            this.storageManager.createStorageFromUploadedDir(localStorageData);
        }
        catch (SerializationException e) {
            throw new TechnicalException("Create the storage " + localStorageData + ".", (IErrorCode)StorageErrorCodeEnum.SERIALIZATION_FAILED, (Throwable)e);
        }
        catch (IOException e) {
            throw new TechnicalException("Create the storage " + localStorageData + ".", (IErrorCode)StorageErrorCodeEnum.INPUT_OUTPUT_OPERATION_FAILED, (Throwable)e);
        }
    }

    @MethodLog
    public void cacheStorageData(StorageData storageData, Collection<? extends DefaultData> data, int hash) throws BusinessException {
        if (!this.storageManager.isStorageExisting(storageData)) {
            throw new BusinessException("Data caching for the storage " + storageData + ".", (IErrorCode)StorageErrorCodeEnum.STORAGE_DOES_NOT_EXIST);
        }
        if (!this.storageManager.isStorageClosed(storageData)) {
            throw new BusinessException("Data caching for the storage " + storageData + ".", (IErrorCode)StorageErrorCodeEnum.STORAGE_IS_NOT_CLOSED);
        }
        try {
            this.storageManager.cacheStorageData((IStorageData)storageData, data, hash);
        }
        catch (SerializationException e) {
            throw new TechnicalException("Cache data for the storage " + storageData + ".", (IErrorCode)StorageErrorCodeEnum.SERIALIZATION_FAILED, (Throwable)e);
        }
        catch (IOException e) {
            throw new TechnicalException("Cache data for the storage " + storageData + ".", (IErrorCode)StorageErrorCodeEnum.INPUT_OUTPUT_OPERATION_FAILED, (Throwable)e);
        }
    }

    @MethodLog
    public String getCachedStorageDataFileLocation(StorageData storageData, int hash) throws BusinessException {
        if (!this.storageManager.isStorageExisting(storageData)) {
            throw new BusinessException("Load cached storage data files locations for storage " + storageData + ".", (IErrorCode)StorageErrorCodeEnum.STORAGE_DOES_NOT_EXIST);
        }
        return this.storageManager.getCachedStorageDataFileLocation(storageData, hash);
    }

    @PostConstruct
    public void postConstruct() throws Exception {
        if (this.log.isInfoEnabled()) {
            this.log.info("|-Storage Service active...");
        }
    }
}

