/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.service;

import info.novatec.inspectit.cmr.dao.JmxDefinitionDataIdentDao;
import info.novatec.inspectit.cmr.dao.JmxSensorTypeIdentDao;
import info.novatec.inspectit.cmr.dao.MethodIdentDao;
import info.novatec.inspectit.cmr.dao.MethodIdentToSensorTypeDao;
import info.novatec.inspectit.cmr.dao.MethodSensorTypeIdentDao;
import info.novatec.inspectit.cmr.dao.PlatformIdentDao;
import info.novatec.inspectit.cmr.dao.PlatformSensorTypeIdentDao;
import info.novatec.inspectit.cmr.model.JmxDefinitionDataIdent;
import info.novatec.inspectit.cmr.model.JmxSensorTypeIdent;
import info.novatec.inspectit.cmr.model.MethodIdent;
import info.novatec.inspectit.cmr.model.MethodIdentToSensorType;
import info.novatec.inspectit.cmr.model.MethodSensorTypeIdent;
import info.novatec.inspectit.cmr.model.PlatformIdent;
import info.novatec.inspectit.cmr.model.PlatformSensorTypeIdent;
import info.novatec.inspectit.cmr.service.IRegistrationService;
import info.novatec.inspectit.cmr.spring.aop.MethodLog;
import info.novatec.inspectit.cmr.util.AgentStatusDataProvider;
import info.novatec.inspectit.exception.BusinessException;
import info.novatec.inspectit.exception.IErrorCode;
import info.novatec.inspectit.exception.enumeration.AgentManagementErrorCodeEnum;
import info.novatec.inspectit.spring.logger.Log;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class RegistrationService
implements IRegistrationService {
    @Log
    Logger log;
    @Value(value="${cmr.ipBasedAgentRegistration}")
    boolean ipBasedAgentRegistration = true;
    @Autowired
    PlatformIdentDao platformIdentDao;
    @Autowired
    JmxDefinitionDataIdentDao jmxDefinitionDataIdentDao;
    @Autowired
    MethodIdentDao methodIdentDao;
    @Autowired
    MethodSensorTypeIdentDao methodSensorTypeIdentDao;
    @Autowired
    PlatformSensorTypeIdentDao platformSensorTypeIdentDao;
    @Autowired
    JmxSensorTypeIdentDao jmxSensorTypeIdentDao;
    @Autowired
    MethodIdentToSensorTypeDao methodIdentToSensorTypeDao;
    @Autowired
    AgentStatusDataProvider agentStatusDataProvider;

    @MethodLog
    public synchronized long registerPlatformIdent(List<String> definedIPs, String agentName, String version) throws BusinessException {
        if (this.log.isInfoEnabled()) {
            this.log.info("Trying to register Agent '" + agentName + "'");
        }
        List<PlatformIdent> platformIdentResults = this.ipBasedAgentRegistration ? this.platformIdentDao.findByNameAndIps(agentName, definedIPs) : this.platformIdentDao.findByName(agentName);
        PlatformIdent platformIdent = new PlatformIdent();
        platformIdent.setAgentName(agentName);
        if (1 == platformIdentResults.size()) {
            platformIdent = platformIdentResults.get(0);
        } else if (platformIdentResults.size() > 1) {
            this.log.error("More than one platform ident has been retrieved! Please send your Database to the NovaTec inspectIT support!");
            throw new BusinessException("Register the agent with name " + agentName + " and following network interfaces " + definedIPs + ".", (IErrorCode)AgentManagementErrorCodeEnum.MORE_THAN_ONE_AGENT_REGISTERED);
        }
        platformIdent.setTimeStamp(new Timestamp(GregorianCalendar.getInstance().getTimeInMillis()));
        platformIdent.setDefinedIPs(definedIPs);
        platformIdent.setVersion(version);
        this.platformIdentDao.saveOrUpdate(platformIdent);
        this.agentStatusDataProvider.registerConnected(platformIdent.getId());
        if (this.log.isInfoEnabled()) {
            this.log.info("Successfully registered the Agent '" + agentName + "' with id " + platformIdent.getId() + ", version " + version + " and following network interfaces:");
            this.printOutDefinedIPs(definedIPs);
        }
        return platformIdent.getId();
    }

    @MethodLog
    public void unregisterPlatformIdent(List<String> definedIPs, String agentName) throws BusinessException {
        this.log.info("Trying to unregister the Agent with following network interfaces:");
        this.printOutDefinedIPs(definedIPs);
        List<PlatformIdent> platformIdentResults = this.platformIdentDao.findByNameAndIps(agentName, definedIPs);
        if (1 != platformIdentResults.size()) {
            if (platformIdentResults.size() > 1) {
                this.log.error("More than one platform ident has been retrieved! Please send your Database to the NovaTec inspectIT support!");
                throw new BusinessException("Unregister the agent with name " + agentName + " and following network interfaces " + definedIPs + ".", (IErrorCode)AgentManagementErrorCodeEnum.MORE_THAN_ONE_AGENT_REGISTERED);
            }
            this.log.warn("No registered agent with given network interfaces exists. Unregistration is aborted.");
            throw new BusinessException("Unregister the agent with name " + agentName + " and following network interfaces " + definedIPs + ".", (IErrorCode)AgentManagementErrorCodeEnum.AGENT_DOES_NOT_EXIST);
        }
        PlatformIdent platformIdent = platformIdentResults.get(0);
        this.agentStatusDataProvider.registerDisconnected(platformIdent.getId());
        this.log.info("The Agent '" + platformIdent.getAgentName() + "' has been successfully unregistered.");
    }

    @MethodLog
    public long registerMethodIdent(long platformId, String packageName, String className, String methodName, List<String> parameterTypes, String returnType, int modifiers) {
        MethodIdent methodIdent = new MethodIdent();
        methodIdent.setPackageName(packageName);
        methodIdent.setClassName(className);
        methodIdent.setMethodName(methodName);
        if (null == parameterTypes) {
            parameterTypes = Collections.emptyList();
        }
        methodIdent.setParameters(parameterTypes);
        methodIdent.setReturnType(returnType);
        methodIdent.setModifiers(modifiers);
        List<MethodIdent> methodIdents = this.methodIdentDao.findForPlatformIdAndExample(platformId, methodIdent);
        if (1 == methodIdents.size()) {
            methodIdent = methodIdents.get(0);
        } else {
            PlatformIdent platformIdent = this.platformIdentDao.load(platformId);
            methodIdent.setPlatformIdent(platformIdent);
        }
        methodIdent.setTimeStamp(new Timestamp(GregorianCalendar.getInstance().getTimeInMillis()));
        this.methodIdentDao.saveOrUpdate(methodIdent);
        return methodIdent.getId();
    }

    @MethodLog
    public long registerMethodSensorTypeIdent(long platformId, String fullyQualifiedClassName, Map<String, Object> parameters) {
        MethodSensorTypeIdent methodSensorTypeIdent;
        List<MethodSensorTypeIdent> methodSensorTypeIdents = this.methodSensorTypeIdentDao.findByClassNameAndPlatformId(fullyQualifiedClassName, platformId);
        if (1 == methodSensorTypeIdents.size()) {
            methodSensorTypeIdent = methodSensorTypeIdents.get(0);
            methodSensorTypeIdent.setSettings(parameters);
            this.methodSensorTypeIdentDao.saveOrUpdate(methodSensorTypeIdent);
        } else {
            PlatformIdent platformIdent = this.platformIdentDao.load(platformId);
            methodSensorTypeIdent = new MethodSensorTypeIdent();
            methodSensorTypeIdent.setPlatformIdent(platformIdent);
            methodSensorTypeIdent.setFullyQualifiedClassName(fullyQualifiedClassName);
            methodSensorTypeIdent.setSettings(parameters);
            Set sensorTypeIdents = platformIdent.getSensorTypeIdents();
            sensorTypeIdents.add(methodSensorTypeIdent);
            this.methodSensorTypeIdentDao.saveOrUpdate(methodSensorTypeIdent);
            this.platformIdentDao.saveOrUpdate(platformIdent);
        }
        return methodSensorTypeIdent.getId();
    }

    @MethodLog
    public void addSensorTypeToMethod(long methodSensorTypeId, long methodId) {
        MethodIdentToSensorType methodIdentToSensorType = this.methodIdentToSensorTypeDao.find(methodId, methodSensorTypeId);
        if (null == methodIdentToSensorType) {
            MethodIdent methodIdent = this.methodIdentDao.load(methodId);
            MethodSensorTypeIdent methodSensorTypeIdent = this.methodSensorTypeIdentDao.load(methodSensorTypeId);
            methodIdentToSensorType = new MethodIdentToSensorType(methodIdent, methodSensorTypeIdent, null);
        }
        methodIdentToSensorType.setTimestamp(new Timestamp(GregorianCalendar.getInstance().getTimeInMillis()));
        this.methodIdentToSensorTypeDao.saveOrUpdate(methodIdentToSensorType);
    }

    @MethodLog
    public long registerPlatformSensorTypeIdent(long platformId, String fullyQualifiedClassName) {
        PlatformSensorTypeIdent platformSensorTypeIdent;
        List<PlatformSensorTypeIdent> platformSensorTypeIdents = this.platformSensorTypeIdentDao.findByClassNameAndPlatformId(fullyQualifiedClassName, platformId);
        if (1 == platformSensorTypeIdents.size()) {
            platformSensorTypeIdent = platformSensorTypeIdents.get(0);
        } else {
            PlatformIdent platformIdent = this.platformIdentDao.load(platformId);
            platformSensorTypeIdent = new PlatformSensorTypeIdent();
            platformSensorTypeIdent.setPlatformIdent(platformIdent);
            platformSensorTypeIdent.setFullyQualifiedClassName(fullyQualifiedClassName);
            Set sensorTypeIdents = platformIdent.getSensorTypeIdents();
            sensorTypeIdents.add(platformSensorTypeIdent);
            this.platformSensorTypeIdentDao.saveOrUpdate(platformSensorTypeIdent);
            this.platformIdentDao.saveOrUpdate(platformIdent);
        }
        return platformSensorTypeIdent.getId();
    }

    @Transactional
    @MethodLog
    public long registerJmxSensorTypeIdent(long platformId, String fullyQualifiedClassName) {
        JmxSensorTypeIdent jmxSensorTypeIdent = new JmxSensorTypeIdent();
        jmxSensorTypeIdent.setFullyQualifiedClassName(fullyQualifiedClassName);
        List<JmxSensorTypeIdent> jmxSensorTypeIdents = this.jmxSensorTypeIdentDao.findByExample(platformId, jmxSensorTypeIdent);
        if (1 == jmxSensorTypeIdents.size()) {
            jmxSensorTypeIdent = jmxSensorTypeIdents.get(0);
        } else {
            PlatformIdent platformIdent = this.platformIdentDao.load(platformId);
            jmxSensorTypeIdent.setPlatformIdent(platformIdent);
            Set sensorTypeIdents = platformIdent.getSensorTypeIdents();
            sensorTypeIdents.add(jmxSensorTypeIdent);
            this.jmxSensorTypeIdentDao.saveOrUpdate(jmxSensorTypeIdent);
            this.platformIdentDao.saveOrUpdate(platformIdent);
        }
        return jmxSensorTypeIdent.getId();
    }

    @Transactional
    @MethodLog
    public long registerJmxSensorDefinitionDataIdent(long platformId, String mBeanObjectName, String mBeanAttributeName, String mBeanAttributeDescription, String mBeanAttributeType, boolean isIs, boolean isReadable, boolean isWritable) {
        JmxDefinitionDataIdent jmxDefinitionDataIdent = new JmxDefinitionDataIdent();
        jmxDefinitionDataIdent.setmBeanObjectName(mBeanObjectName);
        jmxDefinitionDataIdent.setmBeanAttributeName(mBeanAttributeName);
        jmxDefinitionDataIdent.setmBeanAttributeDescription(mBeanAttributeDescription);
        jmxDefinitionDataIdent.setmBeanAttributeType(mBeanAttributeType);
        jmxDefinitionDataIdent.setmBeanAttributeIsIs(Boolean.valueOf(isIs));
        jmxDefinitionDataIdent.setmBeanAttributeIsReadable(Boolean.valueOf(isReadable));
        jmxDefinitionDataIdent.setmBeanAttributeIsWritable(Boolean.valueOf(isWritable));
        List<JmxDefinitionDataIdent> jmxDefinitionDataIdents = this.jmxDefinitionDataIdentDao.findForPlatformIdent(platformId, jmxDefinitionDataIdent);
        if (1 == jmxDefinitionDataIdents.size()) {
            jmxDefinitionDataIdent = jmxDefinitionDataIdents.get(0);
        } else {
            PlatformIdent platformIdent = this.platformIdentDao.load(platformId);
            jmxDefinitionDataIdent.setPlatformIdent(platformIdent);
        }
        jmxDefinitionDataIdent.setTimeStamp(new Timestamp(GregorianCalendar.getInstance().getTimeInMillis()));
        this.jmxDefinitionDataIdentDao.saveOrUpdate(jmxDefinitionDataIdent);
        return jmxDefinitionDataIdent.getId();
    }

    private void printOutDefinedIPs(List<String> definedIPs) {
        ArrayList<String> ipList = new ArrayList<String>();
        for (String ip : definedIPs) {
            if (ip.indexOf(58) != -1) {
                ipList.add("|- IPv6: " + ip);
                continue;
            }
            ipList.add("|- IPv4: " + ip);
        }
        Collections.sort(ipList);
        for (String ip : ipList) {
            this.log.info(ip);
        }
    }

    @PostConstruct
    public void postConstruct() {
        if (this.log.isInfoEnabled()) {
            this.log.info("|-Registration Service active...");
        }
    }
}

