/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.service;

import info.novatec.inspectit.cmr.dao.ExceptionSensorDataDao;
import info.novatec.inspectit.cmr.service.ICachedDataService;
import info.novatec.inspectit.cmr.service.IExceptionDataAccessService;
import info.novatec.inspectit.cmr.spring.aop.MethodLog;
import info.novatec.inspectit.communication.comparator.ResultComparator;
import info.novatec.inspectit.communication.data.AggregatedExceptionSensorData;
import info.novatec.inspectit.communication.data.ExceptionSensorData;
import info.novatec.inspectit.spring.logger.Log;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExceptionDataAccessService
implements IExceptionDataAccessService {
    @Log
    Logger log;
    @Autowired
    private ExceptionSensorDataDao exceptionSensorDataDao;
    @Autowired
    private ICachedDataService cachedDataService;

    @MethodLog
    public List<ExceptionSensorData> getUngroupedExceptionOverview(ExceptionSensorData template, int limit, ResultComparator<ExceptionSensorData> resultComparator) {
        if (null != resultComparator) {
            resultComparator.setCachedDataService(this.cachedDataService);
        }
        List<ExceptionSensorData> result = this.exceptionSensorDataDao.getUngroupedExceptionOverview(template, limit, (Comparator<? super ExceptionSensorData>)resultComparator);
        return result;
    }

    @MethodLog
    public List<ExceptionSensorData> getUngroupedExceptionOverview(ExceptionSensorData template, int limit, Date fromDate, Date toDate, ResultComparator<ExceptionSensorData> resultComparator) {
        if (null != resultComparator) {
            resultComparator.setCachedDataService(this.cachedDataService);
        }
        List<ExceptionSensorData> result = this.exceptionSensorDataDao.getUngroupedExceptionOverview(template, limit, fromDate, toDate, (Comparator<? super ExceptionSensorData>)resultComparator);
        return result;
    }

    @MethodLog
    public List<ExceptionSensorData> getUngroupedExceptionOverview(ExceptionSensorData template, ResultComparator<ExceptionSensorData> resultComparator) {
        if (null != resultComparator) {
            resultComparator.setCachedDataService(this.cachedDataService);
        }
        List<ExceptionSensorData> result = this.exceptionSensorDataDao.getUngroupedExceptionOverview(template, (Comparator<? super ExceptionSensorData>)resultComparator);
        return result;
    }

    @MethodLog
    public List<ExceptionSensorData> getUngroupedExceptionOverview(ExceptionSensorData template, Date fromDate, Date toDate, ResultComparator<ExceptionSensorData> resultComparator) {
        if (null != resultComparator) {
            resultComparator.setCachedDataService(this.cachedDataService);
        }
        List<ExceptionSensorData> result = this.exceptionSensorDataDao.getUngroupedExceptionOverview(template, fromDate, toDate, (Comparator<? super ExceptionSensorData>)resultComparator);
        return result;
    }

    @MethodLog
    public List<ExceptionSensorData> getExceptionTree(ExceptionSensorData template) {
        List<ExceptionSensorData> result = this.exceptionSensorDataDao.getExceptionTree(template);
        return result;
    }

    @MethodLog
    public List<AggregatedExceptionSensorData> getDataForGroupedExceptionOverview(ExceptionSensorData template) {
        List<AggregatedExceptionSensorData> result = this.exceptionSensorDataDao.getDataForGroupedExceptionOverview(template);
        return result;
    }

    @MethodLog
    public List<AggregatedExceptionSensorData> getDataForGroupedExceptionOverview(ExceptionSensorData template, Date fromDate, Date toDate) {
        List<AggregatedExceptionSensorData> result = this.exceptionSensorDataDao.getDataForGroupedExceptionOverview(template, fromDate, toDate);
        return result;
    }

    @MethodLog
    public List<ExceptionSensorData> getStackTraceMessagesForThrowableType(ExceptionSensorData template) {
        List<ExceptionSensorData> result = this.exceptionSensorDataDao.getStackTraceMessagesForThrowableType(template);
        return result;
    }

    @PostConstruct
    public void postConstruct() throws Exception {
        if (this.log.isInfoEnabled()) {
            this.log.info("|-Exception Sensor Data Access Service active...");
        }
    }
}

