/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.rmi;

import info.novatec.inspectit.kryonet.Connection;
import info.novatec.inspectit.kryonet.ExtendedSerializationImpl;
import info.novatec.inspectit.kryonet.IExtendedSerialization;
import info.novatec.inspectit.kryonet.Listener;
import info.novatec.inspectit.kryonet.Server;
import info.novatec.inspectit.kryonet.rmi.ObjectSpace;
import info.novatec.inspectit.spring.logger.Log;
import info.novatec.inspectit.storage.nio.stream.StreamProvider;
import info.novatec.inspectit.storage.serializer.ISerializerProvider;
import info.novatec.inspectit.storage.serializer.provider.SerializationManagerProvider;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@Configuration
public class KryoNetServerCreator {
    @Log
    Logger log;
    @Value(value="${cmr.port}")
    private int port;
    @Autowired
    private SerializationManagerProvider serializationManagerProvider;
    @Autowired
    private StreamProvider streamProvider;
    @Autowired
    @Qualifier(value="kryoNetObjectSpaceExecutorService")
    private ExecutorService executorService;

    @Bean(name={"kryonet-server"}, destroyMethod="stop")
    public Server createServer() {
        ExtendedSerializationImpl serialization = new ExtendedSerializationImpl((ISerializerProvider)this.serializationManagerProvider);
        Server server = new Server((IExtendedSerialization)serialization, this.streamProvider);
        server.start();
        try {
            server.bind(this.port);
            this.log.info("|-Kryonet server successfully started and running on port " + this.port);
        }
        catch (IOException e) {
            throw new BeanInitializationException("Could not bind the kryonet server to the specified ports.", (Throwable)e);
        }
        return server;
    }

    @Bean(name={"kryonet-server-objectspace"})
    @DependsOn(value={"kryonet-server"})
    @Autowired
    public ObjectSpace createObjectSpace(Server server) {
        final ObjectSpace objectSpace = new ObjectSpace();
        objectSpace.setExecutor((Executor)this.executorService);
        server.addListener(new Listener(){

            public void connected(Connection connection) {
                objectSpace.addConnection(connection);
            }
        });
        return objectSpace;
    }
}

