/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.processor.impl;

import info.novatec.inspectit.cmr.processor.AbstractCmrDataProcessor;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.communication.data.InvocationAwareData;
import info.novatec.inspectit.indexing.buffer.IBufferTreeComponent;
import info.novatec.inspectit.indexing.impl.IndexingException;
import info.novatec.inspectit.spring.logger.Log;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class IndexerCmrProcessor
extends AbstractCmrDataProcessor {
    @Log
    Logger log;
    @Autowired
    IBufferTreeComponent<DefaultData> indexingTree;

    @Override
    protected void processData(DefaultData defaultData, EntityManager entityManager) {
        try {
            this.indexingTree.put((Object)defaultData);
        }
        catch (IndexingException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean canBeProcessed(DefaultData defaultData) {
        if (null != defaultData) {
            return defaultData instanceof InvocationAwareData && ((InvocationAwareData)defaultData).isOnlyFoundInInvocations();
        }
        return false;
    }

    public void setIndexingTree(IBufferTreeComponent<DefaultData> indexingTree) {
        this.indexingTree = indexingTree;
    }
}

