/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.processor;

import info.novatec.inspectit.cmr.processor.AbstractCmrDataProcessor;
import info.novatec.inspectit.communication.DefaultData;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;

public abstract class AbstractChainedCmrDataProcessor
extends AbstractCmrDataProcessor {
    private List<AbstractCmrDataProcessor> dataProcessors;

    public AbstractChainedCmrDataProcessor() {
        this.dataProcessors = new ArrayList<AbstractCmrDataProcessor>();
    }

    public AbstractChainedCmrDataProcessor(List<AbstractCmrDataProcessor> dataProcessors) {
        this.dataProcessors = dataProcessors;
    }

    protected abstract boolean shouldBePassedToChainedProcessors(DefaultData var1);

    @Override
    protected void processData(DefaultData defaultData, EntityManager entityManager) {
        if (this.shouldBePassedToChainedProcessors(defaultData)) {
            this.passToChainedProcessors(defaultData, entityManager);
        }
    }

    protected void passToChainedProcessors(DefaultData defaultData, EntityManager entityManager) {
        if (null != this.dataProcessors) {
            for (AbstractCmrDataProcessor dataProcessor : this.dataProcessors) {
                dataProcessor.process(defaultData, entityManager);
            }
        }
    }
}

