/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.jaxb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public class JAXBTransformator {
    public void marshall(Path path, Object object, String noNamespaceSchemaLocation) throws JAXBException, IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            throw new IOException("Can not marshal object to the path that represents the directory");
        }
        Files.deleteIfExists(path);
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{object.getClass()});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        if (null != noNamespaceSchemaLocation) {
            marshaller.setProperty("jaxb.noNamespaceSchemaLocation", (Object)noNamespaceSchemaLocation);
        }
        try (OutputStream outputStream = Files.newOutputStream(path, StandardOpenOption.CREATE_NEW);){
            marshaller.marshal(object, outputStream);
        }
    }

    public <T> T unmarshall(Path path, Path schemaPath, Class<T> rootClass) throws JAXBException, IOException, SAXException {
        Object object;
        if (Files.notExists(path, new LinkOption[0]) || Files.isDirectory(path, new LinkOption[0])) {
            return null;
        }
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{rootClass});
        Unmarshaller unmarshaller = context.createUnmarshaller();
        if (null != schemaPath && Files.exists(schemaPath, new LinkOption[0])) {
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            InputStream inputStream = Files.newInputStream(schemaPath, StandardOpenOption.READ);
            object = null;
            try {
                Schema schema = sf.newSchema(new StreamSource(inputStream));
                unmarshaller.setSchema(schema);
            }
            catch (Throwable x2) {
                object = x2;
                throw x2;
            }
            finally {
                if (inputStream != null) {
                    if (object != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable x2) {
                            ((Throwable)object).addSuppressed(x2);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
        }
        try (InputStream inputStream = Files.newInputStream(path, StandardOpenOption.READ);){
            object = unmarshaller.unmarshal(inputStream);
            return (T)object;
        }
    }
}

