/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.dao.impl;

import info.novatec.inspectit.cmr.dao.PlatformIdentDao;
import info.novatec.inspectit.cmr.dao.impl.AbstractJpaDao;
import info.novatec.inspectit.cmr.model.PlatformIdent;
import info.novatec.inspectit.cmr.util.PlatformIdentCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class PlatformIdentDaoImpl
extends AbstractJpaDao<PlatformIdent>
implements PlatformIdentDao {
    @Autowired
    private PlatformIdentCache platformIdentCache;

    public PlatformIdentDaoImpl() {
        super(PlatformIdent.class);
    }

    @Override
    public void delete(PlatformIdent platformIdent) {
        super.delete(platformIdent);
        this.platformIdentCache.remove(platformIdent);
    }

    @Override
    public void deleteAll(List<PlatformIdent> platformIdents) {
        for (PlatformIdent platformIdent : platformIdents) {
            this.delete(platformIdent);
        }
    }

    @Override
    public List<PlatformIdent> findAll() {
        return this.getEntityManager().createNamedQuery("PlatformIdent.findAll", PlatformIdent.class).getResultList();
    }

    @Override
    public List<PlatformIdent> findByName(String agentName) {
        return this.findByNameAndIps(agentName, null);
    }

    @Override
    public List<PlatformIdent> findByNameAndIps(String agentName, List<String> definedIps) {
        TypedQuery query = this.getEntityManager().createNamedQuery("PlatformIdent.findByAgentName", PlatformIdent.class);
        query.setParameter("agentName", (Object)agentName);
        List results = query.getResultList();
        if (null != definedIps) {
            Iterator it = results.iterator();
            while (it.hasNext()) {
                PlatformIdent platformIdent = (PlatformIdent)it.next();
                if (Objects.equals(definedIps, platformIdent.getDefinedIPs())) continue;
                it.remove();
            }
        }
        return results;
    }

    @Override
    public void saveOrUpdate(PlatformIdent platformIdent) {
        int maxDefIPsSize = 1024;
        if (null != platformIdent.getDefinedIPs()) {
            String item;
            int charNum = 0;
            ArrayList<String> newDefinedIPs = new ArrayList<String>();
            Iterator i$ = platformIdent.getDefinedIPs().iterator();
            while (i$.hasNext() && charNum + (item = (String)i$.next()).length() <= 1024) {
                newDefinedIPs.add(item);
                charNum += item.length() + 1;
            }
            if (newDefinedIPs.size() != platformIdent.getDefinedIPs().size()) {
                platformIdent.setDefinedIPs(newDefinedIPs);
            }
        }
        if (null == platformIdent.getId()) {
            super.create(platformIdent);
        } else {
            super.update(platformIdent);
        }
        this.platformIdentCache.markDirty(platformIdent);
    }

    @Override
    public PlatformIdent findInitialized(long id) {
        for (PlatformIdent platformIdent : this.platformIdentCache.getCleanPlatformIdents()) {
            if (platformIdent.getId() != id) continue;
            return platformIdent;
        }
        List<PlatformIdent> cleanPlatformIdents = this.loadIdentsFromDB(Collections.emptyList(), Collections.singleton(id));
        if (CollectionUtils.isNotEmpty(cleanPlatformIdents)) {
            if (1 == cleanPlatformIdents.size()) {
                return cleanPlatformIdents.get(0);
            }
            throw new RuntimeException("More than one agent retrieved for one ID.");
        }
        return null;
    }

    public List<PlatformIdent> findAllInitialized(Set<Long> wantedAgentsIds) {
        if (null == wantedAgentsIds) {
            return Collections.emptyList();
        }
        ArrayList<PlatformIdent> initializedPlatformIdents = new ArrayList<PlatformIdent>();
        ArrayList<Long> cleanIdents = new ArrayList<Long>();
        for (PlatformIdent platformIdent : this.platformIdentCache.getCleanPlatformIdents()) {
            cleanIdents.add(platformIdent.getId());
            if (!wantedAgentsIds.contains(platformIdent.getId())) continue;
            initializedPlatformIdents.add(platformIdent);
        }
        wantedAgentsIds.removeAll(cleanIdents);
        if (cleanIdents.size() != this.platformIdentCache.getSize()) {
            List<PlatformIdent> cleanPlatformIdents = this.loadIdentsFromDB(cleanIdents, wantedAgentsIds);
            for (PlatformIdent platformIdent : cleanPlatformIdents) {
                if (!wantedAgentsIds.contains(platformIdent.getId())) continue;
                initializedPlatformIdents.add(platformIdent);
            }
        }
        Collections.sort(initializedPlatformIdents, new Comparator<PlatformIdent>(){

            @Override
            public int compare(PlatformIdent o1, PlatformIdent o2) {
                return (int)(o1.getId() - o2.getId());
            }
        });
        return initializedPlatformIdents;
    }

    @PostConstruct
    public void postConstruct() {
        this.loadIdentsFromDB(Collections.emptyList(), Collections.emptyList());
    }

    private List<PlatformIdent> loadIdentsFromDB(Collection<Long> excludeIdents, Collection<Long> includeIdents) {
        StringBuilder gl = new StringBuilder("select distinct platformIdent from PlatformIdent as platformIdent left join fetch platformIdent.methodIdents methodIdent left join fetch platformIdent.jmxDefinitionDataIdents jmxDefinitionDataIdents left join fetch platformIdent.sensorTypeIdents left join fetch methodIdent.methodIdentToSensorTypes");
        if (CollectionUtils.isNotEmpty(includeIdents) && CollectionUtils.isNotEmpty(excludeIdents)) {
            gl.append(" where platformIdent.id in :includeIdents and platformIdent.id not in :excludeIdents");
        } else if (CollectionUtils.isNotEmpty(includeIdents)) {
            gl.append(" where platformIdent.id in :includeIdents");
        } else if (CollectionUtils.isNotEmpty(excludeIdents)) {
            gl.append(" where platformIdent.id not in :excludeIdents");
        }
        Query query = this.getEntityManager().createQuery(gl.toString());
        if (CollectionUtils.isNotEmpty(includeIdents)) {
            query.setParameter("includeIdents", includeIdents);
        }
        if (CollectionUtils.isNotEmpty(excludeIdents)) {
            query.setParameter("excludeIdents", excludeIdents);
        }
        List platformIdents = query.getResultList();
        for (PlatformIdent platformIdent : platformIdents) {
            this.platformIdentCache.markClean(platformIdent);
        }
        return platformIdents;
    }
}

