/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.cache.impl;

import info.novatec.inspectit.cmr.cache.IBufferElement;
import info.novatec.inspectit.cmr.cache.impl.AbstractBufferElementProcessor;
import info.novatec.inspectit.cmr.cache.impl.AtomicBuffer;
import info.novatec.inspectit.cmr.util.Converter;
import info.novatec.inspectit.communication.DefaultData;
import info.novatec.inspectit.indexing.impl.IndexingException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

class IndexBufferElementProcessor<E extends DefaultData>
extends AbstractBufferElementProcessor<E> {
    public IndexBufferElementProcessor(AtomicBuffer<E> atomicBuffer, AtomicReference<IBufferElement<E>> lastProcessed, Lock lock, Condition condition) {
        super(atomicBuffer, lastProcessed, lock, condition);
    }

    @Override
    public void process() throws InterruptedException {
        long dataRemoveInBytesCurrent;
        super.process();
        while ((dataRemoveInBytesCurrent = this.atomicBuffer.dataRemovedInBytes.get()) > this.atomicBuffer.flagsSetOnBytes) {
            if (!this.atomicBuffer.dataRemovedInBytes.compareAndSet(dataRemoveInBytesCurrent, 0L)) continue;
            long time = 0L;
            if (this.atomicBuffer.log.isDebugEnabled()) {
                time = System.nanoTime();
            }
            this.atomicBuffer.indexingTree.cleanWithRunnable(this.atomicBuffer.indexingTreeCleaningExecutorService);
            if (!this.atomicBuffer.log.isDebugEnabled()) break;
            this.atomicBuffer.log.debug("Indexing tree cleaning duration: " + Converter.nanoToMilliseconds(System.nanoTime() - time));
            break;
        }
    }

    @Override
    public boolean process(IBufferElement<E> elementToProcess, IBufferElement<E> lastProcessedElement) {
        if (!elementToProcess.isAnalyzed()) {
            try {
                Thread.sleep(this.atomicBuffer.bufferProperties.getIndexingWaitTime());
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
            return false;
        }
        if (this.lastProcessed.compareAndSet(lastProcessedElement, elementToProcess)) {
            try {
                this.atomicBuffer.indexingTree.put(elementToProcess.getObject());
                elementToProcess.setBufferElementState(IBufferElement.BufferElementState.INDEXED);
                this.atomicBuffer.elementsIndexed.incrementAndGet();
                long dataAddedInBytesCurrent = this.atomicBuffer.dataAddedInBytes.get();
                if (dataAddedInBytesCurrent > this.atomicBuffer.flagsSetOnBytes && this.atomicBuffer.dataAddedInBytes.compareAndSet(dataAddedInBytesCurrent, 0L)) {
                    long newSize;
                    long oldSize;
                    long time = 0L;
                    if (this.atomicBuffer.log.isDebugEnabled()) {
                        time = System.nanoTime();
                    }
                    do {
                        newSize = this.atomicBuffer.indexingTree.getComponentSize(this.atomicBuffer.objectSizes);
                        newSize = (long)((float)newSize + (float)newSize * this.atomicBuffer.objectSizes.getObjectSecurityExpansionRate());
                    } while (!this.atomicBuffer.indexingTreeSize.compareAndSet(oldSize = this.atomicBuffer.indexingTreeSize.get(), newSize));
                    this.atomicBuffer.addToCurrentSize(newSize - oldSize, false);
                    if (this.atomicBuffer.log.isDebugEnabled()) {
                        this.atomicBuffer.log.debug("Indexing tree size update duration: " + Converter.nanoToMilliseconds(System.nanoTime() - time));
                        this.atomicBuffer.log.debug("Indexing tree delta: " + (newSize - oldSize));
                        this.atomicBuffer.log.debug("Indexing tree new size: " + newSize);
                    }
                }
            }
            catch (IndexingException e) {
                this.atomicBuffer.log.error(e.getMessage(), (Throwable)e);
            }
            return true;
        }
        return false;
    }
}

