/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.cache.impl;

import info.novatec.inspectit.cmr.cache.IBufferElement;
import info.novatec.inspectit.cmr.cache.impl.AtomicBuffer;
import info.novatec.inspectit.communication.DefaultData;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;

abstract class AbstractBufferElementProcessor<E extends DefaultData> {
    protected final AtomicBuffer<E> atomicBuffer;
    protected AtomicReference<IBufferElement<E>> lastProcessed;
    private Lock lock;
    private Condition condition;

    public AbstractBufferElementProcessor(AtomicBuffer<E> atomicBuffer, AtomicReference<IBufferElement<E>> lastProcessed, Lock lock, Condition condition) {
        this.atomicBuffer = atomicBuffer;
        this.lastProcessed = lastProcessed;
        this.lock = lock;
        this.condition = condition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() throws InterruptedException {
        while (true) {
            IBufferElement<E> lastProcessedElement = this.lastProcessed.get();
            if (this.atomicBuffer.emptyBufferElement != this.atomicBuffer.last.get() && (this.atomicBuffer.emptyBufferElement == lastProcessedElement || this.atomicBuffer.emptyBufferElement != lastProcessedElement.getNextElement())) break;
            this.lock.lock();
            try {
                lastProcessedElement = this.atomicBuffer.lastAnalyzed.get();
                if (this.atomicBuffer.emptyBufferElement != this.atomicBuffer.last.get() && (this.atomicBuffer.emptyBufferElement == lastProcessedElement || this.atomicBuffer.emptyBufferElement != lastProcessedElement.getNextElement())) break;
                this.condition.await();
                continue;
            }
            finally {
                this.lock.unlock();
                continue;
            }
            break;
        }
        while (true) {
            this.atomicBuffer.clearReadLock.lock();
            try {
                IBufferElement<E> elementToProcess = null;
                IBufferElement<E> lastProcessElement = this.lastProcessed.get();
                elementToProcess = this.atomicBuffer.emptyBufferElement == lastProcessElement ? this.atomicBuffer.last.get() : lastProcessElement.getNextElement();
                if (this.atomicBuffer.emptyBufferElement != elementToProcess && !this.process(elementToProcess, lastProcessElement)) continue;
            }
            finally {
                this.atomicBuffer.clearReadLock.unlock();
                continue;
            }
            break;
        }
    }

    public abstract boolean process(IBufferElement<E> var1, IBufferElement<E> var2);
}

