/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr.cache;

import info.novatec.inspectit.cmr.cache.AbstractObjectSizes;

public abstract class AbstractObjectSizesIbm
extends AbstractObjectSizes {
    @Override
    public long getPrimitiveTypesSize(int referenceCount, int booleanCount, int intCount, int floatCount, int longCount, int doubleCount) {
        return super.getPrimitiveTypesSize(referenceCount, 0, intCount + booleanCount, floatCount, longCount, doubleCount);
    }

    @Override
    public long getSizeOfArray(int arraySize) {
        long size = this.getSizeOfObjectHeader();
        return this.alignTo8Bytes(size += this.getPrimitiveTypesSize(arraySize, 0, 0, 0, 0, 0));
    }

    @Override
    public long getSizeOfPrimitiveArray(int arraySize, long primitiveSize) {
        long size = this.getSizeOfObjectHeader();
        return this.alignTo8Bytes(size += (long)arraySize * primitiveSize);
    }

    @Override
    public long getSizeOfHashSet(int hashSetSize, int initialCapacity) {
        long size = this.getSizeOfObjectHeader();
        size += this.getPrimitiveTypesSize(1, 0, 0, 0, 0, 0);
        return this.alignTo8Bytes(size += this.getSizeOfHashMap(hashSetSize, initialCapacity));
    }

    @Override
    public long alignTo8Bytes(long size) {
        long s = super.alignTo8Bytes(size);
        if (size < 16L) {
            return 16L;
        }
        return s;
    }

    @Override
    public int getHashMapCapacityFromSize(int hashMapSize, int initialCapacity) {
        return super.getHashMapCapacityFromSize(hashMapSize, AbstractObjectSizesIbm.calculateHashMapCapacity(initialCapacity));
    }

    private static int calculateHashMapCapacity(int specifiedCapacity) {
        int capacity;
        for (capacity = 1; capacity < specifiedCapacity; capacity <<= 1) {
        }
        return capacity;
    }

    @Override
    protected int getNumberOfConcurrentSegments(int mapSize, int concurrencyLevel) {
        int segments;
        for (segments = 1; segments < concurrencyLevel; segments <<= 1) {
        }
        return segments;
    }

    @Override
    protected long getSizeOfConcurrentSeqment(int seqmentCapacity) {
        long size = super.getSizeOfConcurrentSeqment(seqmentCapacity);
        return this.alignTo8Bytes(size += this.getPrimitiveTypesSize(1, 0, 0, 0, 0, 0));
    }

    @Override
    protected int getSegmentCapacityFromSize(int seqmentSize, int initialCapacity) {
        int capacity = initialCapacity;
        float loadFactor = 0.75f;
        int threshold = (int)((float)capacity * loadFactor);
        while (threshold + 1 < seqmentSize) {
            threshold = (int)((float)(capacity <<= 1) * loadFactor);
        }
        return capacity;
    }
}

