/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.cmr;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import info.novatec.inspectit.cmr.util.Converter;
import info.novatec.inspectit.minlog.MinlogToSLF4JLogger;
import info.novatec.inspectit.version.VersionService;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.access.BeanFactoryLocator;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.access.ContextSingletonBeanFactoryLocator;
import uk.org.lidalia.sysoutslf4j.context.SysOutOverSLF4J;

public final class CMR {
    private static final Logger LOGGER = LoggerFactory.getLogger(CMR.class);
    public static final String DEFAULT_LOG_FILE_NAME = "logging-config.xml";
    private static final String LOG_FILE_PROPERTY = "inspectit.logging.config";
    private static BeanFactory beanFactory;
    private static boolean startedAsService;

    private CMR() {
    }

    private static void startCMR() {
        CMR.initLogger();
        long startTime = System.nanoTime();
        LOGGER.info("Central Measurement Repository is starting up!");
        LOGGER.info("==============================================");
        CMR.startRepository();
        LOGGER.info("CMR started in " + Converter.nanoToMilliseconds(System.nanoTime() - startTime) + " ms");
    }

    private static void startRepository() {
        CMR.checkForCorrectJvmVersion();
        LOGGER.info("Initializing Spring...");
        BeanFactoryLocator beanFactoryLocator = ContextSingletonBeanFactoryLocator.getInstance();
        BeanFactoryReference beanFactoryReference = beanFactoryLocator.useBeanFactory("ctx");
        beanFactory = beanFactoryReference.getFactory();
        if (beanFactory instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)beanFactory).registerShutdownHook();
        }
        LOGGER.info("Spring successfully initialized");
        if (LOGGER.isInfoEnabled()) {
            VersionService versionService = (VersionService)CMR.getBeanFactory().getBean("versionService");
            LOGGER.info("Starting CMR in version " + versionService.getVersionAsString() + ". Please note that inspectIT does not provide any guarantee on backwards compatibility. Only if the version match exactly we ensure that the components are compatible.");
        }
    }

    private static void checkForCorrectJvmVersion() {
        String version = System.getProperty("java.version");
        Matcher matcher = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)[_-]u?(\\d+)").matcher(version);
        boolean correctVersion = true;
        if (matcher.find() && matcher.groupCount() >= 4) {
            try {
                int majorFirst = Integer.parseInt(matcher.group(1));
                int majorSecond = Integer.parseInt(matcher.group(2));
                int minor = Integer.parseInt(matcher.group(3));
                int update = Integer.parseInt(matcher.group(4));
                if (majorFirst != 1 || majorSecond != 7 || minor != 0) {
                    correctVersion = false;
                }
                if (update < 51 || update > 80) {
                    correctVersion = false;
                }
            }
            catch (NumberFormatException e) {
                correctVersion = false;
            }
        } else {
            correctVersion = false;
        }
        if (!correctVersion) {
            LOGGER.warn("ATTENTION: The version of this JVM (" + version + ") is not compatible with the CMR! Please use the JVM that is provided with the installation!");
        } else {
            LOGGER.info("The version of this JVM (" + version + ") is compatible with the CMR.");
        }
    }

    public static void start(String[] args) {
        startedAsService = true;
        CMR.startCMR();
    }

    public static void stop(String[] args) {
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initLogger() {
        LoggerContext context;
        block9: {
            context = (LoggerContext)LoggerFactory.getILoggerFactory();
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)context);
            context.reset();
            InputStream is = null;
            try {
                Path logPath;
                String logFileLocation = System.getProperty(LOG_FILE_PROPERTY);
                if (null != logFileLocation && Files.exists(logPath = Paths.get(logFileLocation, new String[0]).toAbsolutePath(), new LinkOption[0])) {
                    is = Files.newInputStream(logPath, StandardOpenOption.READ);
                }
                if (null == is && Files.exists(logPath = Paths.get(DEFAULT_LOG_FILE_NAME, new String[0]).toAbsolutePath(), new LinkOption[0])) {
                    is = Files.newInputStream(logPath, StandardOpenOption.READ);
                }
                if (null == is) break block9;
                try {
                    configurator.doConfigure(is);
                }
                catch (JoranException joranException) {
                }
                finally {
                    is.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)context);
        SysOutOverSLF4J.sendSystemOutAndErrToSLF4J();
        MinlogToSLF4JLogger.init();
    }

    public static void main(String[] args) {
        if (args.length == 1 && SystemUtils.IS_OS_WINDOWS) {
            switch (args[0]) {
                case "start": {
                    CMR.start(args);
                    break;
                }
                case "stop": {
                    CMR.stop(args);
                    break;
                }
                default: {
                    CMR.startCMR();
                    break;
                }
            }
        } else {
            CMR.startCMR();
        }
    }

    public static BeanFactory getBeanFactory() {
        return beanFactory;
    }

    public static boolean isStartedAsService() {
        return startedAsService;
    }
}

