/*
 * Decompiled with CFR 0.152.
 */
package info.novatec.inspectit.storage.serializer.impl;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.lang.reflect.Constructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackTraceElementSerializer
extends Serializer<StackTraceElement> {
    private final Constructor<StackTraceElement> constructor;

    public StackTraceElementSerializer() {
        try {
            this.constructor = StackTraceElement.class.getConstructor(String.class, String.class, String.class, Integer.TYPE);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public StackTraceElement read(Kryo kryo, Input input, Class<StackTraceElement> type) {
        String className = input.readString();
        String methodName = input.readString();
        String fileName = input.readString();
        int lineNumber = input.readInt(true);
        try {
            return this.constructor.newInstance(className, methodName, fileName, lineNumber);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void write(Kryo kryo, Output output, StackTraceElement stackTrace) {
        output.writeString(stackTrace.getClassName());
        output.writeString(stackTrace.getMethodName());
        output.writeString(stackTrace.getFileName());
        output.writeInt(stackTrace.getLineNumber(), true);
    }
}

